/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.util.GuiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterHandler {
    public static final String CLUSTER_RESOURCE_NAME = "org.glassfish.cluster.admingui.Strings";
    public static final String RUNNING = "RUNNING";
    public static final String NOT_RUNNING = "NOT_RUNNING";
    public static final String PARTIALLY_RUNNING = "PARTIALLY_RUNNING";

    public static void getClusterStatusSummary(HandlerContext handlerCtx) {
        Map statusMap = (Map)handlerCtx.getInputValue("statusMap");
        int running = 0;
        int notRunning = 0;
        try {
            for (Object value : statusMap.values()) {
                if (value.toString().equals(RUNNING)) {
                    ++running;
                    continue;
                }
                ++notRunning;
            }
            handlerCtx.setOutputValue("numRunning", (Object)GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "cluster.number.instance.running", new String[]{"" + running}));
            handlerCtx.setOutputValue("numNotRunning", (Object)GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "cluster.number.instance.notRunning", new String[]{"" + notRunning}));
        }
        catch (Exception ex) {
            handlerCtx.setOutputValue("status", (Object)GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "cluster.status.unknown"));
        }
    }

    public static void saveInstanceWeight(HandlerContext handlerCtx) {
        List rows = (List)handlerCtx.getInputValue("rows");
        ArrayList<String> errorInstances = new ArrayList<String>();
        Map<String, Object> response = null;
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/servers/server/";
        for (Map oneRow : rows) {
            String instanceName = (String)oneRow.get("Name");
            String endpoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/instanceName";
            HashMap<String, Object> attrsMap = new HashMap<String, Object>();
            attrsMap.put("lbWeight", oneRow.get("LbWeight"));
            try {
                response = RestApiHandlers.restRequest(prefix + instanceName, attrsMap, "post", null);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().severe("Error in saveInstanceWeight ; \nendpoint = " + prefix + instanceName + "attrsMap=" + attrsMap);
                response = null;
            }
            if (response != null) continue;
            errorInstances.add(instanceName);
        }
        if (errorInstances.size() > 0) {
            String details = GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "instance.error.updateWeight", new String[]{"" + errorInstances});
            GuiUtil.handleError(handlerCtx, details);
        }
    }

    public static void clusterAction(HandlerContext handlerCtx) {
        String action = (String)handlerCtx.getInputValue("action");
        List rows = (List)handlerCtx.getInputValue("rows");
        ArrayList<String> errorClusters = new ArrayList<String>();
        Map response = null;
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/";
        for (Map oneRow : rows) {
            String clusterName = (String)oneRow.get("name");
            boolean error = false;
            if (action.equals("delete-cluster")) {
                Map clusterInstanceMap = (Map)handlerCtx.getInputValue("extraInfo");
                List instanceNameList = (List)clusterInstanceMap.get(clusterName);
                for (String instanceName : instanceNameList) {
                    response = ClusterHandler.deleteInstance(instanceName, null);
                    if (response != null) continue;
                    errorClusters.add(clusterName);
                    error = true;
                    break;
                }
                if (error) continue;
            }
            try {
                response = RestApiHandlers.restRequest(prefix + clusterName + "/" + action, null, "post", null);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().severe("Error in clusterAction ; \nendpoint = " + prefix + clusterName + "/" + action + ", attrMap = null");
                response = null;
            }
            if (response != null) continue;
            errorClusters.add(clusterName);
        }
        if (errorClusters.size() > 0) {
            String details = GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "cluster.error.action", new String[]{"" + errorClusters});
            GuiUtil.handleError(handlerCtx, details);
        }
    }

    public static void instanceAction(HandlerContext handlerCtx) {
        String action = (String)handlerCtx.getInputValue("action");
        List rows = (List)handlerCtx.getInputValue("rows");
        ArrayList<String> errorInstances = new ArrayList<String>();
        Map<String, Object> response = null;
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/servers/server/";
        for (Map oneRow : rows) {
            String instanceName = (String)oneRow.get("name");
            if (action.equals("delete-instance")) {
                response = ClusterHandler.deleteInstance(instanceName, (String)oneRow.get("node"));
            } else {
                try {
                    response = RestApiHandlers.restRequest(prefix + instanceName + "/" + action, null, "post", null);
                }
                catch (Exception ex) {
                    GuiUtil.getLogger().severe("Error in instanceAction ; \nendpoint = " + prefix + instanceName + "/" + action + "attrsMap=" + null);
                    response = null;
                }
            }
            if (response != null) continue;
            errorInstances.add(instanceName);
        }
        if (errorInstances.size() > 0) {
            String details = GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "instance.error.action", new String[]{"" + errorInstances});
            GuiUtil.handleError(handlerCtx, details);
        } else if (action.equals("stop-instance")) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public static void nodeAction(HandlerContext handlerCtx) {
        String action = (String)handlerCtx.getInputValue("action");
        HashMap nodeInstanceMap = (HashMap)handlerCtx.getInputValue("nodeInstanceMap");
        if (nodeInstanceMap == null) {
            nodeInstanceMap = new HashMap();
        }
        List rows = (List)handlerCtx.getInputValue("rows");
        ArrayList<String> errorInstances = new ArrayList<String>();
        Map<String, Object> response = null;
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/nodes/node/";
        for (Map oneRow : rows) {
            int code = 500;
            String nodeName = (String)oneRow.get("name");
            List instancesList = (List)nodeInstanceMap.get(nodeName);
            if (instancesList != null && instancesList.size() != 0) {
                GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "nodes.instanceExistError", new String[]{nodeInstanceMap.get(nodeName).toString(), nodeName}));
                return;
            }
            if (action.equals("delete-node")) {
                try {
                    response = RestApiHandlers.restRequest(prefix + nodeName + "/" + action + ".json", null, "post", null);
                }
                catch (Exception ex) {
                    GuiUtil.getLogger().severe("Error in nodeAction ; \nendpoint = " + prefix + nodeName + "/" + action + "attrsMap=" + null);
                    response = null;
                }
            }
            if (response != null) {
                code = (Integer)response.get("responseCode");
                if (code == 200 || code == 201) continue;
                Object body = response.get("responseBody");
                errorInstances.add(body.toString());
                break;
            }
            errorInstances.add(nodeName);
            break;
        }
        if (errorInstances.size() > 0) {
            String details = GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "node.error.delete", new String[]{"" + errorInstances});
            GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), details);
        }
    }

    public static void createClusterInstances(HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        List instanceRow = (List)handlerCtx.getInputValue("instanceRow");
        HashMap<String, Object> attrsMap = new HashMap<String, Object>();
        Map<String, Object> response = null;
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/create-instance";
        for (Map oneInstance : instanceRow) {
            attrsMap.put("name", oneInstance.get("name"));
            attrsMap.put("cluster", clusterName);
            attrsMap.put("node", oneInstance.get("node"));
            try {
                response = RestApiHandlers.restRequest(endpoint, attrsMap, "post", null);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().severe("Error in createCluster ; \nendpoint = " + endpoint + "attrsMap=" + attrsMap);
            }
        }
    }

    public static void getDeploymentTargets(HandlerContext handlerCtx) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("server");
        try {
            List instances;
            List clusterList = (List)handlerCtx.getInputValue("clusterList");
            if (clusterList != null) {
                for (String oneCluster : clusterList) {
                    result.add(oneCluster);
                }
            }
            if ((instances = (List)handlerCtx.getInputValue("listInstanceProps")) != null) {
                for (Map instance : instances) {
                    result.add((String)instance.get("name"));
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe(ex.getLocalizedMessage());
        }
        handlerCtx.setOutputValue("result", result);
    }

    private static Map deleteInstance(String instanceName, String nodeName) {
        try {
            return RestApiHandlers.restRequest(GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + instanceName + "/delete-instance", null, "post", null);
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in deleteInstance ; \nendpoint = " + GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + instanceName + "/delete-instance\n" + "attrsMap=" + null);
            return null;
        }
    }

    public static void listInstances(HandlerContext handlerCtx) {
        ArrayList instances = new ArrayList();
        HashMap statusMap = new HashMap();
        HashMap uptimeMap = new HashMap();
        List keys = (List)handlerCtx.getInputValue("optionKeys");
        List values = (List)handlerCtx.getInputValue("optionValues");
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (keys != null && values != null) {
            for (int i = 0; i < keys.size(); ++i) {
                attrs.put((String)keys.get(i), values.get(i));
            }
        }
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/list-instances";
        try {
            Map<String, Object> responseMap = RestApiHandlers.restRequest(endpoint, attrs, "GET", handlerCtx);
            Map extraPropertiesMap = (Map)((Map)responseMap.get("data")).get("extraProperties");
            if (extraPropertiesMap != null) {
                List instanceList = (List)extraPropertiesMap.get("instanceList");
                for (Map oneInstance : instanceList) {
                    instances.add(oneInstance.get("name"));
                    statusMap.put(oneInstance.get("name"), oneInstance.get("status"));
                    uptimeMap.put(oneInstance.get("name"), oneInstance.get("uptime"));
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in listInstances ; \nendpoint = " + endpoint + "\nattrs=" + attrs);
        }
        handlerCtx.setOutputValue("instances", instances);
        handlerCtx.setOutputValue("statusMap", statusMap);
        handlerCtx.setOutputValue("uptimeMap", uptimeMap);
        handlerCtx.setOutputValue("listEmpty", (Object)instances.isEmpty());
    }

    public static void getInstanceInfoHandler(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        handlerCtx.setOutputValue("info", ClusterHandler.getInstanceInfo(instanceName));
    }

    public static Map<String, Object> getInstanceInfo(final String instanceName) {
        Map iiopListener;
        HashMap<String, Object> info = new HashMap<String, Object>();
        String REST_URL = (String)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("REST_URL");
        String instanceUrl = REST_URL + "/servers/server/" + instanceName;
        Map<String, Object> result = RestApiHandlers.restRequest(instanceUrl, null, "get", null);
        String instanceConfig = (String)((Map)ClusterHandler.getExtraPropertiesEntry(result, "entity")).get("configRef");
        result = RestApiHandlers.restRequest(REST_URL + "/list-instances", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("id", instanceName);
            }
        }, "get", null);
        List instanceList = (List)ClusterHandler.getExtraPropertiesEntry(result, "instanceList");
        String serverStatus = (String)((Map)instanceList.get(0)).get("status");
        String configUrl = REST_URL + "/configs/config/" + instanceConfig;
        result = RestApiHandlers.restRequest(configUrl, null, "get", null);
        Map config = (Map)((Map)result.get("data")).get("extraProperties");
        result = RestApiHandlers.restRequest(configUrl + "/java-config/generate-jvm-report", null, "post", null);
        Map<String, String> jvmReport = ClusterHandler.buildExtraProperties((String)((Map)result.get("data")).get("message"));
        String version = jvmReport.get("glassfish.version");
        String configRoot = jvmReport.get("com.sun.aas.configRoot");
        result = RestApiHandlers.restRequest(configUrl + "/java-config", null, "get", null);
        Map entity = (Map)ClusterHandler.getExtraPropertiesEntry(result, "entity");
        result = RestApiHandlers.restRequest(configUrl + "/network-config/network-listeners/network-listener", null, "get", null);
        Map children = (Map)ClusterHandler.getExtraPropertiesEntry(result, "childResources");
        if (children != null && !children.isEmpty()) {
            ArrayList httpPorts = new ArrayList();
            for (String child : children.values()) {
                result = RestApiHandlers.restRequest(child, null, "get", null);
                iiopListener = (Map)ClusterHandler.getExtraPropertiesEntry(result, "entity");
                httpPorts.add(iiopListener.get("port"));
            }
            info.put("httpPorts", httpPorts);
        }
        if ((children = (Map)ClusterHandler.getExtraPropertiesEntry(result = RestApiHandlers.restRequest(configUrl + "/iiop-service/iiop-listener", null, "get", null), "childResources")) != null && !children.isEmpty()) {
            ArrayList iiopPorts = new ArrayList();
            for (String child : children.values()) {
                result = RestApiHandlers.restRequest(child, null, "get", null);
                iiopListener = (Map)ClusterHandler.getExtraPropertiesEntry(result, "entity");
                iiopPorts.add(iiopListener.get("port"));
            }
            info.put("iiopPorts", iiopPorts);
        }
        info.put("config", instanceConfig);
        info.put("status", serverStatus);
        info.put("version", version);
        info.put("configRoot", configRoot);
        info.put("debugEnabled", (String)entity.get("debugEnabled"));
        return info;
    }

    protected static Object getExtraPropertiesEntry(Map<String, Object> responseMap, String epKey) {
        Map data = (Map)responseMap.get("data");
        Map ep = (Map)data.get("extraProperties");
        return ep.get(epKey);
    }

    private static Map<String, String> buildExtraProperties(String jvmReport) {
        String[] lines;
        String SEP = System.getProperty("line.separator");
        HashMap<String, String> report = new HashMap<String, String>();
        for (String line : lines = jvmReport.split(SEP)) {
            int valueSepIdx = line.indexOf("=");
            if (valueSepIdx == -1) {
                valueSepIdx = line.indexOf(":");
            }
            if (valueSepIdx <= -1) continue;
            String key = line.substring(0, valueSepIdx).trim();
            String value = line.substring(valueSepIdx + 1).trim();
            report.put(key, value);
        }
        return report;
    }

    public static void getClusterNameForInstance(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        try {
            ArrayList<String> clusterList = new ArrayList<String>(RestApiHandlers.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster").keySet());
            for (String oneCluster : clusterList) {
                String encodedClusterName = URLEncoder.encode(oneCluster, "UTF-8");
                ArrayList<String> serverRefs = new ArrayList<String>(RestApiHandlers.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + URLEncoder.encode(oneCluster, "UTF-8") + "/server-ref").keySet());
                if (!serverRefs.contains(instanceName)) continue;
                handlerCtx.setOutputValue("clusterName", (Object)oneCluster);
                return;
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().info("Error occurs at getClusterNameForInstance");
            ex.printStackTrace();
        }
    }
}

