/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.TabularData;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.Property;
import org.glassfish.admin.amx.monitoring.ServerMon;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.V3AMX;
import org.glassfish.admingui.common.util.V3AMXUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppHandlers {
    public static void getAppclinetLaunchURL(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String moduleName = (String)handlerCtx.getInputValue("moduleName");
        String appClientLaunch = V3AMX.getInstance().getRuntime().getRelativeJWSURI(appName, moduleName);
        if (!GuiUtil.isEmpty(appClientLaunch)) {
            String httpLink = V3AMXUtil.getLaunchLink((String)GuiUtil.getSessionValue("serverName"), appName);
            handlerCtx.setOutputValue("url", (Object)(httpLink + appClientLaunch));
        }
    }

    public static void getEndpointInfo(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String moduleName = (String)handlerCtx.getInputValue("moduleName");
        String componentName = (String)handlerCtx.getInputValue("subComponentName");
        String type = (String)handlerCtx.getInputValue("type");
        HashMap<String, Object> result = new HashMap<String, Object>();
        TabularData endpointMap = WebAppHandlers.getEndpointMap(appName, moduleName, componentName, type);
        if (endpointMap.isEmpty()) {
            handlerCtx.setOutputValue("result", result);
        }
        result.put("appName", (String)endpointMap.get(new Object[]{"appName"}).get("value"));
        result.put("endpointName", (String)endpointMap.get(new Object[]{"endpointName"}).get("value"));
        result.put("namespace", (String)endpointMap.get(new Object[]{"implClass"}).get("value"));
        result.put("serviceName", (String)endpointMap.get(new Object[]{"namespace"}).get("value"));
        result.put("portName", (String)endpointMap.get(new Object[]{"portName"}).get("value"));
        result.put("implClass", (String)endpointMap.get(new Object[]{"implClass"}).get("value"));
        result.put("address", (String)endpointMap.get(new Object[]{"address"}).get("value"));
        result.put("wsdl", (String)endpointMap.get(new Object[]{"wsdl"}).get("value"));
        result.put("tester", (String)endpointMap.get(new Object[]{"tester"}).get("value"));
        result.put("implType", (String)endpointMap.get(new Object[]{"implType"}).get("value"));
        result.put("deploymentType", (String)endpointMap.get(new Object[]{"deploymentType"}).get("value"));
        String launchLink = V3AMXUtil.getLaunchLink((String)GuiUtil.getSessionValue("serverName"), appName);
        if (GuiUtil.isEmpty(launchLink)) {
            result.put("disableTester", "true");
            result.put("hasWsdlLink", false);
        } else {
            result.put("disableTester", "false");
            result.put("hasWsdlLink", true);
            result.put("testLink", launchLink + result.get("tester"));
            result.put("wsdlLink", launchLink + result.get("wsdl"));
        }
        GuiUtil.getLogger().fine("Endpoint Info for " + appName + "#" + componentName + " : " + result);
        handlerCtx.setOutputValue("result", result);
    }

    private static TabularData getEndpointMap(String appName, String moduleName, String componentName, String type) {
        ServerMon serverMon = (ServerMon)((ServerMon)V3AMX.getInstance().getDomainRoot().getMonitoringRoot().getServerMon().get("server")).as(ServerMon.class);
        AMXConfigProxy webDeployment = (AMXConfigProxy)((AMXProxy)serverMon.childrenMap("web-service-mon").get("webservices-deployment")).as(AMXConfigProxy.class);
        Object[] params = new String[]{appName, moduleName, componentName};
        String[] sig = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        TabularData endpointMap = null;
        endpointMap = type.equalsIgnoreCase("Servlet") ? (TabularData)webDeployment.invokeOp("getServlet109Endpoint", params, sig) : (TabularData)webDeployment.invokeOp("getEjb109Endpoint", params, sig);
        return endpointMap;
    }

    private static String getA(Map<String, Property> attrs, String key) {
        Property val = attrs.get(key);
        return val == null ? "" : val.getValue();
    }

    public static void EnsureDefaultWebModule(HandlerContext handlerCtx) throws Exception {
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String vsName = (String)handlerCtx.getInputValue("vsName");
        List instanceList = (List)handlerCtx.getInputValue("instanceList");
        Map vsAttrs = RestApiHandlers.getAttributesMap(endpoint + "/" + vsName);
        String webModule = (String)vsAttrs.get("DefaultWebModule");
        if (GuiUtil.isEmpty(webModule)) {
            return;
        }
        String appName = webModule;
        int index = webModule.indexOf("#");
        if (index != -1) {
            appName = webModule.substring(0, index);
        }
        String serverEndPoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/";
        for (Object serverName : instanceList) {
            String apprefEndpoint = serverEndPoint + serverName + "/application-ref/" + appName;
            Map apprefAttrs = RestApiHandlers.getAttributesMap(apprefEndpoint + "/" + vsName);
            String vsStr = (String)apprefAttrs.get("VirtualServers");
            List vsList = GuiUtil.parseStringList(vsStr, ",");
            if (vsList.contains(vsName)) continue;
            vsStr = vsStr + "," + vsName;
            apprefAttrs.put("VirtualServers", vsStr);
            RestResponse response = RestApiHandlers.sendUpdateRequest(apprefEndpoint, apprefAttrs, null, null, null);
            if (!response.isSuccess()) {
                GuiUtil.getLogger().severe("Update virtual server failed.  parent=" + apprefEndpoint + "; attrsMap =" + apprefAttrs);
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
                return;
            }
            ArrayList<String> targets = new ArrayList<String>();
            targets.add("domain");
            DeployUtil.reloadApplication(appName, targets, handlerCtx);
        }
    }

    public static void checkVsOfAppRef(HandlerContext handlerCtx) throws Exception {
        String configUrl = GuiUtil.getSessionValue("REST_URL") + "/configs/config/";
        ArrayList<String> configs = new ArrayList<String>(RestApiHandlers.getChildMap(configUrl).keySet());
        ArrayList vsList = new ArrayList();
        for (Object e : configs) {
            String string = configUrl + e + "/http-service/virtual-server";
            ArrayList<String> vsNames = new ArrayList<String>(RestApiHandlers.getChildMap(string).keySet());
            for (Object e2 : vsNames) {
                if (vsList.contains(e2)) continue;
                vsList.add(e2);
            }
        }
        ArrayList<String> servers = new ArrayList<String>(RestApiHandlers.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/servers/server").keySet());
        for (Object e : servers) {
            String serverEndpoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + e;
            ArrayList<String> appRefs = new ArrayList<String>(RestApiHandlers.getChildMap(serverEndpoint + "/application-ref").keySet());
            for (Object e3 : appRefs) {
                String apprefEndpoint = serverEndpoint + "/application-ref/" + e3;
                Map apprefAttrs = RestApiHandlers.getAttributesMap(apprefEndpoint);
                String vsStr = (String)apprefAttrs.get("VirtualServers");
                List lvsList = GuiUtil.parseStringList(vsStr, ",");
                boolean changed = false;
                String newVS = "";
                for (String oneVs : lvsList) {
                    if (!vsList.contains(oneVs)) {
                        changed = true;
                        continue;
                    }
                    newVS = newVS + "," + oneVs;
                }
                if (!changed) continue;
                newVS = newVS.substring(1);
                apprefAttrs.put("VirtualServers", vsStr);
                RestResponse response = RestApiHandlers.sendUpdateRequest(apprefEndpoint, apprefAttrs, null, null, null);
                if (response.isSuccess()) continue;
                GuiUtil.getLogger().severe("Update virtual server failed.  parent=" + apprefEndpoint + "; attrsMap =" + apprefAttrs);
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
                return;
            }
        }
    }

    private static String calContextRoot(String contextRoot) {
        String ctxRoot = "";
        ctxRoot = contextRoot == null || contextRoot.equals("") || contextRoot.equals("/") ? "/" : (contextRoot.startsWith("/") ? contextRoot : "/" + contextRoot);
        return ctxRoot;
    }
}

