/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.RestUtil;

public class InstanceHandler {
    private static final String PROPERTY_VALUE = "value";

    public static void getDebugInfo(HandlerContext handlerCtx) {
        String debugOptions = (String)handlerCtx.getInputValue("debugOptions");
        String debugPort = "";
        StringTokenizer tokens = new StringTokenizer(debugOptions, ",");
        String doption = "";
        while (tokens.hasMoreTokens()) {
            int pos;
            doption = tokens.nextToken().trim();
            if (!doption.startsWith("address") || (pos = doption.indexOf("=")) < 0) continue;
            debugPort = doption.substring(pos + 1).trim();
            break;
        }
        Boolean debugEnabled = (Boolean)handlerCtx.getInputValue("debugEnabled");
        String msg = "true".equals("" + debugEnabled) ? GuiUtil.getMessage("inst.debugEnabled") + debugPort : GuiUtil.getMessage("inst.notEnabled");
        handlerCtx.setOutputValue("debugInfo", (Object)msg);
    }

    public static void getJvmOptionsValues(HandlerContext handlerCtx) {
        try {
            ArrayList list = InstanceHandler.getJvmOptions(handlerCtx);
            handlerCtx.setOutputValue("result", GuiUtil.convertArrayToListOfMap(list.toArray(), PROPERTY_VALUE));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("result", new HashMap());
        }
    }

    public static ArrayList getJvmOptions(HandlerContext handlerCtx) {
        Map attrs;
        HashMap result;
        ArrayList list;
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        if (!endpoint.endsWith(".json")) {
            endpoint = endpoint + ".json";
        }
        if ((list = (ArrayList)((Map)(result = (HashMap)RestUtil.restRequest(endpoint, attrs = (Map)handlerCtx.getInputValue("attrs"), "get", handlerCtx, false).get("data")).get("extraProperties")).get("leafList")) == null) {
            list = new ArrayList();
        }
        return list;
    }

    public static void saveJvmOptionValues(HandlerContext handlerCtx) {
        try {
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            List options = (List)handlerCtx.getInputValue("options");
            HashMap<String, String> payload = new HashMap<String, String>();
            payload.put("target", (String)handlerCtx.getInputValue("target"));
            InstanceHandler.deleteJvmOptions(handlerCtx);
            for (Map oneRow : options) {
                String str = (String)oneRow.get(PROPERTY_VALUE);
                ArrayList kv = InstanceHandler.getKeyValuePair(str);
                payload.put((String)kv.get(0), (String)kv.get(1));
                InstanceHandler.addJvmOption(endpoint, payload);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void addJvmOption(String endpoint, Map payload) throws Exception {
        RestResponse response;
        if (endpoint.contains("profiler")) {
            payload.put("profiler", "true");
        }
        if (!(response = RestUtil.post(endpoint, payload)).isSuccess()) {
            throw new Exception(response.getResponseBody());
        }
    }

    public static void deleteJvmOptions(HandlerContext handlerCtx) throws Exception {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String target = (String)handlerCtx.getInputValue("target");
        payload.put("target", target);
        ArrayList list = InstanceHandler.getJvmOptions(handlerCtx);
        for (Object s : list) {
            RestResponse response;
            String str = (String)s;
            ArrayList kv = InstanceHandler.getKeyValuePair(str);
            payload.put((String)kv.get(0), kv.get(1));
            if (endpoint.contains("/profiler")) {
                endpoint = endpoint.substring(0, endpoint.indexOf("/profiler")) + "/jvm-options";
                payload.put("profiler", "true");
            }
            if ((response = RestUtil.delete(endpoint, payload)).isSuccess()) continue;
            throw new Exception(response.getResponseBody());
        }
    }

    public static ArrayList getKeyValuePair(String str) {
        ArrayList<String> list = new ArrayList<String>(2);
        int index = str.indexOf("=");
        String key = "";
        String value = "";
        if (index != -1) {
            key = str.substring(0, str.indexOf("="));
            value = str.substring(str.indexOf("=") + 1, str.length());
        } else {
            key = str;
        }
        if (key.startsWith("-XX:")) {
            key = "\"" + key + "\"";
        }
        list.add(0, key);
        list.add(1, value);
        return list;
    }
}

