/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingHandlers {
    private static final List<String> levels = new ArrayList<String>();

    public static void getLoggerLevels(HandlerContext handlerCtx) {
        Map loggerLevels = (Map)handlerCtx.getInputValue("loggerLevels");
        ArrayList result = new ArrayList();
        if (loggerLevels != null) {
            for (Map.Entry e : loggerLevels.entrySet()) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("loggerName", e.getKey());
                oneRow.put("level", e.getValue());
                oneRow.put("selected", false);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("loggerList", result);
    }

    public static void changeLoggerLevels(HandlerContext handlerCtx) {
        List obj;
        String newLogLevel = (String)handlerCtx.getInputValue("newLogLevel");
        List allRows = obj = (List)handlerCtx.getInputValue("allRows");
        if (GuiUtil.isEmpty(newLogLevel)) {
            handlerCtx.setOutputValue("newList", (Object)allRows);
            return;
        }
        for (Map oneRow : allRows) {
            boolean selected = (Boolean)oneRow.get("selected");
            if (!selected) continue;
            oneRow.put("level", newLogLevel);
            oneRow.put("selected", false);
        }
        handlerCtx.setOutputValue("newList", (Object)allRows);
    }

    public static void updateLoggerLevels(HandlerContext handlerCtx) {
        block3: {
            List allRows = (List)handlerCtx.getInputValue("allRows");
            String config = (String)handlerCtx.getInputValue("config");
            HashMap<String, Object> props = new HashMap<String, Object>();
            try {
                for (Map oneRow : allRows) {
                    props.put("id", oneRow.get("loggerName") + "=" + oneRow.get("level"));
                    props.put("target", config);
                    RestUtil.restRequest((String)GuiUtil.getSessionValue("REST_URL") + "/set-log-levels.json", props, "POST", null, false, true);
                }
                LoggingHandlers.deleteLoggers(allRows, config);
            }
            catch (Exception ex) {
                GuiUtil.handleException(handlerCtx, ex);
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block3;
                ex.printStackTrace();
            }
        }
    }

    public static void deleteLoggers(List<Map<String, Object>> allRows, String configName) {
        ArrayList<String> newLoggers = new ArrayList<String>();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("target", configName);
        Map<String, Object> result = RestUtil.restRequest((String)GuiUtil.getSessionValue("REST_URL") + "/list-log-levels.json", attrs, "GET", null, false);
        List oldLoggers = (List)((HashMap)((HashMap)result.get("data")).get("extraProperties")).get("loggers");
        for (Map<String, Object> oneRow : allRows) {
            newLoggers.add((String)oneRow.get("loggerName"));
        }
        attrs = new HashMap();
        for (String logger : oldLoggers) {
            if (newLoggers.contains(logger)) continue;
            attrs.put("id", logger);
            attrs.put("target", configName);
            RestUtil.restRequest((String)GuiUtil.getSessionValue("REST_URL") + "/delete-log-levels", attrs, "POST", null, false);
        }
    }

    public static void saveLoggingAttributes(HandlerContext handlerCtx) {
        block4: {
            Map attrs = (Map)handlerCtx.getInputValue("attrs");
            String attrsInUI = (String)handlerCtx.getInputValue("attrsInUI");
            String[] attrNames = attrsInUI.split(",");
            String config = (String)handlerCtx.getInputValue("config");
            HashMap<String, Object> props = new HashMap<String, Object>();
            try {
                for (String key : attrNames) {
                    if ((key.equals("com.sun.enterprise.server.logging.SyslogHandler.useSystemLogging") || key.equals("com.sun.enterprise.server.logging.GFFileHandler.logtoConsole")) && attrs.get(key) == null) {
                        attrs.put(key, "false");
                    }
                    props.put("id", key + "='" + attrs.get(key) + "'");
                    props.put("target", config);
                    RestUtil.restRequest((String)GuiUtil.getSessionValue("REST_URL") + "/set-log-attributes.json", props, "POST", null, false, true);
                }
            }
            catch (Exception ex) {
                GuiUtil.handleException(handlerCtx, ex);
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block4;
                ex.printStackTrace();
            }
        }
    }

    public static void getValidLogLevels(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("loggerList", levels);
    }

    static {
        levels.add("OFF");
        levels.add("SEVERE");
        levels.add("WARNING");
        levels.add("INFO");
        levels.add("CONFIG");
        levels.add("FINE");
        levels.add("FINER");
        levels.add("FINEST");
    }
}

