/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.security;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.module.ServerAuthModule;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.jvnet.hk2.component.Habitat;

public class AdminConsoleAuthModule
implements ServerAuthModule {
    public static final String TOKEN_ADMIN_LISTENER_PORT = "${ADMIN_LISTENER_PORT}";
    private CallbackHandler handler = null;
    private String restURL = null;
    private String loginPage = null;
    private String loginErrorPage = null;
    private static final Class[] SUPPORTED_MESSAGE_TYPES = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private static final String SAVED_SUBJECT = "Saved_Subject";
    private static final String USER_NAME = "userName";
    private static final String RESPONSE_TYPE = "application/json";
    public static final String REST_SERVER_NAME = "serverName";
    public static final String REST_SERVER_PORT = "serverPort";
    public static final String REST_TOKEN = "__rTkn__";

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.handler = handler;
        if (options != null) {
            String host;
            this.restURL = (String)options.get("restAuthURL");
            if (this.restURL == null) {
                throw new AuthException("'restAuthURL' must be supplied as a property in the provider-config in the domain.xml file!");
            }
            this.loginPage = (String)options.get("loginPage");
            if (this.loginPage == null) {
                throw new AuthException("'loginPage' must be supplied as a property in the provider-config in the domain.xml file!");
            }
            this.loginErrorPage = (String)options.get("loginErrorPage");
            if (this.loginErrorPage == null) {
                throw new AuthException("'loginErrorPage' must be supplied as a property in the provider-config in the domain.xml file!");
            }
            Habitat habitat = SecurityServicesUtil.getInstance().getHabitat();
            Domain domain = (Domain)habitat.getByType(Domain.class);
            NetworkListener adminListener = domain.getServerNamed("server").getConfig().getNetworkConfig().getNetworkListener("admin-listener");
            if (this.restURL.contains(TOKEN_ADMIN_LISTENER_PORT)) {
                this.restURL = this.restURL.replace(TOKEN_ADMIN_LISTENER_PORT, adminListener.getPort());
            }
            if (!"localhost".equals(host = adminListener.getAddress()) && !"0.0.0.0".equals(host)) {
                this.restURL = this.restURL.replace("localhost", adminListener.getAddress());
            }
            SecureAdmin secureAdmin = (SecureAdmin)habitat.getComponent(SecureAdmin.class);
            if (this.restURL.startsWith("http:") && SecureAdmin.Util.isEnabled((SecureAdmin)secureAdmin)) {
                this.restURL = this.restURL.replace("http:", "https:");
            }
        }
    }

    public Class[] getSupportedMessageTypes() {
        return SUPPORTED_MESSAGE_TYPES;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        Subject savedClientSubject;
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        if (!this.isMandatory(messageInfo) && !request.getRequestURI().endsWith("/j_security_check")) {
            return AuthStatus.SUCCESS;
        }
        HttpSession session = request.getSession(true);
        if (session != null && (savedClientSubject = (Subject)session.getValue(SAVED_SUBJECT)) != null) {
            clientSubject.getPrincipals().addAll(savedClientSubject.getPrincipals());
            clientSubject.getPublicCredentials().addAll(savedClientSubject.getPublicCredentials());
            clientSubject.getPrivateCredentials().addAll(savedClientSubject.getPrivateCredentials());
            return AuthStatus.SUCCESS;
        }
        if (session.getValue(REST_SERVER_NAME) == null) {
            URL url = null;
            try {
                url = new URL(this.restURL);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Unable to parse REST URL: (" + this.restURL + ")", ex);
            }
            session.putValue(REST_SERVER_NAME, (Object)url.getHost());
            session.putValue(REST_SERVER_PORT, (Object)url.getPort());
        }
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (username == null || password == null || !request.getMethod().equalsIgnoreCase("post")) {
            RequestDispatcher rd = request.getRequestDispatcher(this.loginPage);
            try {
                RestUtil.initialize(null);
                rd.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception ex) {
                AuthException ae = new AuthException();
                ae.initCause((Throwable)ex);
                throw ae;
            }
            return AuthStatus.SEND_CONTINUE;
        }
        Client client2 = Client.create();
        RestUtil.initialize(client2);
        WebResource webResource = client2.resource(this.restURL);
        webResource.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        ClientResponse resp = (ClientResponse)webResource.accept(new String[]{RESPONSE_TYPE}).post(ClientResponse.class);
        RestResponse restResp = RestResponse.getRestResponse(resp);
        if (restResp.isSuccess()) {
            CallerPrincipalCallback cpCallback = new CallerPrincipalCallback(clientSubject, username);
            try {
                this.handler.handle(new Callback[]{cpCallback});
            }
            catch (Exception ex) {
                AuthException ae = new AuthException();
                ae.initCause((Throwable)ex);
                throw ae;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration names = session.getAttributeNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                map.put(key, session.getAttribute(key));
            }
            session.invalidate();
            session = request.getSession(true);
            for (Map.Entry e : map.entrySet()) {
                session.setAttribute((String)e.getKey(), e.getValue());
            }
            if (session != null) {
                Object obj = restResp.getResponse().get("data");
                Map extraProperties = null;
                if (obj != null && obj instanceof Map && (obj = ((Map)obj).get("extraProperties")) != null && obj instanceof Map) {
                    extraProperties = (Map)obj;
                }
                if (extraProperties != null) {
                    session.putValue(REST_TOKEN, extraProperties.get("token"));
                }
                session.putValue(SAVED_SUBJECT, (Object)clientSubject);
                session.putValue(USER_NAME, (Object)username);
            }
            try {
                response.sendRedirect(response.encodeRedirectURL("/index.jsf"));
            }
            catch (Exception ex) {
                AuthException ae = new AuthException();
                ae.initCause((Throwable)ex);
                throw ae;
            }
            return AuthStatus.SEND_CONTINUE;
        }
        RequestDispatcher rd = request.getRequestDispatcher(this.loginErrorPage);
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            AuthException ae = new AuthException();
            ae.initCause((Throwable)ex);
            throw ae;
        }
        return AuthStatus.SEND_FAILURE;
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return AuthStatus.SUCCESS;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
    }

    private boolean isMandatory(MessageInfo messageInfo) {
        return Boolean.valueOf((String)messageInfo.getMap().get("javax.security.auth.message.MessagePolicy.isMandatory"));
    }
}

