/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.config.Property;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="connector-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="create.connector.connection.pool")
public class ConnectorConnectionPoolManager
implements ResourceManager {
    @Inject
    Applications applications;
    @Inject
    ConnectorRuntime connectorRuntime;
    private static final String DESCRIPTION = "description";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectorConnectionPoolManager.class);
    private String raname = null;
    private String connectiondefinition = null;
    private String steadypoolsize = "8";
    private String maxpoolsize = "32";
    private String maxwait = "60000";
    private String poolresize = "2";
    private String idletimeout = "300";
    private String isconnectvalidatereq = Boolean.FALSE.toString();
    private String failconnection = Boolean.FALSE.toString();
    private String validateAtmostOncePeriod = "0";
    private String connectionLeakTimeout = "0";
    private String connectionLeakReclaim = Boolean.FALSE.toString();
    private String connectionCreationRetryAttempts = "0";
    private String connectionCreationRetryInterval = "10";
    private String lazyConnectionEnlistment = Boolean.FALSE.toString();
    private String lazyConnectionAssociation = Boolean.FALSE.toString();
    private String associateWithThread = Boolean.FALSE.toString();
    private String matchConnections = Boolean.FALSE.toString();
    private String maxConnectionUsageCount = "0";
    private String description = null;
    private String poolname = null;

    public String getResourceType() {
        return "connector-connection-pool";
    }

    public ResourceStatus create(Resources resources, HashMap attrList, final Properties props, Server targetServer) throws Exception {
        String msg;
        String msg2;
        this.setParams(attrList);
        if (this.poolname == null) {
            String msg3 = localStrings.getLocalString("create.connector.connection.pool.noJndiName", "No pool name defined for connector connection pool.");
            return new ResourceStatus(1, msg3);
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof ConnectorConnectionPool) || !((ConnectorConnectionPool)resource).getName().equals(this.poolname)) continue;
            String msg4 = localStrings.getLocalString("create.connector.connection.pool.duplicate", "A connector connection pool named {0} already exists.", new Object[]{this.poolname});
            return new ResourceStatus(1, msg4);
        }
        if (this.applications == null) {
            msg2 = localStrings.getLocalString("noApplications", "No applications found.");
            return new ResourceStatus(1, msg2);
        }
        try {
            ResourceStatus status = this.validateCnctorConnPoolAttrList(this.raname, this.connectiondefinition);
            if (status.getStatus() == 1) {
                return status;
            }
        }
        catch (ConnectorRuntimeException cre) {
            Logger.getLogger(ConnectorConnectionPoolManager.class.getName()).log(Level.SEVERE, "Could not find connection definitions from ConnectorRuntime for resource adapter " + this.raname, cre);
            msg = localStrings.getLocalString("create.connector.connection.pool.noConnDefs", "Could not find connection definitions for resource adapter {0}", new Object[]{this.raname}) + " " + cre.getLocalizedMessage();
            return new ResourceStatus(1, msg);
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    ConnectorConnectionPool newResource = (ConnectorConnectionPool)param.createChild(ConnectorConnectionPool.class);
                    newResource.setResourceAdapterName(ConnectorConnectionPoolManager.this.raname);
                    newResource.setConnectionDefinitionName(ConnectorConnectionPoolManager.this.connectiondefinition);
                    newResource.setValidateAtmostOncePeriodInSeconds(ConnectorConnectionPoolManager.this.validateAtmostOncePeriod);
                    newResource.setSteadyPoolSize(ConnectorConnectionPoolManager.this.steadypoolsize);
                    newResource.setPoolResizeQuantity(ConnectorConnectionPoolManager.this.poolresize);
                    newResource.setMaxWaitTimeInMillis(ConnectorConnectionPoolManager.this.maxwait);
                    newResource.setMaxPoolSize(ConnectorConnectionPoolManager.this.maxpoolsize);
                    newResource.setMaxConnectionUsageCount(ConnectorConnectionPoolManager.this.maxConnectionUsageCount);
                    newResource.setMatchConnections(ConnectorConnectionPoolManager.this.matchConnections);
                    newResource.setLazyConnectionEnlistment(ConnectorConnectionPoolManager.this.lazyConnectionEnlistment);
                    newResource.setLazyConnectionAssociation(ConnectorConnectionPoolManager.this.lazyConnectionAssociation);
                    newResource.setIsConnectionValidationRequired(ConnectorConnectionPoolManager.this.isconnectvalidatereq);
                    newResource.setIdleTimeoutInSeconds(ConnectorConnectionPoolManager.this.idletimeout);
                    newResource.setFailAllConnections(ConnectorConnectionPoolManager.this.failconnection);
                    newResource.setConnectionLeakTimeoutInSeconds(ConnectorConnectionPoolManager.this.connectionLeakTimeout);
                    newResource.setConnectionLeakReclaim(ConnectorConnectionPoolManager.this.connectionLeakReclaim);
                    newResource.setConnectionCreationRetryIntervalInSeconds(ConnectorConnectionPoolManager.this.connectionCreationRetryInterval);
                    newResource.setConnectionCreationRetryAttempts(ConnectorConnectionPoolManager.this.connectionCreationRetryAttempts);
                    newResource.setAssociateWithThread(ConnectorConnectionPoolManager.this.associateWithThread);
                    if (ConnectorConnectionPoolManager.this.description != null) {
                        newResource.setDescription(ConnectorConnectionPoolManager.this.description);
                    }
                    newResource.setName(ConnectorConnectionPoolManager.this.poolname);
                    if (props != null) {
                        for (Map.Entry<Object, Object> e : props.entrySet()) {
                            Property prop = (Property)newResource.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)resources);
        }
        catch (TransactionFailure tfe) {
            Logger.getLogger(ConnectorConnectionPoolManager.class.getName()).log(Level.SEVERE, "create-connector-connection-pool failed", tfe);
            msg = localStrings.getLocalString("create.connector.connection.pool.fail", "Connector connection pool {0} create failed: {1}", new Object[]{this.poolname}) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg);
        }
        msg2 = localStrings.getLocalString("create.connector.connection.pool.success", "Connector connection pool {0} created successfully", new Object[]{this.poolname});
        return new ResourceStatus(0, msg2);
    }

    public void setParams(HashMap attrList) {
        this.raname = (String)attrList.get("resource-adapter-name");
        this.connectiondefinition = (String)attrList.get("connection-definition-name");
        this.steadypoolsize = (String)attrList.get("steady-pool-size");
        this.maxpoolsize = (String)attrList.get("max-pool-size");
        this.maxwait = (String)attrList.get("max-wait-time-in-millis");
        this.poolresize = (String)attrList.get("pool-resize-quantity");
        this.idletimeout = (String)attrList.get("idle-timeout-in-seconds");
        this.isconnectvalidatereq = (String)attrList.get("is-connection-validation-required");
        this.failconnection = (String)attrList.get("fail-all-connections");
        this.validateAtmostOncePeriod = (String)attrList.get("validate-atmost-once-period-in-seconds");
        this.connectionLeakTimeout = (String)attrList.get("connection-leak-timeout-in-seconds");
        this.connectionLeakReclaim = (String)attrList.get("connection-leak-reclaim");
        this.connectionCreationRetryAttempts = (String)attrList.get("connection-creation-retry-attempts");
        this.connectionCreationRetryInterval = (String)attrList.get("connection-creation-retry-interval-in-seconds");
        this.lazyConnectionEnlistment = (String)attrList.get("lazy-connection-enlistment");
        this.lazyConnectionAssociation = (String)attrList.get("lazy-connection-association");
        this.associateWithThread = (String)attrList.get("associate-with-thread");
        this.matchConnections = (String)attrList.get("match-connections");
        this.maxConnectionUsageCount = (String)attrList.get("max-connection-usage-count");
        this.description = (String)attrList.get(DESCRIPTION);
        this.poolname = (String)attrList.get("name");
    }

    private ResourceStatus validateCnctorConnPoolAttrList(String raName, String connDef) throws ConnectorRuntimeException {
        ResourceStatus status = this.isValidRAName(raName);
        if (status.getStatus() == 0 && !this.isValidConnectionDefinition(connDef, raName)) {
            String msg = localStrings.getLocalString("admin.mbeans.rmb.invalid_ra_connectdef_not_found", "Invalid connection definition. Connector Module with connection definition {0} not found.", new Object[]{connDef});
            status = new ResourceStatus(1, msg);
        }
        return status;
    }

    private ResourceStatus isValidRAName(String raName) {
        ResourceStatus status = new ResourceStatus(0, "");
        if (raName == null || raName.equals("")) {
            String msg = localStrings.getLocalString("admin.mbeans.rmb.null_res_adapter", "Resource Adapter Name is null.");
            status = new ResourceStatus(1, msg);
        } else if (!raName.equals("jmsra") && !raName.equals("jaxr-ra")) {
            int indx = raName.indexOf("#");
            if (indx != -1) {
                String appName = raName.substring(0, indx);
                Application app = (Application)this.applications.getModule(Application.class, appName);
                if (app == null) {
                    String msg = localStrings.getLocalString("admin.mbeans.rmb.invalid_ra_app_not_found", "Invalid raname. Application with name {0} not found.", new Object[]{appName});
                    status = new ResourceStatus(1, msg);
                }
            } else {
                Application app = (Application)this.applications.getModule(Application.class, raName);
                if (app == null) {
                    String msg = localStrings.getLocalString("admin.mbeans.rmb.invalid_ra_cm_not_found", "Invalid raname. Connector Module with name {0} not found.", new Object[]{raName});
                    status = new ResourceStatus(1, msg);
                }
            }
        }
        return status;
    }

    private boolean isValidConnectionDefinition(String connectionDef, String raName) throws ConnectorRuntimeException {
        String[] names = this.connectorRuntime.getConnectionDefinitionNames(raName);
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(connectionDef)) continue;
            return true;
        }
        return false;
    }
}

