/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.javaee.services.ResourceManager;

public class ConnectorApplication
implements ApplicationContainer {
    private static Logger _logger = LogDomains.getLogger(ConnectorApplication.class, (String)"javax.enterprise.resource.resourceadapter");
    private String moduleName = "";
    private String applicationName = null;
    private ResourceManager resourceManager;
    private ClassLoader loader;
    private ConnectorRuntime runtime;

    public ConnectorApplication(String moduleName, String appName, ResourceManager resourceManager, ClassLoader loader, ConnectorRuntime runtime) {
        this.setModuleName(moduleName);
        this.resourceManager = resourceManager;
        this.loader = loader;
        this.runtime = runtime;
        this.applicationName = appName;
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean start(ApplicationContext startupContext) {
        boolean started = false;
        this.deployResources();
        this.runtime.registerConnectorApplication(this);
        started = true;
        this.logFine("Resource Adapter [ " + this.getModuleName() + " ] started");
        return started;
    }

    public void deployResources() {
        AdminObjectResource[] adminObjectResources;
        Resources allResources = this.resourceManager.getAllResources();
        Collection connectionPools = ConnectorsUtil.getAllPoolsOfModule((String)this.moduleName, (Resources)allResources);
        Collection poolNames = ConnectorsUtil.getAllPoolNames((Collection)connectionPools);
        Collection resources = ConnectorsUtil.getAllResources((Collection)poolNames, (Resources)allResources);
        for (AdminObjectResource aor : adminObjectResources = ConnectorsUtil.getEnabledAdminObjectResources((String)this.moduleName, (Resources)allResources, null)) {
            resources.add(aor);
        }
        this.resourceManager.deployResources(resources);
    }

    public void undeployResources() {
        Resources allResources = this.resourceManager.getAllResources();
        Collection connectionPools = ConnectorsUtil.getAllPoolsOfModule((String)this.moduleName, (Resources)allResources);
        Collection poolNames = ConnectorsUtil.getAllPoolNames((Collection)connectionPools);
        Collection connectorResources = ConnectorsUtil.getAllResources((Collection)poolNames, (Resources)allResources);
        AdminObjectResource[] adminObjectResources = ConnectorsUtil.getEnabledAdminObjectResources((String)this.moduleName, (Resources)allResources, null);
        ArrayList<AdminObjectResource> resources = new ArrayList<AdminObjectResource>();
        resources.addAll(connectorResources);
        resources.addAll(connectionPools);
        for (AdminObjectResource aor : adminObjectResources) {
            resources.add(aor);
        }
        this.resourceManager.undeployResources(resources);
    }

    public boolean stop(ApplicationContext stopContext) {
        boolean stopped = false;
        this.undeployResources();
        this.runtime.unregisterConnectorApplication(this.getModuleName());
        stopped = true;
        this.logFine("Resource Adapter [ " + this.getModuleName() + " ] stopped");
        return stopped;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void logFine(String message) {
        _logger.log(Level.FINE, message);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }
}

