/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.connectors.module.ConnectorContainer;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassFinder;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.javaee.services.ResourceManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ConnectorDeployer
extends JavaEEDeployer<ConnectorContainer, ConnectorApplication>
implements PostConstruct {
    @Inject
    private ConnectorRuntime runtime;
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    private ResourceManager resourceManager;
    @Inject
    private Resources resources;
    @Inject
    private Domain domain;
    @Inject
    private Events events;
    private static Logger _logger = LogDomains.getLogger(ConnectorDeployer.class, (String)"javax.enterprise.resource.resourceadapter");
    private ConnectorClassFinder ccf = null;

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    public <T> T loadMetaData(Class<T> type, DeploymentContext context) {
        return null;
    }

    public ConnectorApplication load(ConnectorContainer container, DeploymentContext context) {
        super.load((Container)container, context);
        File sourceDir = context.getSourceDir();
        String sourcePath = sourceDir.getAbsolutePath();
        String moduleName = sourceDir.getName();
        boolean isEmbedded = this.isEmbedded(context);
        ConnectorClassFinder classLoader = null;
        if (!ConnectorsUtil.belongsToSystemRA((String)moduleName)) {
            try {
                classLoader = this.ccf = (ConnectorClassFinder)context.getClassLoader();
                if (isEmbedded) {
                    moduleName = this.getEmbeddedRarModuleName(this.getApplicationName(context), moduleName);
                }
                if (!isEmbedded) {
                    classLoader = this.clh.getConnectorClassLoader(null);
                    this.clh.getConnectorClassLoader(null).addDelegate((DelegatingClassLoader.ClassFinder)this.ccf);
                }
                ConnectorDescriptor cd = (ConnectorDescriptor)context.getModuleMetaData(ConnectorDescriptor.class);
                this.runtime.createActiveResourceAdapter(cd, moduleName, sourcePath, (ClassLoader)classLoader);
            }
            catch (Exception cre) {
                _logger.log(Level.WARNING, " unable to load the resource-adapter [ " + moduleName + " ]", cre);
                if (!isEmbedded && this.ccf != null) {
                    this.clh.getConnectorClassLoader(null).removeDelegate((DelegatingClassLoader.ClassFinder)this.ccf);
                }
                return null;
            }
        }
        return new ConnectorApplication(moduleName, this.getApplicationName(context), this.resourceManager, (ClassLoader)classLoader, this.runtime, this.events);
    }

    private String getEmbeddedRarModuleName(String applicationName, String moduleName) {
        String embeddedRarName = moduleName.substring(0, moduleName.indexOf("_rar"));
        moduleName = applicationName + "#" + embeddedRarName;
        return moduleName;
    }

    private boolean isEmbedded(DeploymentContext context) {
        ReadableArchive archive = context.getSource();
        return archive != null && archive.getParentArchive() != null;
    }

    private String getApplicationName(DeploymentContext context) {
        String applicationName = null;
        ReadableArchive parentArchive = context.getSource().getParentArchive();
        if (parentArchive != null) {
            applicationName = parentArchive.getName();
        }
        return applicationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(ConnectorApplication appContainer, DeploymentContext context) {
        File sourceDir = context.getSourceDir();
        String moduleName = sourceDir.getName();
        try {
            if (this.isEmbedded(context)) {
                String applicationName = this.getApplicationName(context);
                moduleName = this.getEmbeddedRarModuleName(applicationName, moduleName);
            }
            this.runtime.destroyActiveResourceAdapter(moduleName);
        }
        catch (ConnectorRuntimeException e) {
            _logger.log(Level.WARNING, " unable to unload the resource-adapter [ " + moduleName + " ]", e);
        }
        finally {
            if (!this.isEmbedded(context)) {
                this.clh.getConnectorClassLoader(null).removeDelegate((DelegatingClassLoader.ClassFinder)this.ccf);
            }
        }
    }

    public void clean(DeploymentContext dc) {
        UndeployCommandParameters dcp = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
        if (dcp.origin == OpsParams.Origin.undeploy && dcp.cascade.booleanValue()) {
            this.deleteAllResources(dcp.name(), dcp.target);
        }
    }

    private void deleteAllResources(String moduleName, String targetServer) {
        Collection conPools = ConnectorsUtil.getAllPoolsOfModule((String)moduleName, (Resources)this.resources);
        Collection poolNames = ConnectorsUtil.getAllPoolNames((Collection)conPools);
        Collection connectorResources = ConnectorsUtil.getAllResources((Collection)poolNames, (Resources)this.resources);
        AdminObjectResource[] adminObjectResources = ConnectorsUtil.getEnabledAdminObjectResources((String)moduleName, (Resources)this.resources, (Server)ConfigBeansUtilities.getServerNamed((String)targetServer));
        Collection securityMaps = ConnectorsUtil.getAllWorkSecurityMaps((Resources)this.resources, (String)moduleName);
        ResourceAdapterConfig rac = ConnectorsUtil.getRAConfig((String)moduleName, (Resources)this.resources);
        this.deleteConnectorResources(connectorResources, targetServer, moduleName);
        this.deleteConnectionPools(conPools, moduleName);
        this.deleteAdminObjectResources(adminObjectResources, targetServer, moduleName);
        this.deleteWorkSecurityMaps(securityMaps, moduleName);
        if (rac != null) {
            this.deleteRAConfig(rac);
        }
    }

    private void deleteRAConfig(final ResourceAdapterConfig rac) {
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    return param.getResources().remove(rac);
                }
            }, (ConfigBeanProxy)this.resources) == null) {
                _logger.log(Level.WARNING, "Unable to delete resource-adapter-config for RAR : " + rac.getResourceAdapterName());
            }
        }
        catch (TransactionFailure tfe) {
            _logger.log(Level.WARNING, "Unable to delete resource-adapter-config for RAR : " + rac.getResourceAdapterName(), tfe);
        }
    }

    private void deleteWorkSecurityMaps(final Collection<WorkSecurityMap> workSecurityMaps, String raName) {
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (WorkSecurityMap resource : workSecurityMaps) {
                        param.getResources().remove(resource);
                    }
                    return true;
                }
            }, (ConfigBeanProxy)this.resources) == null) {
                _logger.log(Level.WARNING, "Unable to delete work-security-map(s) for RAR : " + raName);
            }
        }
        catch (TransactionFailure tfe) {
            _logger.log(Level.WARNING, "Unable to delete work-security-map(s) for RAR : " + raName, tfe);
        }
    }

    private void deleteAdminObjectResources(final AdminObjectResource[] adminObjectResources, String target, String raName) {
        try {
            final Server targetServer = this.domain.getServerNamed(target);
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (AdminObjectResource resource : adminObjectResources) {
                        param.getResources().remove(resource);
                        targetServer.deleteResourceRef(resource.getJndiName());
                    }
                    return true;
                }
            }, (ConfigBeanProxy)this.resources) == null) {
                _logger.log(Level.WARNING, "Unable to delete admin-object-resource(s) for RAR : " + raName);
            }
        }
        catch (TransactionFailure tfe) {
            _logger.log(Level.WARNING, "Unable to delete admin-object-resource(s) for RAR : " + raName, tfe);
        }
    }

    private void deleteConnectorResources(final Collection<Resource> connectorResources, String target, String raName) {
        try {
            final Server targetServer = this.domain.getServerNamed(target);
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (Resource resource : connectorResources) {
                        param.getResources().remove(resource);
                        targetServer.deleteResourceRef(((ConnectorResource)resource).getJndiName());
                    }
                    return true;
                }
            }, (ConfigBeanProxy)this.resources) == null) {
                _logger.log(Level.WARNING, "Unable to delete connector-resource(s) for RAR : " + raName);
            }
        }
        catch (TransactionFailure tfe) {
            _logger.log(Level.WARNING, "Unable to delete connector-resource(s) for RAR : " + raName, tfe);
        }
    }

    private void deleteConnectionPools(final Collection<ConnectorConnectionPool> conPools, String raName) {
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    Iterator i$ = conPools.iterator();
                    if (i$.hasNext()) {
                        ConnectorConnectionPool cp = (ConnectorConnectionPool)i$.next();
                        return param.getResources().remove(cp);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)this.resources) == null) {
                _logger.log(Level.WARNING, "Unable to delete connector-connection-pool(s) for RAR : " + raName);
            }
        }
        catch (TransactionFailure tfe) {
            _logger.log(Level.WARNING, "Unable to delete connector-connection-pool(s) for RAR : " + raName, tfe);
        }
    }

    protected String getModuleType() {
        return "connector";
    }

    public void postConstruct() {
    }

    public void logFine(String message) {
        _logger.log(Level.FINE, message);
    }
}

