/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.naming;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.beans.AdministeredObjectResource;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class AdministeredObjectFactory
implements ObjectFactory {
    private static Logger logger = LogDomains.getLogger(AdministeredObjectFactory.class, (String)"javax.enterprise.resource.resourceadapter");

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        ClassLoader loader;
        Reference ref = (Reference)obj;
        logger.fine("AdministeredObjectFactory: " + ref + " Name:" + name);
        AdministeredObjectResource aor = (AdministeredObjectResource)ref.get(0).getContent();
        String jndiName = aor.getName();
        String moduleName = aor.getResourceAdapter();
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        if (runtime.getEnvironment() == 2) {
            ConnectorDescriptor connectorDescriptor = null;
            try {
                InitialContext ic = new InitialContext();
                String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(moduleName);
                connectorDescriptor = (ConnectorDescriptor)ic.lookup(descriptorJNDIName);
            }
            catch (NamingException ne) {
                logger.log(Level.FINE, "Failed to look up ConnectorDescriptor from JNDI", moduleName);
                throw new ConnectorRuntimeException("Failed to look up ConnectorDescriptor from JNDI");
            }
            runtime.createActiveResourceAdapter(connectorDescriptor, moduleName, null);
        }
        if (!runtime.checkAccessibility(moduleName, loader = Thread.currentThread().getContextClassLoader())) {
            throw new NamingException("Only the application that has the embedded resourceadapter can access the resource adapter");
        }
        logger.fine("[AdministeredObjectFactory] ==> Got AdministeredObjectResource = " + aor);
        if (ConnectorsUtil.belongsToSystemRA((String)moduleName)) {
            String moduleLocation = ConnectorsUtil.getSystemModuleLocation((String)moduleName);
            runtime.createActiveResourceAdapter(moduleLocation, moduleName, null);
            loader = ConnectorRegistry.getInstance().getActiveResourceAdapter(moduleName).getClassLoader();
        }
        return aor.createAdministeredObject(loader);
    }
}

