/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.resource.listener.PoolLifeCycle;
import com.sun.enterprise.resource.pool.JdbcPoolEmitterImpl;
import com.sun.enterprise.resource.pool.PoolLifeCycleListenerRegistry;
import com.sun.enterprise.resource.pool.PoolLifeCycleRegistry;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.monitor.JDBCPoolStatsProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.monitoring.TelemetryProvider;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.provider.ProbeProviderEventManager;
import org.glassfish.probe.provider.PluginPoint;
import org.glassfish.probe.provider.StatsProviderManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service(name="jdbc-connection-pool")
@Scoped(value=Singleton.class)
public class JDBCPoolStatsProviderBootstrap
implements TelemetryProvider,
PostConstruct,
PoolLifeCycle {
    @Inject
    private ProbeProviderEventManager ppem;
    @Inject
    Logger logger;
    @Inject
    private static Domain domain;
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    private ProbeClientMediator pcm;
    @Inject
    private PoolManager poolManager;
    private boolean poolProviderRegistered = false;
    private boolean probeProviderListenerRegistered = false;
    private boolean jdbcPoolMonitoringEnabled = false;
    private boolean isJdbcPoolTreeBuilt = false;
    private String monitoringLevel = null;
    private TreeNode serverNode;
    private TreeNode jdbcConnPoolNode = null;
    private List<JDBCPoolStatsProvider> jdbcPoolTMs = null;

    public JDBCPoolStatsProviderBootstrap() {
        this.registerPoolLifeCycleListener();
        if (!this.isJdbcPoolTreeBuilt) {
            this.buildJdbcPoolMonitoringTree();
        }
    }

    public void onLevelChange(String newLevel) {
        boolean newLevelEnabledValue = this.getEnabledValue(newLevel);
        this.logger.finest("[Monitor] New monitoring level for connection pool received : " + newLevel);
        if (this.jdbcPoolMonitoringEnabled == newLevelEnabledValue) {
            return;
        }
        this.jdbcPoolMonitoringEnabled = newLevelEnabledValue;
    }

    public void postConstruct() {
        Level dbgLevel = Level.FINEST;
        Level defaultLevel = this.logger.getLevel();
        if (defaultLevel == null || dbgLevel.intValue() < defaultLevel.intValue()) {
            // empty if block
        }
        this.logger.finest("[Monitor]In the JDBCPoolTelemetry bootstrap");
    }

    private void buildJdbcPoolMonitoringTree() {
        this.logger.finest("[Monitor]Jdbc Connection Pool Monitoring tree is being built");
        try {
            this.jdbcPoolTMs = new ArrayList<JDBCPoolStatsProvider>();
            List resources = domain.getResources().getResources();
            for (Resource resource : resources) {
                if (!(resource instanceof JdbcConnectionPool)) continue;
                JdbcConnectionPool pool = (JdbcConnectionPool)resource;
                String poolName = pool.getName();
                this.addAndRegisterTelemetryObject(poolName);
            }
            this.isJdbcPoolTreeBuilt = true;
        }
        catch (Exception e) {
            this.isJdbcPoolTreeBuilt = false;
            this.logger.warning("[Monitor]WARNING: Exception in buildJdbcPoolMonitoringTree : " + e.getLocalizedMessage());
        }
    }

    private boolean addAndRegisterTelemetryObject(String poolName) {
        boolean addedTelemetryObject = false;
        if (this.poolManager.getPool(poolName) != null) {
            JDBCPoolStatsProvider jdbcPoolTM = new JDBCPoolStatsProvider(poolName, this.logger);
            StatsProviderManager.register((String)"jdbc", (PluginPoint)PluginPoint.SERVER, (String)("resources/" + poolName), (Object)new JDBCPoolStatsProvider(poolName, this.logger));
            String jdbcPoolName = jdbcPoolTM.getJdbcPoolName();
            PoolLifeCycleListenerRegistry poolRegistry = new PoolLifeCycleListenerRegistry(jdbcPoolName);
            poolRegistry.registerPoolLifeCycleListener(new JdbcPoolEmitterImpl(jdbcPoolName));
            jdbcPoolTM.setPoolRegistry(poolRegistry);
            this.jdbcPoolTMs.add(jdbcPoolTM);
            addedTelemetryObject = true;
        }
        return addedTelemetryObject;
    }

    private void registerPoolLifeCycleListener() {
        PoolLifeCycleRegistry poolLifeCycleRegistry = PoolLifeCycleRegistry.getRegistry();
        List resources = domain.getResources().getResources();
        for (Resource resource : resources) {
            if (!(resource instanceof JdbcConnectionPool)) continue;
            JdbcConnectionPool pool = (JdbcConnectionPool)resource;
            String poolName = pool.getName();
            poolLifeCycleRegistry.registerPoolLifeCycle(poolName, this);
        }
    }

    private void removeAndUnregisterTelemetryObject(String poolName) {
        Iterator<JDBCPoolStatsProvider> i = this.jdbcPoolTMs.iterator();
        while (i.hasNext()) {
            JDBCPoolStatsProvider jdbcPoolTM = i.next();
            if (!poolName.equals(jdbcPoolTM.getJdbcPoolName())) continue;
            PoolLifeCycleListenerRegistry poolRegistry = jdbcPoolTM.getPoolRegistry();
            poolRegistry.unRegisterPoolLifeCycleListener(poolName);
            i.remove();
        }
    }

    public boolean getEnabledValue(String strEnabled) {
        return !"OFF".equals(strEnabled);
    }

    public static Domain getDomain() {
        return domain;
    }

    public void poolCreated(String poolName) {
        this.logger.finest("Pool created : " + poolName);
        if (this.addAndRegisterTelemetryObject(poolName)) {
            this.serverNode.addChild(this.jdbcConnPoolNode);
        }
    }

    public void poolDestroyed(String poolName) {
        this.logger.finest("Pool Destroyed : " + poolName);
        this.removeAndUnregisterTelemetryObject(poolName);
    }
}

