/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.enterprise.resource.pool.PoolLifeCycleListenerRegistry;
import java.util.logging.Logger;
import org.glassfish.api.statistics.CountStatistic;
import org.glassfish.api.statistics.RangeStatistic;
import org.glassfish.api.statistics.impl.CountStatisticImpl;
import org.glassfish.api.statistics.impl.RangeStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.probe.provider.annotations.ProbeListener;
import org.glassfish.probe.provider.annotations.ProbeParam;

@ManagedObject
@Description(value="JDBC Statistics")
public class JDBCPoolStatsProvider {
    private String jdbcPoolName;
    private Logger logger;
    private PoolLifeCycleListenerRegistry poolRegistry;
    private CountStatisticImpl numConnFailedValidation = new CountStatisticImpl("numconnfailedvalidation", "Number", "The total number of connections in the connection pool that failed validation from the start time until the last sample time.");
    private CountStatisticImpl numConnTimedOut = new CountStatisticImpl("numconntimedout", "Number", "The total number of connections in the pool that timed out between the start time and the last sample time.");
    private CountStatisticImpl numConnFree = new CountStatisticImpl("numconnfree", "Number", "The total number of free connections in the pool as of the last sampling.");
    private CountStatisticImpl numConnUsed = new CountStatisticImpl("numconnused", "Number", "Provides connection usage statistics. The total number of connections that are currently being used, as well as information about the maximum number of connections that were used (the high water mark).");
    private RangeStatisticImpl connRequestWaitTime = new RangeStatisticImpl(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, "connectionrequestwaittime", "Milliseconds", "The longest and shortest wait times of connection requests. The current value indicates the wait time of the last request that was serviced by the pool.", System.currentTimeMillis(), System.currentTimeMillis());
    private CountStatisticImpl numConnDestroyed = new CountStatisticImpl("numconndestroyed", "Number", "Number of physical connections that were destroyed since the last reset.");
    private CountStatisticImpl numConnAcquired = new CountStatisticImpl("numconnacquired", "Number", "Number of logical connections acquired from the pool.");
    private CountStatisticImpl numConnReleased = new CountStatisticImpl("numconnreleased", "Number", "Number of logical connections released to the pool.");
    private CountStatisticImpl numConnCreated = new CountStatisticImpl("numconncreated", "Number", "The number of physical connections that were created since the last reset.");
    private CountStatisticImpl numPotentialConnLeak = new CountStatisticImpl("numpotentialconnleak", "Number", "Number of potential connection leaks");

    public JDBCPoolStatsProvider(String jdbcPoolName, Logger logger) {
        this.jdbcPoolName = jdbcPoolName;
        this.logger = logger;
    }

    public String getJdbcPoolName() {
        return this.jdbcPoolName;
    }

    public PoolLifeCycleListenerRegistry getPoolRegistry() {
        return this.poolRegistry;
    }

    public void setPoolRegistry(PoolLifeCycleListenerRegistry poolRegistry) {
        this.poolRegistry = poolRegistry;
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::potentialConnLeakEvent")
    public void potentialConnLeakEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection Leak event received - poolName = " + poolName);
            this.numPotentialConnLeak.increment();
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionTimedOutEvent")
    public void connectionTimedOutEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection Timed-out event received - poolName = " + poolName);
            this.numConnTimedOut.increment();
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::decrementFreeConnectionsSizeEvent")
    public void decrementFreeConnectionsSizeEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="steadyPoolSize") int steadyPoolSize) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Decrement Num Connections Free event received - poolName = " + poolName);
            if (this.numConnFree.getCount() + this.numConnUsed.getCount() > (long)steadyPoolSize) {
                this.logger.finest("Free + Used greater than steady pool size. Decrementing numConnFree");
                this.numConnFree.decrement();
            }
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::decrementConnectionUsedEvent")
    public void decrementConnectionUsedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="beingDestroyed") boolean beingDestroyed, @ProbeParam(value="steadyPoolSize") int steadyPoolSize) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Decrement Num Connections Used event received - poolName = " + poolName);
            this.numConnUsed.decrement();
            if (beingDestroyed) {
                if (this.numConnFree.getCount() + this.numConnUsed.getCount() < (long)steadyPoolSize) {
                    this.numConnFree.increment();
                }
            } else {
                this.numConnFree.increment();
            }
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionsFreedEvent")
    public void connectionsFreedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="count") int count) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connections Freed event received - poolName = " + poolName);
            this.logger.finest("numConnUsed =" + this.numConnUsed.getCount() + " numConnFree=" + this.numConnFree.getCount() + " Number of connections freed =" + count);
            this.numConnFree.setCount((long)count);
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionUsedEvent")
    public void connectionUsedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection Used event received - poolName = " + poolName);
            this.numConnUsed.increment();
            this.numConnFree.decrement();
            this.numConnFree.setCount(this.numConnFree.getCount() < 0L ? 0L : this.numConnFree.getCount());
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionValidationFailedEvent")
    public void connectionValidationFailedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="increment") int increment) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection Validation Failed event received - poolName = " + poolName);
            this.numConnFailedValidation.increment((long)increment);
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionRequestServedEvent")
    public void connectionRequestServedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="timeTakenInMillis") long timeTakenInMillis) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection request served event received - poolName = " + poolName);
            this.connRequestWaitTime.setCurrent(timeTakenInMillis);
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionDestroyedEvent")
    public void connectionDestroyedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection destroyed event received - poolName = " + poolName);
            this.numConnDestroyed.increment();
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionAcquiredEvent")
    public void connectionAcquiredEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection acquired event received - poolName = " + poolName);
            this.numConnAcquired.increment();
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionReleasedEvent")
    public void connectionReleasedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection released event received - poolName = " + poolName);
            this.numConnReleased.increment();
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionCreatedEvent")
    public void connectionCreatedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection created event received - poolName = " + poolName);
            this.numConnCreated.increment();
        }
    }

    private void lowLevelLog(StringBuffer stackTrace) {
        stackTrace.append("\n curNumConnUsed = " + this.numConnUsed.getCount());
        stackTrace.append("\n curNumConnFree = " + this.numConnFree.getCount());
        stackTrace.append("\n numConnCreated = " + this.numConnCreated.getCount());
        stackTrace.append("\n numConnDestroyed = " + this.numConnDestroyed.getCount());
    }

    private void highLevelLog(StringBuffer stackTrace) {
        this.lowLevelLog(stackTrace);
        stackTrace.append("\n numConnFailedValidation = " + this.numConnFailedValidation.getCount());
        stackTrace.append("\n numConnTimedOut = " + this.numConnTimedOut.getCount());
        stackTrace.append("\n numConnAcquired = " + this.numConnAcquired.getCount());
        stackTrace.append("\n numConnReleased = " + this.numConnReleased.getCount());
        stackTrace.append("\n numPotentialConnLeak = " + this.numPotentialConnLeak.getCount());
    }

    @ManagedAttribute(id="numpotentialconnleak")
    public CountStatistic getNumPotentialConnLeakCount() {
        return this.numPotentialConnLeak;
    }

    @ManagedAttribute(id="numconnfailedvalidation")
    public CountStatistic getNumConnFailedValidation() {
        return this.numConnFailedValidation;
    }

    @ManagedAttribute(id="numconntimedout")
    public CountStatistic getNumConnTimedOut() {
        return this.numConnTimedOut;
    }

    @ManagedAttribute(id="numconnused")
    public CountStatistic getNumConnUsed() {
        return this.numConnUsed;
    }

    @ManagedAttribute(id="numconnfree")
    public CountStatistic getNumConnFree() {
        return this.numConnFree;
    }

    @ManagedAttribute(id="connectionrequestwaittime")
    public RangeStatistic getConnRequestWaitTime() {
        return this.connRequestWaitTime;
    }

    @ManagedAttribute(id="numconndestroyed")
    public CountStatistic getNumConnDestroyed() {
        return this.numConnDestroyed;
    }

    @ManagedAttribute(id="numconnacquired")
    public CountStatistic getNumConnAcquired() {
        return this.numConnAcquired;
    }

    @ManagedAttribute(id="numconncreated")
    public CountStatistic getNumConnCreated() {
        return this.numConnCreated;
    }

    @ManagedAttribute(id="numconnreleased")
    public CountStatistic getNumConnReleased() {
        return this.numConnReleased;
    }
}

