/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.logging.LogDomains;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
public class ConnectorJavaBeanValidator {
    private static final Logger _logger = LogDomains.getLogger(ConnectorJavaBeanValidator.class, (String)"javax.enterprise.resource.resourceadapter");

    public void validateJavaBean(Object bean, String rarName) {
        if (bean != null) {
            Validator validator = ConnectorRegistry.getInstance().getBeanValidator(rarName);
            if (validator != null) {
                BeanDescriptor bd = validator.getConstraintsForClass(bean.getClass());
                bd.getConstraintDescriptors();
                Class[] array = new Class[]{};
                Set constraintViolations = validator.validate(bean, array);
                if (constraintViolations != null && constraintViolations.size() > 0) {
                    ConstraintViolationException cve = new ConstraintViolationException(constraintViolations);
                    StringBuffer msg = new StringBuffer();
                    for (ConstraintViolation cv : constraintViolations) {
                        msg.append("\n Bean Class : ").append(cv.getRootBeanClass());
                        msg.append("\n Bean : ").append(cv.getRootBean());
                        msg.append("\n Property path : ").append(cv.getPropertyPath());
                        msg.append("\n Violation Message : ").append(cv.getMessage());
                    }
                    Object[] args = new Object[]{bean.getClass(), rarName, msg.toString()};
                    _logger.log(Level.SEVERE, "validation.constraints.violation", args);
                    throw cve;
                }
            } else if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "No Bean Validator is available for RAR [ " + rarName + " ]");
            }
        }
    }
}

