/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.listener.PoolLifeCycle;
import com.sun.enterprise.resource.pool.PoolLifeCycleListenerRegistry;
import com.sun.enterprise.resource.pool.PoolLifeCycleRegistry;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolEmitterImpl;
import com.sun.enterprise.resource.pool.monitor.ConnectorConnPoolStatsProvider;
import com.sun.enterprise.resource.pool.monitor.JdbcConnPoolStatsProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ConnectionPoolStatsProviderBootstrap
implements PostConstruct,
PoolLifeCycle {
    @Inject
    Logger logger;
    @Inject
    private PoolManager poolManager;
    private List<JdbcConnPoolStatsProvider> jdbcStatsProviders = new ArrayList<JdbcConnPoolStatsProvider>();
    private List<ConnectorConnPoolStatsProvider> ccStatsProviders = new ArrayList<ConnectorConnPoolStatsProvider>();

    public void registerProvider() {
        this.registerPoolLifeCycleListener();
    }

    public void postConstruct() {
        this.logger.finest("[Monitor]In the JDBCPoolStatsProviderBootstrap");
    }

    private PoolLifeCycleListenerRegistry registerPool(String poolName) {
        PoolLifeCycleListenerRegistry poolRegistry = new PoolLifeCycleListenerRegistry(poolName);
        poolRegistry.registerPoolLifeCycleListener(new ConnectionPoolEmitterImpl(poolName));
        return poolRegistry;
    }

    private void registerJdbcPool(String poolName) {
        if (this.poolManager.getPool(poolName) != null) {
            JdbcConnPoolStatsProvider jdbcPoolStatsProvider = new JdbcConnPoolStatsProvider(poolName, this.logger);
            StatsProviderManager.register((String)"jdbc-connection-pool", (PluginPoint)PluginPoint.SERVER, (String)("resources/" + poolName), (Object)jdbcPoolStatsProvider);
            String jdbcPoolName = jdbcPoolStatsProvider.getJdbcPoolName();
            PoolLifeCycleListenerRegistry registry = this.registerPool(jdbcPoolName);
            jdbcPoolStatsProvider.setPoolRegistry(registry);
            this.jdbcStatsProviders.add(jdbcPoolStatsProvider);
        }
    }

    private void registerCcPool(String poolName) {
        if (this.poolManager.getPool(poolName) != null) {
            ConnectorConnPoolStatsProvider ccPoolStatsProvider = new ConnectorConnPoolStatsProvider(poolName, this.logger);
            StatsProviderManager.register((String)"connector-connection-pool", (PluginPoint)PluginPoint.SERVER, (String)("resources/" + poolName), (Object)ccPoolStatsProvider);
            String ccPoolName = ccPoolStatsProvider.getCcPoolName();
            PoolLifeCycleListenerRegistry registry = this.registerPool(ccPoolName);
            ccPoolStatsProvider.setPoolRegistry(registry);
            this.ccStatsProviders.add(ccPoolStatsProvider);
        }
    }

    private void registerPoolLifeCycleListener() {
        if (ConnectorRuntime.getRuntime().isServer()) {
            PoolLifeCycleRegistry poolLifeCycleRegistry = PoolLifeCycleRegistry.getRegistry();
            poolLifeCycleRegistry.registerPoolLifeCycle(this);
        }
    }

    private void unregisterPool(String poolName) {
        PoolLifeCycleListenerRegistry poolRegistry;
        Iterator<Object> i;
        if (this.jdbcStatsProviders != null) {
            i = this.jdbcStatsProviders.iterator();
            while (i.hasNext()) {
                JdbcConnPoolStatsProvider jdbcPoolStatsProvider = (JdbcConnPoolStatsProvider)i.next();
                if (!poolName.equals(jdbcPoolStatsProvider.getJdbcPoolName())) continue;
                poolRegistry = jdbcPoolStatsProvider.getPoolRegistry();
                poolRegistry.unRegisterPoolLifeCycleListener(poolName);
                StatsProviderManager.unregister((Object)jdbcPoolStatsProvider);
                i.remove();
            }
        }
        if (this.ccStatsProviders != null) {
            i = this.ccStatsProviders.iterator();
            while (i.hasNext()) {
                ConnectorConnPoolStatsProvider ccPoolStatsProvider = (ConnectorConnPoolStatsProvider)i.next();
                if (!poolName.equals(ccPoolStatsProvider.getCcPoolName())) continue;
                poolRegistry = ccPoolStatsProvider.getPoolRegistry();
                poolRegistry.unRegisterPoolLifeCycleListener(poolName);
                StatsProviderManager.unregister((Object)ccPoolStatsProvider);
                i.remove();
            }
        }
    }

    public boolean getEnabledValue(String strEnabled) {
        return !"OFF".equals(strEnabled);
    }

    public void poolCreated(String poolName) {
        this.logger.finest("Pool created : " + poolName);
        if (ConnectorRuntime.getRuntime().isServer()) {
            ResourcePool pool = ConnectorRuntime.getRuntime().getConnectionPoolConfig(poolName);
            if (pool instanceof JdbcConnectionPool) {
                this.registerJdbcPool(poolName);
            } else if (pool instanceof ConnectorConnectionPool) {
                this.registerCcPool(poolName);
            }
        }
    }

    public void poolDestroyed(String poolName) {
        this.logger.finest("Pool Destroyed : " + poolName);
        if (ConnectorRuntime.getRuntime().isServer()) {
            this.unregisterPool(poolName);
        }
    }
}

