/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.pool.PoolLifeCycleListenerRegistry;
import com.sun.enterprise.resource.pool.PoolStatus;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.RangeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="connector-connection-pool-mon", group="monitoring")
@ManagedObject
@Description(value="Connector Connection Pool Statistics")
public class ConnectorConnPoolStatsProvider {
    private String ccPoolName;
    private Logger logger;
    private PoolLifeCycleListenerRegistry poolRegistry;
    private CountStatisticImpl numConnFailedValidation = new CountStatisticImpl("numconnfailedvalidation", "count", "The total number of connections in the connection pool that failed validation from the start time until the last sample time.");
    private CountStatisticImpl numConnTimedOut = new CountStatisticImpl("numconntimedout", "count", "The total number of connections in the pool that timed out between the start time and the last sample time.");
    private CountStatisticImpl numConnFree = new CountStatisticImpl("numconnfree", "count", "The total number of free connections in the pool as of the last sampling.");
    private CountStatisticImpl numConnUsed = new CountStatisticImpl("numconnused", "count", "Provides connection usage statistics. The total number of connections that are currently being used, as well as information about the maximum number of connections that were used (the high water mark).");
    private RangeStatisticImpl connRequestWaitTime = new RangeStatisticImpl(0L, Long.MAX_VALUE, 0L, "connrequestwaittime", "millisecond", "The longest and shortest wait times of connection requests. The current value indicates the wait time of the last request that was serviced by the pool.", System.currentTimeMillis(), System.currentTimeMillis());
    private CountStatisticImpl numConnDestroyed = new CountStatisticImpl("numconndestroyed", "count", "Number of physical connections that were destroyed since the last reset.");
    private CountStatisticImpl numConnAcquired = new CountStatisticImpl("numconnacquired", "count", "Number of logical connections acquired from the pool.");
    private CountStatisticImpl numConnReleased = new CountStatisticImpl("numconnreleased", "count", "Number of logical connections released to the pool.");
    private CountStatisticImpl numConnCreated = new CountStatisticImpl("numconncreated", "count", "The number of physical connections that were created since the last reset.");
    private CountStatisticImpl numPotentialConnLeak = new CountStatisticImpl("numpotentialconnleak", "count", "Number of potential connection leaks");
    private CountStatisticImpl numConnSuccessfullyMatched = new CountStatisticImpl("numconnsuccessfullymatched", "count", "Number of connections succesfully matched");
    private CountStatisticImpl numConnNotSuccessfullyMatched = new CountStatisticImpl("numconnnotsuccessfullymatched", "count", "Number of connections rejected during matching");
    private CountStatisticImpl totalConnRequestWaitTime = new CountStatisticImpl("totalconnrequestwaittime", "count", "Total wait time per successful connection request");
    private CountStatisticImpl averageConnWaitTime = new CountStatisticImpl("averageconnwaittime", "count", "Average wait-time-duration per successful connection request");
    private CountStatisticImpl waitQueueLength = new CountStatisticImpl("waitqueuelength", "count", "Number of connection requests in the queue waiting to be serviced.");
    private final String JCA_PROBE_LISTENER = "glassfish:jca:connection-pool:";

    public ConnectorConnPoolStatsProvider(String poolName, Logger logger) {
        this.ccPoolName = poolName;
        this.logger = logger;
    }

    @ProbeListener(value="glassfish:jca:connection-pool:potentialConnLeakEvent")
    public void potentialConnLeakEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Connection Leak event received - poolName = " + poolName);
            }
            this.numPotentialConnLeak.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionTimedOutEvent")
    public void connectionTimedOutEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Connection Timed-out event received - poolName = " + poolName);
            }
            this.numConnTimedOut.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:decrementNumConnFreeEvent")
    public void decrementNumConnFreeEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Decrement Num Connections Free event received - poolName = " + poolName);
            }
            this.numConnFree.decrement();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:incrementNumConnFreeEvent")
    public void incrementNumConnFreeEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="beingDestroyed") boolean beingDestroyed, @ProbeParam(value="steadyPoolSize") int steadyPoolSize) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Increment Num Connections Free event received - poolName = " + poolName);
            }
            if (beingDestroyed) {
                if (this.numConnFree.getCount() + this.numConnUsed.getCount() < (long)steadyPoolSize) {
                    this.numConnFree.increment();
                }
            } else {
                this.numConnFree.increment();
            }
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:decrementConnectionUsedEvent")
    public void decrementConnectionUsedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Decrement Num Connections Used event received - poolName = " + poolName);
            }
            this.numConnUsed.decrement();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionsFreedEvent")
    public void connectionsFreedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="count") int count) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Connections Freed event received - poolName = " + poolName);
                this.logger.finest("numConnUsed =" + this.numConnUsed.getCount() + " numConnFree=" + this.numConnFree.getCount() + " Number of connections freed =" + count);
            }
            this.numConnFree.setCount((long)count);
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionUsedEvent")
    public void connectionUsedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Connection Used event received - poolName = " + poolName);
            }
            this.numConnUsed.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionValidationFailedEvent")
    public void connectionValidationFailedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="increment") int increment) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Connection Validation Failed event received - poolName = " + poolName);
            }
            this.numConnFailedValidation.increment((long)increment);
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionRequestServedEvent")
    public void connectionRequestServedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="timeTakenInMillis") long timeTakenInMillis) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Connection request served event received - poolName = " + poolName);
            }
            this.connRequestWaitTime.setCurrent(timeTakenInMillis);
            this.totalConnRequestWaitTime.increment(timeTakenInMillis);
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionDestroyedEvent")
    public void connectionDestroyedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Connection destroyed event received - poolName = " + poolName);
            }
            this.numConnDestroyed.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionAcquiredEvent")
    public void connectionAcquiredEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Connection acquired event received - poolName = " + poolName);
            }
            this.numConnAcquired.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionReleasedEvent")
    public void connectionReleasedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Connection released event received - poolName = " + poolName);
            }
            this.numConnReleased.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionCreatedEvent")
    public void connectionCreatedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Connection created event received - poolName = " + poolName);
            }
            this.numConnCreated.increment();
        }
    }

    @Reset
    public void reset() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Reset event received - poolName = " + this.ccPoolName);
        }
        PoolStatus status = ConnectorRuntime.getRuntime().getPoolManager().getPoolStatus(this.ccPoolName);
        this.numConnUsed.setCount((long)status.getNumConnUsed());
        this.numConnFree.setCount((long)status.getNumConnFree());
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionMatchedEvent")
    public void connectionMatchedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Connection matched event received - poolName = " + poolName);
            }
            this.numConnSuccessfullyMatched.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionNotMatchedEvent")
    public void connectionNotMatchedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Connection not matched event received - poolName = " + poolName);
            }
            this.numConnNotSuccessfullyMatched.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionRequestQueuedEvent")
    public void connectionRequestQueuedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Wait Queue length modified event received - poolName = " + poolName);
            }
            this.waitQueueLength.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionRequestDequeuedEvent")
    public void connectionRequestDequeuedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.ccPoolName)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Wait Queue length modified event received - poolName = " + poolName);
            }
            this.waitQueueLength.decrement();
        }
    }

    protected String getCcPoolName() {
        return this.ccPoolName;
    }

    protected void setPoolRegistry(PoolLifeCycleListenerRegistry registry) {
        this.poolRegistry = registry;
    }

    protected PoolLifeCycleListenerRegistry getPoolRegistry() {
        return this.poolRegistry;
    }

    private void lowLevelLog(StringBuffer stackTrace) {
        stackTrace.append("\n curNumConnUsed = " + this.numConnUsed.getCount());
        stackTrace.append("\n curNumConnFree = " + this.numConnFree.getCount());
        stackTrace.append("\n numConnCreated = " + this.numConnCreated.getCount());
        stackTrace.append("\n numConnDestroyed = " + this.numConnDestroyed.getCount());
    }

    private void highLevelLog(StringBuffer stackTrace) {
        this.lowLevelLog(stackTrace);
        stackTrace.append("\n numConnFailedValidation = " + this.numConnFailedValidation.getCount());
        stackTrace.append("\n numConnTimedOut = " + this.numConnTimedOut.getCount());
        stackTrace.append("\n numConnAcquired = " + this.numConnAcquired.getCount());
        stackTrace.append("\n numConnReleased = " + this.numConnReleased.getCount());
        stackTrace.append("\n numPotentialConnLeak = " + this.numPotentialConnLeak.getCount());
    }

    @ManagedAttribute(id="numpotentialconnleak")
    public CountStatistic getNumPotentialConnLeakCount() {
        return this.numPotentialConnLeak.getStatistic();
    }

    @ManagedAttribute(id="numconnfailedvalidation")
    public CountStatistic getNumConnFailedValidation() {
        return this.numConnFailedValidation.getStatistic();
    }

    @ManagedAttribute(id="numconntimedout")
    public CountStatistic getNumConnTimedOut() {
        return this.numConnTimedOut.getStatistic();
    }

    @ManagedAttribute(id="numconnused")
    public CountStatistic getNumConnUsed() {
        return this.numConnUsed.getStatistic();
    }

    @ManagedAttribute(id="numconnfree")
    public CountStatistic getNumConnFree() {
        return this.numConnFree.getStatistic();
    }

    @ManagedAttribute(id="connrequestwaittime")
    public RangeStatistic getConnRequestWaitTime() {
        return this.connRequestWaitTime.getStatistic();
    }

    @ManagedAttribute(id="numconndestroyed")
    public CountStatistic getNumConnDestroyed() {
        return this.numConnDestroyed.getStatistic();
    }

    @ManagedAttribute(id="numconnacquired")
    public CountStatistic getNumConnAcquired() {
        return this.numConnAcquired.getStatistic();
    }

    @ManagedAttribute(id="numconncreated")
    public CountStatistic getNumConnCreated() {
        return this.numConnCreated.getStatistic();
    }

    @ManagedAttribute(id="numconnreleased")
    public CountStatistic getNumConnReleased() {
        return this.numConnReleased.getStatistic();
    }

    @ManagedAttribute(id="numconnsuccessfullymatched")
    public CountStatistic getNumConnSuccessfullyMatched() {
        return this.numConnSuccessfullyMatched;
    }

    @ManagedAttribute(id="numconnnotsuccessfullymatched")
    public CountStatistic getNumConnNotSuccessfullyMatched() {
        return this.numConnNotSuccessfullyMatched;
    }

    @ManagedAttribute(id="averageconnwaittime")
    public CountStatistic getAverageConnWaitTime() {
        long averageWaitTime = 0L;
        averageWaitTime = this.numConnAcquired.getCount() != 0L ? this.totalConnRequestWaitTime.getCount() / this.numConnAcquired.getCount() : 0L;
        this.averageConnWaitTime.setCount(averageWaitTime);
        return this.averageConnWaitTime;
    }

    @ManagedAttribute(id="waitqueuelength")
    public CountStatistic getWaitQueueLength() {
        return this.waitQueueLength;
    }
}

