/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.naming.NamingException;
import org.glassfish.internal.api.ConnectorClassFinder;
import org.glassfish.internal.api.DelegatingClassLoader;

public class ResourceAdapterAdminServiceImpl
extends ConnectorService {
    private ExecutorService execService = Executors.newCachedThreadPool(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread th = new Thread(r);
            th.setDaemon(true);
            return th;
        }
    });

    private void destroyActiveResourceAdapter(String moduleName) throws ConnectorRuntimeException {
        ResourcesUtil resutil = ResourcesUtil.createInstance();
        if (resutil == null) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to get ResourcesUtil object");
            _logger.log(Level.SEVERE, "rardeployment.resourcesutil_get_failure", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        if (!this.stopAndRemoveActiveResourceAdapter(moduleName)) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to remove Active Resource Adapter");
            _logger.log(Level.SEVERE, "rardeployment.ra_removal_registry_failure", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        this.unbindConnectorDescriptor(moduleName);
    }

    private void unbindConnectorDescriptor(String moduleName) throws ConnectorRuntimeException {
        if (ConnectorRuntime.getRuntime().isServer()) {
            try {
                String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(moduleName);
                _logger.fine("ResourceAdapterAdminServiceImpl :: destroyActiveRA " + moduleName + " removing descriptor " + descriptorJNDIName);
                this._runtime.getNamingManager().getInitialContext().unbind(descriptorJNDIName);
            }
            catch (NamingException ne) {
                ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to remove connector descriptor from JNDI");
                cre.initCause((Throwable)ne);
                _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_jndi_removal_failure", moduleName);
                _logger.log(Level.SEVERE, "", cre);
                throw cre;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void createActiveResourceAdapter(ConnectorDescriptor connectorDescriptor, String moduleName, String moduleDir, ClassLoader loader) throws ConnectorRuntimeException {
        _logger.fine("ResourceAdapterAdminServiceImpl :: createActiveRA " + moduleName + " at " + moduleDir);
        ActiveResourceAdapter activeResourceAdapter = _registry.getActiveResourceAdapter(moduleName);
        if (activeResourceAdapter != null) {
            _logger.log(Level.FINE, "rardeployment.resourceadapter.already.started", moduleName);
            return;
        }
        if (loader == null) {
            try {
                loader = connectorDescriptor.getClassLoader();
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "No classloader available with connector descriptor");
                loader = null;
            }
        }
        ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
        ModuleDescriptor moduleDescriptor = null;
        Application application = null;
        _logger.fine("ResourceAdapterAdminServiceImpl :: createActiveRA " + moduleName + " at " + moduleDir + " loader :: " + loader);
        if (loader == null && ConnectorsUtil.belongsToSystemRA((String)moduleName)) {
            if (connectorRuntime.isServer()) {
                loader = connectorRuntime.getConnectorClassLoader(moduleName);
            }
        } else {
            connectorDescriptor.setClassLoader(null);
            moduleDescriptor = connectorDescriptor.getModuleDescriptor();
            application = connectorDescriptor.getApplication();
            connectorDescriptor.setModuleDescriptor(null);
            connectorDescriptor.setApplication(null);
        }
        try {
            block12: {
                try {
                    activeResourceAdapter = connectorRuntime.getActiveRAFactory().createActiveResourceAdapter(connectorDescriptor, moduleName, loader);
                    _logger.fine("ResourceAdapterAdminServiceImpl :: createActiveRA " + moduleName + " at " + moduleDir + " adding to registry " + activeResourceAdapter);
                    _registry.addActiveResourceAdapter(moduleName, activeResourceAdapter);
                    _logger.fine("ResourceAdapterAdminServiceImpl:: createActiveRA " + moduleName + " at " + moduleDir + " env =server ? " + connectorRuntime.isServer());
                    if (!connectorRuntime.isServer()) break block12;
                    this.updateRAConfigInDescriptor(connectorDescriptor, moduleName);
                    String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(moduleName);
                    _logger.fine("ResourceAdapterAdminServiceImpl :: createActiveRA " + moduleName + " at " + moduleDir + " publishing descriptor " + descriptorJNDIName);
                    this._runtime.getNamingManager().publishObject(descriptorJNDIName, (Object)connectorDescriptor, true);
                    activeResourceAdapter.setup();
                    String securityWarningMessage = connectorRuntime.getSecurityPermissionSpec(moduleName);
                    if (securityWarningMessage == null) break block12;
                    _logger.log(Level.WARNING, securityWarningMessage);
                }
                catch (NullPointerException npEx) {
                    ConnectorRuntimeException cre = new ConnectorRuntimeException("Error in creating active RAR");
                    cre.initCause((Throwable)npEx);
                    _logger.log(Level.SEVERE, "rardeployment.nullPointerException", moduleName);
                    _logger.log(Level.SEVERE, "", cre);
                    throw cre;
                }
                catch (NamingException ne) {
                    ConnectorRuntimeException cre = new ConnectorRuntimeException("Error in creating active RAR");
                    cre.initCause((Throwable)ne);
                    _logger.log(Level.SEVERE, "rardeployment.jndi_publish_failure");
                    _logger.log(Level.SEVERE, "", cre);
                    throw cre;
                }
            }
            Object var12_16 = null;
            if (moduleDescriptor == null) return;
            connectorDescriptor.setModuleDescriptor(moduleDescriptor);
            connectorDescriptor.setApplication(application);
            connectorDescriptor.setClassLoader(loader);
            return;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (moduleDescriptor == null) throw throwable;
            connectorDescriptor.setModuleDescriptor(moduleDescriptor);
            connectorDescriptor.setApplication(application);
            connectorDescriptor.setClassLoader(loader);
            throw throwable;
        }
    }

    private void updateRAConfigInDescriptor(ConnectorDescriptor connectorDescriptor, String moduleName) {
        ResourceAdapterConfig raConfig = ConnectorRegistry.getInstance().getResourceAdapterConfig(moduleName);
        List raConfigProps = null;
        if (raConfig != null) {
            raConfigProps = raConfig.getProperty();
        }
        _logger.fine("current RAConfig In Descriptor " + connectorDescriptor.getConfigProperties());
        if (raConfigProps != null) {
            Set mergedProps = ConnectorDDTransformUtils.mergeProps(raConfigProps, connectorDescriptor.getConfigProperties());
            Set actualProps = connectorDescriptor.getConfigProperties();
            actualProps.clear();
            actualProps.addAll(mergedProps);
            _logger.fine("updated RAConfig In Descriptor " + connectorDescriptor.getConfigProperties());
        }
    }

    public synchronized void createActiveResourceAdapter(String moduleDir, String moduleName, ClassLoader loader) throws ConnectorRuntimeException {
        ConnectorDescriptor connectorDescriptor;
        ActiveResourceAdapter activeResourceAdapter = _registry.getActiveResourceAdapter(moduleName);
        if (activeResourceAdapter != null) {
            _logger.log(Level.FINE, "rardeployment.resourceadapter.already.started", moduleName);
            return;
        }
        if (ConnectorsUtil.belongsToSystemRA((String)moduleName)) {
            moduleDir = ConnectorsUtil.getSystemModuleLocation((String)moduleName);
        }
        if ((connectorDescriptor = ConnectorDDTransformUtils.getConnectorDescriptor(moduleDir, moduleName)) == null) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to obtain the connectorDescriptor");
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_notfound", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        this.createActiveResourceAdapter(connectorDescriptor, moduleName, moduleDir, loader);
    }

    private boolean stopAndRemoveActiveResourceAdapter(String moduleName) {
        ActiveResourceAdapter acr = null;
        if (moduleName != null) {
            acr = _registry.getActiveResourceAdapter(moduleName);
        }
        if (acr != null) {
            this.sendStopToResourceAdapter(acr);
            if (ConnectorsUtil.belongsToSystemRA((String)moduleName)) {
                ConnectorClassFinder ccf = (ConnectorClassFinder)ConnectorRegistry.getInstance().getActiveResourceAdapter(moduleName).getClassLoader();
                ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
                DelegatingClassLoader ccl = connectorRuntime.getConnectorClassLoader();
                boolean systemRarCLRemoved = ccl.removeDelegate((DelegatingClassLoader.ClassFinder)ccf);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "System RAR [ " + moduleName + " ] removed from " + "classloader chain : " + systemRarCLRemoved);
                }
            }
            return _registry.removeActiveResourceAdapter(moduleName);
        }
        return false;
    }

    public boolean isRarDeployed(String moduleName) {
        ActiveResourceAdapter activeResourceAdapter = _registry.getActiveResourceAdapter(moduleName);
        return activeResourceAdapter != null;
    }

    public void stopAllActiveResourceAdapters() {
        ActiveResourceAdapter[] resourceAdapters;
        for (ActiveResourceAdapter resourceAdapter : resourceAdapters = ConnectorRegistry.getInstance().getAllActiveResourceAdapters()) {
            this.stopActiveResourceAdapter(resourceAdapter.getModuleName());
        }
    }

    public void stopActiveResourceAdapter(String raName) {
        _logger.log(Level.FINE, "Stopping RA : ", raName);
        try {
            this.destroyActiveResourceAdapter(raName);
        }
        catch (ConnectorRuntimeException cre) {
            _logger.log(Level.WARNING, "unable to stop resource adapter [ " + raName + " ]", cre.getMessage());
            _logger.log(Level.FINE, "unable to stop resource adapter [ " + raName + " ]", cre);
        }
    }

    public void addResourceAdapterConfig(String rarName, ResourceAdapterConfig raConfig) throws ConnectorRuntimeException {
        if (rarName != null && raConfig != null) {
            _registry.addResourceAdapterConfig(rarName, raConfig);
            this.reCreateActiveResourceAdapter(rarName);
        }
    }

    public void deleteResourceAdapterConfig(String rarName) throws ConnectorRuntimeException {
        if (rarName != null) {
            _registry.removeResourceAdapterConfig(rarName);
            this.reCreateActiveResourceAdapter(rarName);
        }
    }

    public void reCreateActiveResourceAdapter(String moduleName) throws ConnectorRuntimeException {
        String moduleDir = ConnectorsUtil.getLocation((String)moduleName);
        if (moduleDir != null && this.isRarDeployed(moduleName)) {
            ConnectorApplication app = _registry.getConnectorApplication(moduleName);
            app.undeployResources();
            this.stopAndRemoveActiveResourceAdapter(moduleName);
            this.createActiveResourceAdapter(moduleDir, moduleName, app.getClassLoader());
            _registry.getConnectorApplication(moduleName).deployResources();
        }
    }

    private void sendStopToResourceAdapter(ActiveResourceAdapter resourceAdapterToStop) {
        RAShutdownTask rast = new RAShutdownTask(resourceAdapterToStop);
        String raName = resourceAdapterToStop.getModuleName();
        Long timeout = ConnectorRuntime.getRuntime().getShutdownTimeout();
        Future<?> future = null;
        boolean stopSuccessful = false;
        try {
            _logger.log(Level.FINE, "scheduling stop for RA [ " + raName + " ] ");
            future = this.execService.submit(rast);
            future.get(timeout, TimeUnit.MILLISECONDS);
            _logger.log(Level.FINE, "stop() Complete for active 1.5 compliant RAR [ " + raName + " ]");
            stopSuccessful = true;
        }
        catch (TimeoutException e) {
            _logger.log(Level.WARNING, "RA  [ " + raName + " ] stop timeout occured", e);
            this.cancelTask(future, true, raName);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "RA  [ " + raName + " ] stop failed", e);
            this.cancelTask(future, true, raName);
        }
        if (stopSuccessful) {
            _logger.log(Level.INFO, "ra.stop-successful", raName);
        } else {
            _logger.log(Level.WARNING, "ra.stop-unsuccessful", raName);
        }
    }

    private void cancelTask(Future future, boolean interruptIfRunning, String raName) {
        if (future != null) {
            if (!future.isCancelled() && !future.isDone()) {
                boolean cancelled = future.cancel(interruptIfRunning);
                _logger.log(Level.INFO, "cancelling the shutdown of RA [ " + raName + " ] status : " + cancelled);
            } else {
                _logger.log(Level.INFO, "shutdown of RA [ " + raName + " ] is either already complete or already cancelled");
            }
        }
    }

    private class RAShutdownTask
    implements Runnable {
        private ActiveResourceAdapter ra;

        public RAShutdownTask(ActiveResourceAdapter ratoBeShutDown) {
            this.ra = ratoBeShutDown;
        }

        public void run() {
            ConnectorService._logger.log(Level.FINE, "Calling RA [ " + this.ra.getModuleName() + " ] shutdown ");
            this.ra.destroy();
        }
    }
}

