/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jca.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class ConnectorsHandlers {
    public static final String ADMINOBJECT_INTERFACES_KEY = "AdminObjectInterfacesKey";
    public static final String ADMINOBJECT_CLASSES_KEY = "AdminObjectClassesKey";
    public static final String CONNECTION_DEFINITION_NAMES_KEY = "ConnectionDefinitionNamesKey";
    public static final String MCF_CONFIG_PROPS_KEY = "McfConfigPropsKey";
    public static final String SYSTEM_CONNECTORS_KEY = "SystemConnectorsKey";

    public static void getConnectorConnectionPoolWizard(HandlerContext handlerCtx) {
        Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("fromStep2");
        Boolean fromStep1 = (Boolean)handlerCtx.getInputValue("fromStep1");
        if (fromStep2 != null && fromStep2.booleanValue()) {
            Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
            String resAdapter = (String)extra.get("ResourceAdapterName");
            List defs = ConnectorsHandlers.getConnectionDefinitions(resAdapter);
            handlerCtx.setOutputValue("connectionDefinitions", (Object)defs);
        } else if (fromStep1 != null && fromStep1.booleanValue()) {
            String poolName;
            String resAdapter = (String)handlerCtx.getInputValue("resAdapter");
            if (resAdapter != null) {
                resAdapter = resAdapter.trim();
            }
            if ((poolName = (String)handlerCtx.getInputValue("poolName")) != null) {
                poolName = poolName.trim();
            }
            if (resAdapter == null || resAdapter.equals("")) {
                handlerCtx.setOutputValue("connectionDefinitions", new ArrayList());
            } else {
                Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
                extra.put("ResourceAdapterName", resAdapter);
                extra.put("Name", poolName);
                List defs = ConnectorsHandlers.getConnectionDefinitions(resAdapter);
                handlerCtx.setOutputValue("connectionDefinitions", (Object)defs);
            }
        } else {
            HashMap extra = new HashMap();
            Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardMap", attrMap);
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolExtra", extra);
        }
    }

    public static void updateConnectorConnectionPoolWizard(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        String resAdapter = (String)extra.get("ResourceAdapterName");
        String definition = (String)extra.get("ConnectionDefinitionName");
        String previousDefinition = (String)extra.get("previousDefinition");
        String previousResAdapter = (String)extra.get("previousResAdapter");
        if (!definition.equals(previousDefinition) || !resAdapter.equals(previousResAdapter)) {
            ArrayList propsList = new ArrayList();
            if (!GuiUtil.isEmpty((String)definition) && !GuiUtil.isEmpty((String)resAdapter)) {
                Map result = V3AMX.getInstance().getConnectorRuntime().getMCFConfigProps(resAdapter, definition);
                Map props = (Map)result.get(MCF_CONFIG_PROPS_KEY);
                if (props != null) {
                    handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", GuiUtil.convertMapToListOfMap((Map)props));
                } else {
                    handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", propsList);
                }
            }
            extra.put("previousDefinition", definition);
            extra.put("previousResAdapter", resAdapter);
        }
    }

    public static void updateConnectorConnectionPoolWizardStep2(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        Map attrs = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardMap");
        String resAdapter = (String)extra.get("ResourceAdapterName");
        String definition = (String)extra.get("ConnectionDefinitionName");
        String name = (String)extra.get("Name");
        attrs.put("Name", name);
        attrs.put("ConnectionDefinitionName", definition);
        attrs.put("ResourceAdapterName", resAdapter);
    }

    public static void addSystemConnectors(HandlerContext handlerCtx) {
        Map entries;
        String[] emap;
        ArrayList<String> rarList = (ArrayList<String>)handlerCtx.getInputValue("rarList");
        if (rarList == null) {
            rarList = new ArrayList<String>();
        }
        if ((emap = (String[])(entries = (Map)V3AMX.getInstance().getConnectorRuntime().attributesMap().get("SystemConnectorsAllowingPoolCreation")).get(SYSTEM_CONNECTORS_KEY)) != null) {
            rarList.addAll(Arrays.asList(emap));
        }
        handlerCtx.setOutputValue("result", rarList);
    }

    public static void getConnectionDefinitionsForRA(HandlerContext handlerCtx) {
        String ra = (String)handlerCtx.getInputValue("resourceAdapter");
        handlerCtx.setOutputValue("result", (Object)ConnectorsHandlers.getConnectionDefinitions(ra));
    }

    private static List getConnectionDefinitions(String resAdapter) {
        ArrayList defs = new ArrayList();
        if (resAdapter == null || resAdapter.equals("")) {
            return defs;
        }
        Map result = V3AMX.getInstance().getConnectorRuntime().getConnectionDefinitionNames(resAdapter);
        String[] names = (String[])result.get(CONNECTION_DEFINITION_NAMES_KEY);
        if (names != null) {
            return Arrays.asList(names);
        }
        return defs;
    }

    public static void convertSecurityMapPropsToStringArray(HandlerContext handlerCtx) {
        String option = (String)handlerCtx.getInputValue("usersOptions");
        String edit = (String)handlerCtx.getInputValue("edit");
        String userGroups = (String)handlerCtx.getInputValue("userGroups");
        String principals = (String)handlerCtx.getInputValue("principals");
        String value = null;
        String[] str = null;
        String[] emptyVal = null;
        boolean usePrincipals = false;
        if (option != null) {
            value = userGroups;
            usePrincipals = false;
        } else {
            value = principals;
            usePrincipals = true;
        }
        str = value != null && value.indexOf(",") != -1 ? GuiUtil.stringToArray((String)value, (String)",") : new String[]{value};
        if (edit.equals("true")) {
            emptyVal = new String[]{};
        }
        handlerCtx.setOutputValue("principalsSA", (Object)(usePrincipals ? str : emptyVal));
        handlerCtx.setOutputValue("usersSA", (Object)(usePrincipals ? emptyVal : str));
    }

    public static void getAdminObjectResourceWizard(HandlerContext handlerCtx) {
        Boolean reload = (Boolean)handlerCtx.getInputValue("reload");
        HashMap<String, String> attrMap = (HashMap<String, String>)handlerCtx.getInputValue("attrMap");
        Map currentMap = (Map)handlerCtx.getInputValue("currentMap");
        String name = null;
        String resAdapter = null;
        String resType = null;
        if (attrMap == null) {
            attrMap = new HashMap<String, String>();
        }
        if (!(reload != null && reload.booleanValue() || currentMap == null)) {
            name = (String)currentMap.get("Name");
            resAdapter = (String)currentMap.get("ResAdapter");
            resType = (String)currentMap.get("ResType");
            currentMap.putAll(attrMap);
        } else if (attrMap != null) {
            name = (String)attrMap.get("Name");
            resAdapter = (String)attrMap.get("ResAdapter");
            resType = (String)attrMap.get("ResType");
        }
        if (resAdapter != null) {
            resAdapter = resAdapter.trim();
        }
        if (resAdapter == null || resAdapter.equals("")) {
            resAdapter = "jmsra";
        }
        List defs = ConnectorsHandlers.getResourceTypesForRA(resAdapter);
        if (resType == null && defs.size() > 0) {
            resType = (String)defs.get(0);
        }
        List classNames = ConnectorsHandlers.getClassNames(resAdapter, resType);
        attrMap.put("Name", name);
        attrMap.put("ResType", resType);
        attrMap.put("ResAdapter", resAdapter);
        handlerCtx.setOutputValue("resourceTypes", (Object)defs);
        handlerCtx.setOutputValue("classNames", (Object)classNames);
        handlerCtx.setOutputValue("valueMap", attrMap);
    }

    private static List getResourceTypesForRA(String ra) {
        List<Object> defs = new ArrayList();
        Map result = V3AMX.getInstance().getConnectorRuntime().getAdminObjectInterfaceNames(ra);
        String[] names = (String[])result.get(ADMINOBJECT_INTERFACES_KEY);
        if (names != null) {
            defs = Arrays.asList(names);
        }
        return defs;
    }

    private static List getClassNames(String raName, String resType) {
        ArrayList<String> defs = new ArrayList<String>();
        if (raName == null || raName.equals("") || resType == null || resType.equals("")) {
            return defs;
        }
        Map result = V3AMX.getInstance().getConnectorRuntime().getAdminObjectClassNames(raName, resType);
        String[] names = (String[])result.get(ADMINOBJECT_CLASSES_KEY);
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null) continue;
                defs.add(names[i]);
            }
        }
        return defs;
    }
}

