/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ConnectorResourceDeployer
implements ResourceDeployer {
    @Inject
    private ConnectorRuntime runtime;
    private static Logger _logger = LogDomains.getLogger(ConnectorResourceDeployer.class, (String)"javax.enterprise.resource.resourceadapter");

    public void deployResource(Object resource) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        String jndiName = domainResource.getJndiName();
        String poolName = domainResource.getPoolName();
        _logger.log(Level.FINE, "Calling backend to add connector resource", jndiName);
        this.runtime.createConnectorResource(jndiName, poolName, null);
        _logger.log(Level.FINE, "Added connector resource in backend", jndiName);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        String jndiName = domainResource.getJndiName();
        this.runtime.deleteConnectorResource(jndiName);
    }

    public void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof ConnectorResource;
    }
}

