/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-javamail-resources")
@Scoped(value=PerLookup.class)
@I18n(value="list.javamail.resources")
public class ListJavaMailResources
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListJavaMailResources.class);
    @Param(optional=true, defaultValue="server")
    String target;
    @Inject
    MailResource[] mailResources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (MailResource r : this.mailResources) {
                if (!targetServer.isResourceRefExists(r.getJndiName())) continue;
                list.add(r.getJndiName());
            }
            if (list.isEmpty()) {
                report.setMessage(localStrings.getLocalString("list.javamail.resource.empty", "Nothing to list."));
            } else {
                for (String jndiName : list) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(jndiName);
                }
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.javamail.resources.failed", "Unable to list mail resources") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
    }
}

