/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BackendPrincipal;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.connectors.admin.cli.ConnectorSecurityMap;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="update-connector-security-map")
@Scoped(value=PerLookup.class)
@I18n(value="update.connector.security.map")
public class UpdateConnectorSecurityMap
extends ConnectorSecurityMap
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UpdateConnectorSecurityMap.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="poolname")
    String poolName;
    @Param(name="addprincipals", optional=true)
    List<String> addPrincipals;
    @Param(name="addusergroups", optional=true)
    List<String> addUserGroups;
    @Param(name="removeprincipals", optional=true)
    List<String> removePrincipals;
    @Param(name="removeusergroups", optional=true)
    List<String> removeUserGroups;
    @Param(name="mappedusername", optional=true)
    String mappedusername;
    @Param(name="mappedpassword", password=true, optional=true)
    String mappedpassword;
    @Param(name="mapname", primary=true)
    String securityMapName;
    @Inject
    ConnectorConnectionPool[] ccPools;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.securityMapName == null) {
            report.setMessage(localStrings.getLocalString("create.connector.security.map.noSecurityMapName", "No security map name specified"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.doesPoolNameExist(this.poolName, this.ccPools)) {
            report.setMessage(localStrings.getLocalString("create.connector.security.map.noSuchPoolFound", "Connector connection pool {0} does not exist. Please specify a valid pool name.", new Object[]{this.poolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.doesMapNameExist(this.poolName, this.securityMapName, this.ccPools)) {
            report.setMessage(localStrings.getLocalString("update.connector.security.map.map_does_not_exist", "Security map {0} does not exist for connector connection pool {1}. Please give a valid map name.", new Object[]{this.securityMapName, this.poolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        List<SecurityMap> maps = this.getAllSecurityMapsForPool(this.poolName, this.ccPools);
        if (this.addPrincipals != null && this.removePrincipals != null) {
            for (String ap : this.addPrincipals) {
                for (String rp : this.removePrincipals) {
                    if (!rp.equals(ap)) continue;
                    report.setMessage(localStrings.getLocalString("update.connector.security.map.same_principal_values", "This value {0} is given in both --addprincipals and --removeprincipals. The same value cannot given for these options.", new Object[]{ap}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        if (this.addUserGroups != null && this.removeUserGroups != null) {
            for (String aug : this.addUserGroups) {
                for (String rug : this.removeUserGroups) {
                    if (!rug.equals(aug)) continue;
                    report.setMessage(localStrings.getLocalString("update.connector.security.map.same_usergroup_values", "This value {0} is given in both --addusergroups and --removeusergroups. The same value cannot given for these options.", new Object[]{aug}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        if (this.addPrincipals != null) {
            for (String principal : this.addPrincipals) {
                if (!this.isPrincipalExisting(principal, maps)) continue;
                report.setMessage(localStrings.getLocalString("create.connector.security.map.principal_exists", "The principal {0} already exists in connector connection pool {1}. Please give a different principal name.", new Object[]{principal, this.poolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.addUserGroups != null) {
            for (String userGroup : this.addUserGroups) {
                if (!this.isUserGroupExisting(userGroup, maps)) continue;
                report.setMessage(localStrings.getLocalString("create.connector.security.map.usergroup_exists", "The user-group {0} already exists in connector connection pool {1}. Please give a different user-group name.", new Object[]{userGroup, this.poolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        SecurityMap map = this.getSecurityMap(this.securityMapName, this.poolName, this.ccPools);
        final ArrayList<String> existingPrincipals = new ArrayList<String>(map.getPrincipal());
        final ArrayList<String> existingUserGroups = new ArrayList<String>(map.getUserGroup());
        if (existingPrincipals.isEmpty() && this.addPrincipals != null) {
            report.setMessage(localStrings.getLocalString("update.connector.security.map.addPrincipalToExistingUserGroupsWorkSecurityMap", "Failed to add principals to a security map with user groups."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (existingUserGroups.isEmpty() && this.addUserGroups != null) {
            report.setMessage(localStrings.getLocalString("update.connector.security.map.addUserGroupsToExistingPrincipalsWorkSecurityMap", "Failed to add user groups to a security map with principals."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.removePrincipals != null) {
            boolean principalExists = true;
            String principal = null;
            if (existingPrincipals != null) {
                for (String p : this.removePrincipals) {
                    if (existingPrincipals.contains(p)) continue;
                    principalExists = false;
                    principal = p;
                    break;
                }
            } else {
                principalExists = false;
            }
            if (!principalExists) {
                report.setMessage(localStrings.getLocalString("update.connector.security.map.principal_does_not_exists", "The principal {0} that you want to delete does not exist in connector connection pool {1}. Please give a valid principal name.", new Object[]{principal, this.poolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.removeUserGroups != null) {
            boolean userGroupExists = true;
            String userGroup = null;
            if (existingUserGroups != null) {
                for (String ug : this.removeUserGroups) {
                    if (existingUserGroups.contains(ug)) continue;
                    userGroupExists = false;
                    userGroup = ug;
                    break;
                }
            } else {
                userGroupExists = false;
            }
            if (!userGroupExists) {
                report.setMessage(localStrings.getLocalString("update.connector.security.map.usergroup_does_not_exists", "The usergroup {0} that you want to delete does not exist in connector connection pool {1}. Please give a valid user-group name.", new Object[]{userGroup, this.poolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.addPrincipals == null && this.addUserGroups == null) {
            boolean principalsEmpty = false;
            boolean userGroupsEmpty = false;
            if (this.removePrincipals == null && existingPrincipals.isEmpty()) {
                principalsEmpty = true;
            }
            if (this.removeUserGroups == null && existingUserGroups.isEmpty()) {
                userGroupsEmpty = true;
            }
            if (this.removePrincipals != null && this.removePrincipals.size() == existingPrincipals.size()) {
                principalsEmpty = true;
            }
            if (this.removeUserGroups != null && this.removeUserGroups.size() == existingUserGroups.size()) {
                userGroupsEmpty = true;
            }
            if (userGroupsEmpty && principalsEmpty) {
                report.setMessage(localStrings.getLocalString("update.connector.security.map.principals_usergroups_will_be_null", "The values in your command will delete all principals and usergroups. You cannot delete all principals and usergroups. Atleast one of them must exist."));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.addPrincipals != null) {
            for (String principal : this.addPrincipals) {
                if (!existingPrincipals.contains(principal)) {
                    existingPrincipals.add(principal);
                    continue;
                }
                report.setMessage(localStrings.getLocalString("create.connector.security.map.principal_exists", "The principal {0} already exists in connector connection pool {1}. Please give a different principal name.", new Object[]{principal, this.poolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.removePrincipals != null) {
            for (String principal : this.removePrincipals) {
                existingPrincipals.remove(principal);
            }
        }
        if (this.addUserGroups != null) {
            for (String userGroup : this.addUserGroups) {
                if (!existingUserGroups.contains(userGroup)) {
                    existingUserGroups.add(userGroup);
                    continue;
                }
                report.setMessage(localStrings.getLocalString("create.connector.security.map.usergroup_exists", "The user-group {0} already exists in connector connection pool {1}. Please give a different user-group name.", new Object[]{userGroup, this.poolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.removeUserGroups != null) {
            for (String userGroup : this.removeUserGroups) {
                existingUserGroups.remove(userGroup);
            }
        }
        BackendPrincipal backendPrincipal = map.getBackendPrincipal();
        try {
            ConfigSupport.apply((ConfigCode)new ConfigCode(){

                public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                    SecurityMap sm = (SecurityMap)params[0];
                    BackendPrincipal bp = (BackendPrincipal)params[1];
                    if (existingPrincipals != null) {
                        sm.getPrincipal().clear();
                        for (String principal : existingPrincipals) {
                            sm.getPrincipal().add(principal);
                        }
                    }
                    if (existingUserGroups != null) {
                        sm.getUserGroup().clear();
                        for (String userGroup : existingUserGroups) {
                            sm.getUserGroup().add(userGroup);
                        }
                    }
                    if (UpdateConnectorSecurityMap.this.mappedusername != null && !UpdateConnectorSecurityMap.this.mappedusername.isEmpty()) {
                        bp.setUserName(UpdateConnectorSecurityMap.this.mappedusername);
                    }
                    if (UpdateConnectorSecurityMap.this.mappedpassword != null && !UpdateConnectorSecurityMap.this.mappedpassword.isEmpty()) {
                        bp.setPassword(UpdateConnectorSecurityMap.this.mappedpassword);
                    }
                    return sm;
                }
            }, (ConfigBeanProxy[])new ConfigBeanProxy[]{map, backendPrincipal});
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tfe) {
            Object[] params = new Object[]{this.securityMapName, this.poolName};
            report.setMessage(localStrings.getLocalString("update.connector.security.map.fail", "Unable to update security map {0} for connector connection pool {1}.", params) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
    }
}

