/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.GroupMap;
import com.sun.enterprise.config.serverbeans.PrincipalMap;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.connectors.admin.cli.UpdateConnectorSecurityMap;
import org.glassfish.connectors.admin.cli.WorkSecurityMapHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="update-connector-work-security-map")
@Scoped(value=PerLookup.class)
@I18n(value="update.connector.work.security.map")
public class UpdateConnectorWorkSecurityMap
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UpdateConnectorSecurityMap.class);
    @Param(name="raname")
    String raName;
    @Param(name="addprincipals", optional=true)
    Properties addPrincipals;
    @Param(name="addgroups", optional=true)
    Properties addGroups;
    @Param(name="removeprincipals", optional=true)
    List<String> removePrincipals;
    @Param(name="removegroups", optional=true)
    List<String> removeGroups;
    @Param(name="mapname", primary=true)
    String securityMapName;
    @Inject
    Resources resources;

    public void execute(AdminCommandContext context) {
        Iterator<Map.Entry<Object, Object>> it_1;
        ActionReport report = context.getActionReport();
        if (this.addPrincipals == null && this.addGroups == null && this.removeGroups == null && this.removePrincipals == null) {
            report.setMessage(localStrings.getLocalString("update.connector.work.security.map.noargs", "update-connector-work-security-map should be executed with atleast one optional argument of either add(principals/usergroups) or remove(principals/usergroups)"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!WorkSecurityMapHelper.doesResourceAdapterNameExist(this.raName, this.resources)) {
            report.setMessage(localStrings.getLocalString("update.connector.work.security.map.noSuchRAFound", "Resource Adapter {0} does not exist. Please specify a resource adapter name.", new Object[]{this.raName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!WorkSecurityMapHelper.doesMapNameExist(this.raName, this.securityMapName, this.resources)) {
            report.setMessage(localStrings.getLocalString("update.connector.work.security.map.mapNotExist", "WorkSecurity map {0} does not exist for resource adapter {1}. Please give a valid map name.", new Object[]{this.securityMapName, this.raName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.addPrincipals != null && this.removePrincipals != null) {
            it_1 = this.addPrincipals.entrySet().iterator();
            while (it_1.hasNext()) {
                String ap = it_1.next().getKey().toString();
                for (String rp : this.removePrincipals) {
                    if (!rp.equals(ap)) continue;
                    report.setMessage(localStrings.getLocalString("update.connector.work.security.map.samePrincipalValues", "This value {0} is given in both --addprincipals and --removeprincipals. The same value cannot given for these options.", new Object[]{ap}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        if (this.addGroups != null && this.removeGroups != null) {
            it_1 = this.addGroups.entrySet().iterator();
            while (it_1.hasNext()) {
                String ag = it_1.next().getKey().toString();
                for (String rg : this.removeGroups) {
                    if (!rg.equals(ag)) continue;
                    report.setMessage(localStrings.getLocalString("update.connector.work.security.map.sameUsergroupValues", "This value {0} is given in both --addusergroups and --removeusergroups. The same value cannot given for these options.", new Object[]{ag}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        WorkSecurityMap map = WorkSecurityMapHelper.getSecurityMap(this.securityMapName, this.raName, this.resources);
        final ArrayList existingPrincipals = new ArrayList(map.getPrincipalMap());
        final ArrayList existingUserGroups = new ArrayList(map.getGroupMap());
        if (existingPrincipals.isEmpty() && this.addPrincipals != null) {
            report.setMessage(localStrings.getLocalString("update.connector.work.security.map.addPrincipalToExistingUserGroupsWorkSecurityMap", "Failed to add principals to a security map with user groups."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (existingUserGroups.isEmpty() && this.addGroups != null) {
            report.setMessage(localStrings.getLocalString("update.connector.work.security.map.addUserGroupsToExistingPrincipalsWorkSecurityMap", "Failed to add user groups to a security map with principals."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.addPrincipals == null && this.addGroups == null) {
            boolean principalsEmpty = false;
            boolean userGroupsEmpty = false;
            if (this.removePrincipals != null && this.removePrincipals.size() == existingPrincipals.size()) {
                principalsEmpty = true;
            }
            if (this.removeGroups != null && this.removeGroups.size() == existingUserGroups.size()) {
                userGroupsEmpty = true;
            }
            if (userGroupsEmpty || principalsEmpty) {
                report.setMessage(localStrings.getLocalString("update.connector.work.security.map.principals_usergroups_will_be_null", "The values in your command will delete all principals and usergroups. You cannot delete all principals and usergroups. Atleast one of them must exist."));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.removePrincipals != null) {
            for (String rp : this.removePrincipals) {
                boolean principalExist = false;
                for (PrincipalMap pm : existingPrincipals) {
                    if (!pm.getEisPrincipal().equals(rp)) continue;
                    principalExist = true;
                    break;
                }
                if (principalExist) continue;
                report.setMessage(localStrings.getLocalString("update.connector.work.security.map.principalNotExists", "The principal {0} that you want to delete does not exist in security map {1}. Please give a valid principal name.", new Object[]{rp, this.securityMapName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.removeGroups != null) {
            for (String rg : this.removeGroups) {
                boolean usergroupExist = false;
                for (GroupMap gm : existingUserGroups) {
                    if (!gm.getEisGroup().equals(rg)) continue;
                    usergroupExist = true;
                    break;
                }
                if (usergroupExist) continue;
                report.setMessage(localStrings.getLocalString("update.connector.work.security.map.usergroupNotExists", "The usergroup {0} that you want to delete does not exist in security map {1}. Please give a valid user-group name.", new Object[]{rg, this.securityMapName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.addPrincipals != null) {
            for (Map.Entry<Object, Object> e : this.addPrincipals.entrySet()) {
                for (PrincipalMap pm : existingPrincipals) {
                    if (!pm.getEisPrincipal().equals(e.getKey())) continue;
                    report.setMessage(localStrings.getLocalString("update.connector.work.security.map.principalExists", "The principal {0} already exists in security map {1}. Please give a different principal name.", new Object[]{e.getKey(), this.securityMapName}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        if (this.addGroups != null) {
            for (Map.Entry<Object, Object> e : this.addGroups.entrySet()) {
                for (GroupMap gm : existingUserGroups) {
                    if (!gm.getEisGroup().equals(e.getKey())) continue;
                    report.setMessage(localStrings.getLocalString("update.connector.work.security.map.groupExists", "The Group {0} already exists in security map {1}. Please give a different group name.", new Object[]{e.getKey(), this.securityMapName}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<WorkSecurityMap>(){

                public Object run(WorkSecurityMap wsm) throws PropertyVetoException, TransactionFailure {
                    block10: {
                        block9: {
                            if (UpdateConnectorWorkSecurityMap.this.addGroups != null) {
                                for (Map.Entry<Object, Object> entry : UpdateConnectorWorkSecurityMap.this.addGroups.entrySet()) {
                                    GroupMap gm = (GroupMap)wsm.createChild(GroupMap.class);
                                    gm.setEisGroup((String)entry.getKey());
                                    gm.setMappedGroup((String)entry.getValue());
                                    wsm.getGroupMap().add(gm);
                                }
                            } else if (UpdateConnectorWorkSecurityMap.this.addPrincipals != null) {
                                for (Map.Entry entry : UpdateConnectorWorkSecurityMap.this.addPrincipals.entrySet()) {
                                    PrincipalMap pm = (PrincipalMap)wsm.createChild(PrincipalMap.class);
                                    pm.setEisPrincipal((String)entry.getKey());
                                    pm.setMappedPrincipal((String)entry.getValue());
                                    wsm.getPrincipalMap().add(pm);
                                }
                            }
                            if (UpdateConnectorWorkSecurityMap.this.removeGroups == null) break block9;
                            for (String string : UpdateConnectorWorkSecurityMap.this.removeGroups) {
                                for (GroupMap gm : existingUserGroups) {
                                    if (!gm.getEisGroup().equals(string)) continue;
                                    wsm.getGroupMap().remove(gm);
                                }
                            }
                            break block10;
                        }
                        if (UpdateConnectorWorkSecurityMap.this.removePrincipals == null) break block10;
                        for (String string : UpdateConnectorWorkSecurityMap.this.removePrincipals) {
                            for (PrincipalMap pm : existingPrincipals) {
                                if (!pm.getEisPrincipal().equals(string)) continue;
                                wsm.getPrincipalMap().remove(pm);
                            }
                        }
                    }
                    return wsm;
                }
            }, (ConfigBeanProxy)map);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tfe) {
            Object[] params = new Object[]{this.securityMapName, this.raName};
            report.setMessage(localStrings.getLocalString("update.connector.work.security.map.fail", "Unable to update security map {0} for resource adapter {1}.", params) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
    }
}

