/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-jndi-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.jndi.resource")
public class CreateJndiResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJndiResource.class);
    @Param(name="restype")
    String resType;
    @Param(name="factoryclass")
    String factoryClass;
    @Param(name="jndilookupname")
    String jndiLookupName;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true)
    String description;
    @Param(name="property", optional=true, separator=58)
    Properties properties;
    @Param(optional=true, defaultValue="server")
    String target;
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    Resources resources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        for (Resource resource : this.resources.getResources()) {
            if (!(resource instanceof BindableResource) || !((BindableResource)resource).getJndiName().equals(this.jndiName)) continue;
            report.setMessage(localStrings.getLocalString("create.jndi.resource.duplicate.1", "Resource named {0} already exists.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    ExternalJndiResource newResource = (ExternalJndiResource)param.createChild(ExternalJndiResource.class);
                    newResource.setJndiName(CreateJndiResource.this.jndiName);
                    newResource.setFactoryClass(CreateJndiResource.this.factoryClass);
                    newResource.setResType(CreateJndiResource.this.resType);
                    newResource.setJndiLookupName(CreateJndiResource.this.jndiLookupName);
                    newResource.setEnabled(CreateJndiResource.this.enabled.toString());
                    if (CreateJndiResource.this.description != null) {
                        newResource.setDescription(CreateJndiResource.this.description);
                    }
                    if (CreateJndiResource.this.properties != null) {
                        for (Map.Entry<Object, Object> e : CreateJndiResource.this.properties.entrySet()) {
                            Property prop = (Property)newResource.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)this.resources);
            if (!targetServer.isResourceRefExists(this.jndiName)) {
                targetServer.createResourceRef(this.enabled.toString(), this.jndiName);
            }
            report.setMessage(localStrings.getLocalString("create.jndi.resource.success", "JNDI resource {0} created.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.jndi.resource.fail", "Unable to create JNDI resource {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
    }
}

