/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="custom-resource")
@I18n(value="add.resources")
public class CustomResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CustomResourceManager.class);
    private static final String DESCRIPTION = "description";
    String resType = null;
    String factoryClass = null;
    String enabled = null;
    String description = null;
    String jndiName = null;

    public String getResourceType() {
        return "custom-resource";
    }

    public ResourceStatus create(Resources resources, HashMap attrList, final Properties props, Server targetServer) throws Exception {
        this.jndiName = (String)attrList.get("jndi-name");
        this.resType = (String)attrList.get("res-type");
        this.factoryClass = (String)attrList.get("factory-class");
        this.enabled = (String)attrList.get("enabled");
        this.description = (String)attrList.get(DESCRIPTION);
        if (this.resType == null) {
            String msg = localStrings.getLocalString("create.custom.resource.noResType", "No type defined for Custom Resource.");
            ResourceStatus status = new ResourceStatus(1, msg, true);
            return status;
        }
        if (this.factoryClass == null) {
            String msg = localStrings.getLocalString("create.custom.resource.noFactoryClassName", "No Factory class name defined for Custom Resource.");
            ResourceStatus status = new ResourceStatus(1, msg, true);
            return status;
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof CustomResource) || !((CustomResource)resource).getJndiName().equals(this.jndiName)) continue;
            String msg = localStrings.getLocalString("create.custom.resource.duplicate", "A Custom Resource named {0} already exists.", new Object[]{this.jndiName});
            ResourceStatus status = new ResourceStatus(1, msg, true);
            return status;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    CustomResource newResource = (CustomResource)param.createChild(CustomResource.class);
                    newResource.setJndiName(CustomResourceManager.this.jndiName);
                    newResource.setFactoryClass(CustomResourceManager.this.factoryClass);
                    newResource.setResType(CustomResourceManager.this.resType);
                    newResource.setEnabled(CustomResourceManager.this.enabled.toString());
                    if (CustomResourceManager.this.description != null) {
                        newResource.setDescription(CustomResourceManager.this.description);
                    }
                    if (props != null) {
                        for (Map.Entry<Object, Object> e : props.entrySet()) {
                            Property prop = (Property)newResource.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)resources);
            if (!targetServer.isResourceRefExists(this.jndiName)) {
                targetServer.createResourceRef(this.enabled.toString(), this.jndiName);
            }
            String msg = localStrings.getLocalString("create.admin.object.success", "Administered object {0} created.", new Object[]{this.jndiName});
            ResourceStatus status = new ResourceStatus(0, msg, true);
            return status;
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.admin.object.fail", "Unable to create administered object {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            ResourceStatus status = new ResourceStatus(1, msg, true);
            return status;
        }
    }
}

