/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.types.Property;

@Service(name="list-resource-adapter-configs")
@Scoped(value=PerLookup.class)
@I18n(value="list.resource.adapter.configs")
public class ListResourceAdapterConfigs
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListResourceAdapterConfigs.class);
    @Param(name="raname", optional=true)
    String raName;
    @Param(name="verbose", optional=true, defaultValue="false")
    Boolean verbose;
    @Inject
    ResourceAdapterConfig[] resources;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            HashMap<String, List> raMap = new HashMap<String, List>();
            boolean raExists = false;
            for (ResourceAdapterConfig r : this.resources) {
                if (this.raName != null && !this.raName.isEmpty()) {
                    if (!r.getResourceAdapterName().equals(this.raName)) continue;
                    raMap.put(this.raName, r.getProperty());
                    raExists = true;
                    break;
                }
                raMap.put(r.getResourceAdapterName(), r.getProperty());
            }
            if (this.raName != null && !this.raName.isEmpty() && !raExists) {
                report.setMessage(localStrings.getLocalString("delete.resource.adapter.config.notfound", "Resource adapter {0} not found.", new Object[]{this.raName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (raMap.isEmpty()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(localStrings.getLocalString("nothingToList", "Nothing to list."));
            } else if (this.verbose.booleanValue()) {
                for (Map.Entry raEntry : raMap.entrySet()) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage((String)raEntry.getKey());
                    for (Property prop : (List)raEntry.getValue()) {
                        ActionReport.MessagePart propPart = part.addChild();
                        propPart.setMessage("\t" + prop.getName() + "=" + prop.getValue());
                    }
                }
            } else {
                for (String ra : raMap.keySet()) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(ra);
                }
            }
        }
        catch (Exception e) {
            String failMsg = localStrings.getLocalString("list.resource.adapter.configs.fail", "Unable to list resource adapter configs.");
            Logger.getLogger(ListResourceAdapterConfigs.class.getName()).log(Level.SEVERE, failMsg, e);
            report.setMessage(failMsg + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

