/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.naming;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.naming.ConnectorNamingUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectorObjectFactory
implements ObjectFactory {
    private ConnectorRuntime runtime;
    private static Logger _logger = LogDomains.getLogger(ConnectorObjectFactory.class, (String)"javax.enterprise.system.core.naming");
    protected static final StringManager localStrings = StringManager.getManager(ConnectorRuntime.class);

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Reference ref = (Reference)obj;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ConnectorObjectFactory: " + ref + " Name:" + name);
        }
        String poolName = (String)ref.get(0).getContent();
        String moduleName = (String)ref.get(1).getContent();
        if (this.getRuntime().isACCRuntime() || this.getRuntime().isNonACCRuntime()) {
            ConnectorDescriptor connectorDescriptor = null;
            String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(moduleName);
            InitialContext ic = new InitialContext(env);
            connectorDescriptor = (ConnectorDescriptor)ic.lookup(descriptorJNDIName);
            try {
                this.getRuntime().createActiveResourceAdapter(connectorDescriptor, moduleName, null);
            }
            catch (ConnectorRuntimeException e) {
                _logger.log(Level.FINE, "Failed to look up ConnectorDescriptor from JNDI", moduleName);
                NamingException ne = new NamingException("Failed to look up ConnectorDescriptor from JNDI");
                ne.setRootCause(e);
                throw ne;
            }
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!this.getRuntime().checkAccessibility(moduleName, loader)) {
            String msg = localStrings.getString("cof.no_access_to_embedded_rar", (Object)moduleName);
            throw new NamingException(msg);
        }
        Object cf = null;
        try {
            ManagedConnectionFactory mcf = this.getRuntime().obtainManagedConnectionFactory(poolName, env);
            if (mcf == null) {
                _logger.log(Level.FINE, "Failed to create MCF ", poolName);
                throw new ConnectorRuntimeException("Failed to create MCF");
            }
            boolean forceNoLazyAssoc = false;
            String jndiName = name.toString();
            if (jndiName.endsWith("__pm")) {
                forceNoLazyAssoc = true;
            }
            String derivedJndiName = ConnectorsUtil.deriveJndiName((String)jndiName, (Hashtable)env);
            ConnectionManagerImpl mgr = (ConnectionManagerImpl)this.getRuntime().obtainConnectionManager(poolName, forceNoLazyAssoc);
            mgr.setJndiName(derivedJndiName);
            mgr.setRarName(moduleName);
            String logicalName = (String)env.get("com.sun.enterprise.naming.logicalName");
            if (logicalName != null) {
                mgr.setLogicalName(logicalName);
            }
            mgr.initialize();
            cf = mcf.createConnectionFactory((ConnectionManager)mgr);
            if (cf == null) {
                String msg = localStrings.getString("cof.no.resource.adapter");
                throw new RuntimeException(new ConfigurationException(msg));
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Connection Factory:" + cf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cf;
    }

    private ConnectorRuntime getRuntime() {
        if (this.runtime == null) {
            this.runtime = ConnectorNamingUtils.getRuntime();
        }
        return this.runtime;
    }
}

