/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.datastructure;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.enterprise.resource.pool.datastructure.strategy.ResourceSelectionStrategy;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RWLockDataStructure
implements DataStructure {
    private ResourceHandler handler;
    private ResourceSelectionStrategy strategy;
    private int maxSize;
    private final ArrayList<ResourceHandle> resources;
    private ReentrantReadWriteLock reentrantLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock readLock = this.reentrantLock.readLock();
    private ReentrantReadWriteLock.WriteLock writeLock = this.reentrantLock.writeLock();
    protected static final Logger _logger = LogDomains.getLogger(RWLockDataStructure.class, (String)"javax.enterprise.resource.resourceadapter");

    public RWLockDataStructure(String parameters, int maxSize, ResourceHandler handler, String strategyClass) {
        this.resources = new ArrayList(maxSize > 1000 ? 1000 : maxSize);
        this.maxSize = maxSize;
        this.handler = handler;
        this.initializeStrategy(strategyClass);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "pool.datastructure.rwlockds.init");
        }
    }

    private void initializeStrategy(String strategyClass) {
    }

    public int addResource(ResourceAllocator allocator, int count) throws PoolingException {
        int numResAdded = 0;
        this.writeLock.lock();
        try {
            try {
                for (int i = 0; i < count && this.resources.size() < this.maxSize; ++i) {
                    ResourceHandle handle = this.handler.createResource(allocator);
                    this.resources.add(handle);
                    ++numResAdded;
                }
                Object var7_8 = null;
                this.writeLock.unlock();
            }
            catch (Exception e) {
                PoolingException pe = new PoolingException(e.getMessage());
                pe.initCause((Throwable)e);
                throw pe;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        return numResAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandle getResource() {
        this.readLock.lock();
        for (int i = 0; i < this.resources.size(); ++i) {
            Object var5_3;
            block4: {
                ResourceHandle h = this.resources.get(i);
                if (h.isBusy()) continue;
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    if (h.isBusy()) break block4;
                    h.setBusy(true);
                    ResourceHandle resourceHandle = h;
                    var5_3 = null;
                    this.writeLock.unlock();
                    return resourceHandle;
                }
                catch (Throwable throwable) {
                    var5_3 = null;
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            this.readLock.lock();
            var5_3 = null;
            this.writeLock.unlock();
            continue;
        }
        this.readLock.unlock();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(ResourceHandle resource) {
        boolean removed = false;
        this.writeLock.lock();
        try {
            removed = this.resources.remove(resource);
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        if (removed) {
            this.handler.deleteResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnResource(ResourceHandle resource) {
        this.writeLock.lock();
        try {
            resource.setBusy(false);
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFreeListSize() {
        int free = 0;
        this.readLock.lock();
        try {
            for (ResourceHandle rh : this.resources) {
                if (rh.isBusy()) continue;
                ++free;
            }
            Object var5_4 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
        return free;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        this.writeLock.lock();
        try {
            Iterator<ResourceHandle> it = this.resources.iterator();
            while (it.hasNext()) {
                this.handler.deleteResource(it.next());
                it.remove();
            }
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        this.resources.clear();
    }

    public int getResourcesSize() {
        return this.resources.size();
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

