/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.connectors.util.ClassLoadingUtility;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.net.URI;
import java.sql.Driver;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.XADataSource;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.RelativePathResolver;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.config.ConfigBeanProxy;

public class ResourcesUtil {
    static ThreadLocal<ResourcesUtil> localResourcesUtil = new ThreadLocal();
    static Logger _logger = LogDomains.getLogger(ResourcesUtil.class, (String)"javax.enterprise.resource.resourceadapter");
    static StringManager localStrings = StringManager.getManager(ResourcesUtil.class);
    static ServerContext sc_ = null;
    protected Domain domain = null;
    protected Resources resources = null;
    private ConnectorRuntime runtime;
    private Server server;

    private Resources getResources() {
        if (this.resources == null) {
            this.resources = this.getRuntime().getResources();
        }
        return this.resources;
    }

    private Domain getDomain() {
        if (this.domain == null) {
            this.domain = this.getRuntime().getDomain();
        }
        return this.domain;
    }

    private ConnectorRuntime getRuntime() {
        if (this.runtime == null) {
            this.runtime = ConnectorRuntime.getRuntime();
        }
        return this.runtime;
    }

    private Server getServer() {
        if (this.server == null) {
            this.server = this.getDomain().getServerNamed(this.getRuntime().getServerEnvironment().getInstanceName());
        }
        return this.server;
    }

    public static void setServerContext(ServerContext sc) {
        sc_ = sc;
    }

    private Applications getApplications() {
        return this.getRuntime().getApplications();
    }

    private ConnectorModule getConnectorModuleByName(String name) {
        ConnectorModule module = null;
        List modules = this.getApplications().getModules(ConnectorModule.class);
        for (ConnectorModule connectorModule : modules) {
            if (!connectorModule.getName().equals(name)) continue;
            module = connectorModule;
            break;
        }
        return module;
    }

    private com.sun.enterprise.config.serverbeans.Application getApplicationByName(String name) {
        com.sun.enterprise.config.serverbeans.Application application = null;
        List apps = this.getApplications().getApplications();
        for (com.sun.enterprise.config.serverbeans.Application app : apps) {
            if (!app.getName().equals(name)) continue;
            application = app;
            break;
        }
        return application;
    }

    public String getApplicationDeployLocation(String appName) {
        String location = null;
        com.sun.enterprise.config.serverbeans.Application app = this.getApplicationByName(appName);
        if (app != null) {
            location = RelativePathResolver.resolvePath((String)app.getLocation());
        }
        return location;
    }

    public boolean belongToStandAloneRar(String resourceAdapterName) {
        ConnectorModule connectorModule = this.getConnectorModuleByName(resourceAdapterName);
        return connectorModule != null;
    }

    public static ResourcesUtil createInstance() {
        if (localResourcesUtil.get() != null) {
            return localResourcesUtil.get();
        }
        localResourcesUtil.set(new ResourcesUtil());
        return localResourcesUtil.get();
    }

    public String getRANameofJdbcConnectionPool(JdbcConnectionPool pool) {
        String dsRAName = "__ds_jdbc_ra";
        Class dsClass = null;
        if (pool.getDatasourceClassname() != null) {
            try {
                dsClass = ClassLoadingUtility.loadClass(pool.getDatasourceClassname());
            }
            catch (ClassNotFoundException cnfe) {
                return dsRAName;
            }
        }
        if (pool.getDriverClassname() != null) {
            try {
                dsClass = ClassLoadingUtility.loadClass(pool.getDriverClassname());
            }
            catch (ClassNotFoundException cnfe) {
                return dsRAName;
            }
        }
        if ("javax.sql.XADataSource".equals(pool.getResType()) && XADataSource.class.isAssignableFrom(dsClass)) {
            return "__xa_jdbc_ra";
        }
        if ("javax.sql.ConnectionPoolDataSource".equals(pool.getResType()) && ConnectionPoolDataSource.class.isAssignableFrom(dsClass)) {
            return "__cp_jdbc_ra";
        }
        if ("java.sql.Driver".equals(pool.getResType()) && Driver.class.isAssignableFrom(dsClass)) {
            return "__dm_jdbc_ra";
        }
        return dsRAName;
    }

    public DeferredResourceConfig getDeferredResourceConfig(String resourceName) {
        DeferredResourceConfig resConfig = this.getDeferredConnectorResourceConfigs(resourceName);
        if (resConfig != null) {
            return resConfig;
        }
        resConfig = this.getDeferredJdbcResourceConfigs(resourceName);
        if (resConfig != null) {
            return resConfig;
        }
        resConfig = this.getDeferredAdminObjectConfigs(resourceName);
        return resConfig;
    }

    public DeferredResourceConfig getDeferredPoolConfig(String poolName) {
        DeferredResourceConfig resConfig = this.getDeferredConnectorPoolConfigs(poolName);
        if (resConfig != null) {
            return resConfig;
        }
        if (poolName == null) {
            return null;
        }
        resConfig = this.getDeferredJdbcPoolConfigs(poolName);
        return resConfig;
    }

    public DeferredResourceConfig getDeferredResourceConfig(Object resource, Object pool, String resType, String raName) throws ConnectorRuntimeException {
        String resourceAdapterName = raName;
        DeferredResourceConfig resConfig = null;
        if ("jdbc".equalsIgnoreCase(resType) || "jcp".equalsIgnoreCase(resType)) {
            JdbcConnectionPool jdbcPool = (JdbcConnectionPool)pool;
            JdbcResource jdbcResource = (JdbcResource)resource;
            resourceAdapterName = this.getRANameofJdbcConnectionPool((JdbcConnectionPool)pool);
            resConfig = new DeferredResourceConfig(resourceAdapterName, null, null, null, jdbcPool, jdbcResource, null);
            Resource[] resourcesToload = new Resource[]{jdbcPool, jdbcResource};
            resConfig.setResourcesToLoad(resourcesToload);
        } else if ("cr".equalsIgnoreCase(resType) || "ccp".equalsIgnoreCase(resType)) {
            ConnectorConnectionPool connPool = (ConnectorConnectionPool)pool;
            ConnectorResource connResource = (ConnectorResource)resource;
            resourceAdapterName = connPool.getResourceAdapterName();
            resConfig = new DeferredResourceConfig(resourceAdapterName, null, connPool, connResource, null, null, null);
            Resource[] resourcesToload = new Resource[]{connPool, connResource};
            resConfig.setResourcesToLoad(resourcesToload);
        } else {
            throw new ConnectorRuntimeException("unsupported resource type : " + resType);
        }
        return resConfig;
    }

    public DeferredResourceConfig getDeferredJdbcResourceConfig(JdbcResource resource, JdbcConnectionPool pool) {
        DeferredResourceConfig resConfig = null;
        if (this.parseBoolean(resource.getEnabled())) {
            String rarName = this.getRANameofJdbcConnectionPool(pool);
            resConfig = new DeferredResourceConfig(rarName, null, null, null, pool, resource, null);
            Resource[] resourcesToload = new Resource[]{pool, resource};
            resConfig.setResourcesToLoad(resourcesToload);
        }
        return resConfig;
    }

    protected DeferredResourceConfig getDeferredConnectorResourceConfigs(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        Resource[] resourcesToload = new Resource[2];
        try {
            if (!this.isReferenced(resourceName)) {
                return null;
            }
        }
        catch (Exception e) {
            String message = localStrings.getString("error.finding.resources.references", (Object)resourceName);
            _logger.log(Level.WARNING, message + e.getMessage());
            _logger.log(Level.FINE, message + e.getMessage(), e);
        }
        ConnectorResource connectorResource = (ConnectorResource)this.getResources().getResourceByName(ConnectorResource.class, resourceName);
        if (connectorResource == null || !ConnectorsUtil.parseBoolean((String)connectorResource.getEnabled())) {
            return null;
        }
        String poolName = connectorResource.getPoolName();
        ConnectorConnectionPool ccPool = (ConnectorConnectionPool)this.getResources().getResourceByName(ConnectorConnectionPool.class, poolName);
        if (ccPool == null) {
            return null;
        }
        String rarName = ccPool.getResourceAdapterName();
        if (rarName != null) {
            resourcesToload[0] = ccPool;
            resourcesToload[1] = connectorResource;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{(ResourceAdapterConfig)this.getResources().getResourceByName(ResourceAdapterConfig.class, rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, ccPool, connectorResource, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredJdbcResourceConfigs(String resourceName) {
        JdbcConnectionPool jdbcPool;
        Resource[] resourcesToload = new Resource[2];
        if (resourceName == null) {
            return null;
        }
        try {
            if (!resourceName.endsWith("__pm") && !this.isReferenced(resourceName)) {
                return null;
            }
        }
        catch (Exception e) {
            String message = localStrings.getString("error.finding.resources.references", (Object)resourceName);
            _logger.log(Level.WARNING, message + e.getMessage());
            _logger.log(Level.FINE, message + e.getMessage(), e);
        }
        JdbcResource jdbcResource = (JdbcResource)this.getResources().getResourceByName(JdbcResource.class, resourceName);
        if (jdbcResource == null || !ConnectorsUtil.parseBoolean((String)jdbcResource.getEnabled())) {
            String cmpResourceName = this.getCorrespondingCmpResourceName(resourceName);
            jdbcResource = (JdbcResource)this.getResources().getResourceByName(JdbcResource.class, cmpResourceName);
            if (jdbcResource == null) {
                return null;
            }
        }
        if ((jdbcPool = (JdbcConnectionPool)this.getResources().getResourceByName(JdbcConnectionPool.class, jdbcResource.getPoolName())) == null) {
            return null;
        }
        String rarName = this.getRANameofJdbcConnectionPool(jdbcPool);
        if (rarName != null && ConnectorsUtil.belongsToSystemRA((String)rarName)) {
            resourcesToload[0] = jdbcPool;
            resourcesToload[1] = jdbcResource;
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, null, null, jdbcPool, jdbcResource, null);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredAdminObjectConfigs(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        Resource[] resourcesToload = new Resource[1];
        try {
            if (!this.isReferenced(resourceName)) {
                return null;
            }
        }
        catch (Exception e) {
            String message = localStrings.getString("error.finding.resources.references", (Object)resourceName);
            _logger.log(Level.WARNING, message + e.getMessage());
            _logger.log(Level.FINE, message + e.getMessage(), e);
        }
        AdminObjectResource adminObjectResource = (AdminObjectResource)this.getResources().getResourceByName(AdminObjectResource.class, resourceName);
        if (adminObjectResource == null || !ConnectorsUtil.parseBoolean((String)adminObjectResource.getEnabled())) {
            return null;
        }
        String rarName = adminObjectResource.getResAdapter();
        if (rarName != null) {
            resourcesToload[0] = adminObjectResource;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{(ResourceAdapterConfig)this.getResources().getResourceByName(ResourceAdapterConfig.class, rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, adminObjectResource, null, null, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected String getCorrespondingCmpResourceName(String resourceName) {
        int index = resourceName.lastIndexOf("__pm");
        if (index != -1) {
            return resourceName.substring(0, index);
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredConnectorPoolConfigs(String poolName) {
        Resource[] resourcesToload = new Resource[1];
        if (poolName == null) {
            return null;
        }
        ConnectorConnectionPool ccPool = (ConnectorConnectionPool)this.getResources().getResourceByName(ConnectorConnectionPool.class, poolName);
        if (ccPool == null) {
            return null;
        }
        String rarName = ccPool.getResourceAdapterName();
        if (rarName != null) {
            resourcesToload[0] = ccPool;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{(ResourceAdapterConfig)this.getResources().getResourceByName(ResourceAdapterConfig.class, rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, ccPool, null, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredJdbcPoolConfigs(String poolName) {
        Resource[] resourcesToload = new Resource[1];
        if (poolName == null) {
            return null;
        }
        JdbcConnectionPool jdbcPool = (JdbcConnectionPool)this.getResources().getResourceByName(JdbcConnectionPool.class, poolName);
        if (jdbcPool == null) {
            return null;
        }
        String rarName = this.getRANameofJdbcConnectionPool(jdbcPool);
        if (rarName != null && ConnectorsUtil.belongsToSystemRA((String)rarName)) {
            resourcesToload[0] = jdbcPool;
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, null, null, jdbcPool, null, null);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    public boolean poolBelongsToSystemRar(String poolName) {
        ConnectorConnectionPool ccPool = (ConnectorConnectionPool)this.getResources().getResourceByName(ConnectorConnectionPool.class, poolName);
        if (ccPool != null) {
            return ConnectorsUtil.belongsToSystemRA((String)ccPool.getResourceAdapterName());
        }
        JdbcConnectionPool jdbcPool = (JdbcConnectionPool)this.getResources().getResourceByName(JdbcConnectionPool.class, poolName);
        return jdbcPool != null;
    }

    public boolean adminObjectBelongsToSystemRar(String adminObject) {
        AdminObjectResource aor = (AdminObjectResource)this.getResources().getResourceByName(AdminObjectResource.class, adminObject);
        if (aor != null) {
            return ConnectorsUtil.belongsToSystemRA((String)aor.getResAdapter());
        }
        return false;
    }

    public boolean resourceBelongsToSystemRar(String resourceName) {
        ConnectorResource connectorResource = (ConnectorResource)this.getResources().getResourceByName(ConnectorResource.class, resourceName);
        if (connectorResource != null) {
            return this.poolBelongsToSystemRar(connectorResource.getPoolName());
        }
        JdbcResource jdbcResource = (JdbcResource)this.getResources().getResourceByName(JdbcResource.class, resourceName);
        return jdbcResource != null;
    }

    protected boolean isReferenced(String resourceName) {
        boolean refExists = this.getServer().isResourceRefExists(resourceName);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("isReferenced :: " + resourceName + " - " + refExists);
        }
        return refExists;
    }

    public boolean isEnabled(Resource resource) {
        _logger.fine("ResourcesUtil :: isEnabled");
        if (resource == null) {
            return false;
        }
        if (resource instanceof BindableResource) {
            ResourceRef resRef = this.getServer().getResourceRef(((BindableResource)resource).getJndiName());
            return this.isEnabled((BindableResource)resource) && resRef != null && this.parseBoolean(resRef.getEnabled());
        }
        if (resource instanceof ResourcePool) {
            return this.isEnabled((ResourcePool)resource);
        }
        return resource instanceof WorkSecurityMap || resource instanceof ResourceAdapterConfig;
    }

    public boolean isEnabled(ResourcePool pool) {
        boolean enabled = true;
        if (pool == null) {
            return false;
        }
        if (pool instanceof JdbcConnectionPool) {
            enabled = true;
        } else if (pool instanceof ConnectorConnectionPool) {
            ConnectorConnectionPool ccpool = (ConnectorConnectionPool)pool;
            String raName = ccpool.getResourceAdapterName();
            enabled = this.isRarEnabled(raName);
        }
        return enabled;
    }

    public boolean isEnabled(BindableResource br) {
        AdminObjectResource aor;
        String raName;
        boolean isRarEnabled;
        boolean enabled = false;
        if (br == null) {
            return false;
        }
        boolean resourceEnabled = ConnectorsUtil.parseBoolean((String)br.getEnabled());
        boolean refEnabled = this.isResourceReferenceEnabled(br.getJndiName());
        if (br instanceof JdbcResource || br instanceof MailResource || br instanceof ExternalJndiResource || br instanceof CustomResource) {
            if (resourceEnabled && refEnabled) {
                enabled = true;
            }
        } else if (br instanceof ConnectorResource) {
            ConnectorResource cr = (ConnectorResource)br;
            String poolName = cr.getPoolName();
            ConnectorConnectionPool ccp = (ConnectorConnectionPool)this.getResources().getResourceByName(ConnectorConnectionPool.class, poolName);
            if (ccp == null) {
                return false;
            }
            boolean poolEnabled = this.isEnabled((ResourcePool)ccp);
            enabled = poolEnabled && resourceEnabled && refEnabled;
        } else if (br instanceof AdminObjectResource && (isRarEnabled = this.isRarEnabled(raName = (aor = (AdminObjectResource)br).getResAdapter())) && resourceEnabled && refEnabled) {
            enabled = true;
        }
        return enabled;
    }

    private boolean isRarEnabled(String raName) {
        if (raName == null || raName.length() == 0) {
            return false;
        }
        com.sun.enterprise.config.serverbeans.Application application = this.getDomain().getApplications().getApplication(raName);
        if (application != null) {
            return this.isApplicationReferenceEnabled(raName);
        }
        if (ConnectorsUtil.belongsToSystemRA((String)raName)) {
            return true;
        }
        return this.belongToEmbeddedRarAndEnabled(raName);
    }

    private boolean isApplicationReferenceEnabled(String appName) {
        ApplicationRef appRef = this.getServer().getApplicationRef(appName);
        if (appRef == null) {
            _logger.fine("ResourcesUtil :: isApplicationReferenceEnabled null ref");
            return this.isADeployEvent();
        }
        _logger.fine("ResourcesUtil :: isApplicationReferenceEnabled appRef enabled ?" + appRef.getEnabled());
        return ConnectorsUtil.parseBoolean((String)appRef.getEnabled());
    }

    private boolean isADeployEvent() {
        return localResourcesUtil.get() != null;
    }

    private boolean belongToEmbeddedRarAndEnabled(String resourceAdapterName) {
        String appName = this.getAppNameToken(resourceAdapterName);
        if (appName == null) {
            return false;
        }
        Applications apps = this.getDomain().getApplications();
        com.sun.enterprise.config.serverbeans.Application app = apps.getApplication(appName);
        if (app == null || !ConnectorsUtil.parseBoolean((String)app.getEnabled())) {
            return false;
        }
        return this.isApplicationReferenceEnabled(appName);
    }

    private String getAppNameToken(String rarName) {
        if (rarName == null) {
            return null;
        }
        int index = rarName.indexOf("#");
        if (index != -1) {
            return rarName.substring(0, index);
        }
        return null;
    }

    private boolean isResourceReferenceEnabled(String resourceName) {
        ResourceRef ref = this.getServer().getResourceRef(resourceName);
        if (ref == null) {
            _logger.fine("ResourcesUtil :: isResourceReferenceEnabled null ref");
            return this.isADeployEvent();
        }
        _logger.fine("ResourcesUtil :: isResourceReferenceEnabled ref enabled ?" + ref.getEnabled());
        return ConnectorsUtil.parseBoolean((String)ref.getEnabled());
    }

    public JdbcResource getJdbcResourceByJndiName(String jndiName, boolean checkReference) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: looking up jdbc resource, jndiName is : " + jndiName);
        }
        JdbcResource jdbcResource = (JdbcResource)this.getResources().getResourceByName(JdbcResource.class, jndiName);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: looked up jdbc resource:" + jdbcResource);
        }
        if (jdbcResource == null) {
            return null;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: looked up jdbc resource name:" + jdbcResource.getJndiName());
        }
        if (checkReference) {
            return this.isReferenced(jndiName) ? jdbcResource : null;
        }
        return jdbcResource;
    }

    public String getResourceType(ConfigBeanProxy cb) {
        if (cb instanceof ConnectorConnectionPool) {
            return "ccp";
        }
        if (cb instanceof ConnectorResource) {
            return "cr";
        }
        if (cb instanceof JdbcConnectionPool) {
            return "jcp";
        }
        if (cb instanceof JdbcResource) {
            return "jdbc";
        }
        return null;
    }

    private boolean parseBoolean(String enabled) {
        return Boolean.parseBoolean(enabled);
    }

    public ConnectorDescriptor getConnectorDescriptorFromUri(String rarName, String raLoc) {
        try {
            String appName = rarName.substring(0, rarName.indexOf("#"));
            String appDeployLocation = ResourcesUtil.createInstance().getApplicationDeployLocation(appName);
            FileArchive in = ConnectorRuntime.getRuntime().getFileArchive();
            in.open(new URI(appDeployLocation));
            ApplicationArchivist archivist = ConnectorRuntime.getRuntime().getApplicationArchivist();
            Application application = archivist.open((ReadableArchive)in);
            return application.getRarDescriptorByUri(raLoc);
        }
        catch (Exception e) {
            Object[] params = new Object[]{rarName, e};
            _logger.log(Level.WARNING, "error.getting.connector.descriptor", params);
            return null;
        }
    }

    public boolean isPoolReferredInServerInstance(String poolName) {
        Collection connectorResources = this.getRuntime().getResources().getResources(ConnectorResource.class);
        for (ConnectorResource resource : connectorResources) {
            _logger.fine("poolname " + resource.getPoolName() + "resource " + resource.getJndiName());
            if (!resource.getPoolName().equalsIgnoreCase(poolName) || !this.isReferenced(resource.getJndiName())) continue;
            _logger.fine("Connector resource " + resource.getJndiName() + "refers " + poolName + "in this server instance");
            return true;
        }
        _logger.fine("No Connector resource refers [ " + poolName + " ] in this server instance");
        return false;
    }

    public boolean isJdbcPoolReferredInServerInstance(String poolName) {
        Collection jdbcResources = this.getRuntime().getResources().getResources(JdbcResource.class);
        for (JdbcResource resource : jdbcResources) {
            _logger.fine("poolname " + resource.getPoolName() + "resource " + resource.getJndiName() + " referred " + this.isReferenced(resource.getJndiName()));
            if (!resource.getPoolName().equalsIgnoreCase(poolName) || !this.isReferenced(resource.getJndiName())) continue;
            _logger.fine("JDBC resource " + resource.getJndiName() + "refers " + poolName + "in this server instance");
            return true;
        }
        _logger.fine("No JDBC resource refers [ " + poolName + " ] in this server instance");
        return false;
    }
}

