/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ConnectorResourceDeployer
implements ResourceDeployer {
    @Inject
    private ConnectorRuntime runtime;
    private static Logger _logger = LogDomains.getLogger(ConnectorResourceDeployer.class, (String)"javax.enterprise.resource.resourceadapter");

    public void deployResource(Object resource) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        String jndiName = domainResource.getJndiName();
        String poolName = domainResource.getPoolName();
        _logger.log(Level.FINE, "Calling backend to add connector resource", jndiName);
        this.runtime.createConnectorResource(jndiName, poolName, null);
        _logger.log(Level.FINE, "Added connector resource in backend", jndiName);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        String jndiName = domainResource.getJndiName();
        this.runtime.deleteConnectorResource(jndiName);
        this.checkAndDeletePool(domainResource);
    }

    public void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof ConnectorResource;
    }

    private void checkAndDeletePool(ConnectorResource cr) throws Exception {
        String poolName = cr.getPoolName();
        try {
            Resources res = (Resources)cr.getParent();
            boolean poolReferred = ResourcesUtil.createInstance().isPoolReferredInServerInstance(poolName);
            if (!poolReferred) {
                _logger.fine("Deleting pool [" + poolName + "] as there are no more " + "resource-refs to the pool in this server instance");
                ConnectorConnectionPool ccp = (ConnectorConnectionPool)res.getResourceByName(ConnectorConnectionPool.class, poolName);
                this.runtime.getResourceDeployer(ccp).undeployResource((Object)ccp);
            }
        }
        catch (Exception ce) {
            _logger.warning(ce.getMessage());
            _logger.fine("Exception while deleting pool [ " + poolName + " ] : " + ce);
            throw ce;
        }
    }
}

