/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.javaee.services.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorApplication
implements ApplicationContainer,
EventListener {
    private static Logger _logger = LogDomains.getLogger(ConnectorApplication.class, (String)"javax.enterprise.resource.resourceadapter");
    private String moduleName = "";
    private String applicationName = null;
    private ResourceManager resourceManager;
    private ClassLoader loader;
    private ConnectorRuntime runtime;
    private Events event;
    private ConnectorDescriptor descriptor;

    public ConnectorApplication(String moduleName, String appName, ResourceManager resourceManager, ClassLoader loader, ConnectorRuntime runtime, Events event, ConnectorDescriptor descriptor) {
        this.setModuleName(moduleName);
        this.resourceManager = resourceManager;
        this.loader = loader;
        this.runtime = runtime;
        this.applicationName = appName;
        this.event = event;
        this.descriptor = descriptor;
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    public boolean start(ApplicationContext startupContext) {
        boolean started = false;
        this.deployResources();
        this.runtime.registerConnectorApplication(this);
        started = true;
        this.event.register((EventListener)this);
        this.logFine("Resource Adapter [ " + this.getModuleName() + " ] started");
        return started;
    }

    public void deployResources() {
        AdminObjectResource[] adminObjectResources;
        Resources allResources = this.resourceManager.getAllResources();
        Collection connectionPools = ConnectorsUtil.getAllPoolsOfModule((String)this.moduleName, (Resources)allResources);
        Collection poolNames = ConnectorsUtil.getAllPoolNames((Collection)connectionPools);
        Collection resources = ConnectorsUtil.getAllResources((Collection)poolNames, (Resources)allResources);
        for (AdminObjectResource aor : adminObjectResources = ResourcesUtil.createInstance().getEnabledAdminObjectResources(this.moduleName)) {
            resources.add(aor);
        }
        this.resourceManager.deployResources(resources);
    }

    public boolean undeployResources() {
        return this.undeployResources(false);
    }

    public boolean undeployResources(boolean failIfResourcesExist) {
        List<Resource> resources = this.getAllConnectorResources();
        if (failIfResourcesExist && resources.size() > 0) {
            String message = "one or more resources of resource-adapter [ " + this.moduleName + " ] exist, " + "use '--cascade=true' to delete them during undeploy";
            _logger.log(Level.WARNING, "resources.of.rar.exist", this.moduleName);
            boolean status = false;
            throw new RuntimeException(message);
        }
        this.resourceManager.undeployResources(resources);
        boolean status = true;
        return status;
    }

    private List<Resource> getAllConnectorResources() {
        Resources allResources = this.resourceManager.getAllResources();
        Collection connectionPools = ConnectorsUtil.getAllPoolsOfModule((String)this.moduleName, (Resources)allResources);
        Collection poolNames = ConnectorsUtil.getAllPoolNames((Collection)connectionPools);
        Collection connectorResources = ConnectorsUtil.getAllResources((Collection)poolNames, (Resources)allResources);
        AdminObjectResource[] adminObjectResources = ResourcesUtil.createInstance().getEnabledAdminObjectResources(this.moduleName);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.addAll(connectorResources);
        resources.addAll(connectionPools);
        resources.addAll(Arrays.asList(adminObjectResources));
        return resources;
    }

    public boolean stop(ApplicationContext stopContext) {
        boolean stopped = false;
        DeploymentContext dc = (DeploymentContext)stopContext;
        UndeployCommandParameters dcp = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
        boolean failIfResourcesExist = false;
        if (dcp.origin == OpsParams.Origin.undeploy && !dcp.ignoreCascade.booleanValue() && !dcp.cascade.booleanValue()) {
            failIfResourcesExist = true;
        }
        if (!this.undeployResources(failIfResourcesExist)) {
            stopped = false;
        } else {
            this.runtime.unregisterConnectorApplication(this.getModuleName());
            stopped = true;
            this.logFine("Resource Adapter [ " + this.getModuleName() + " ] stopped");
        }
        this.event.unregister((EventListener)this);
        return stopped;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void logFine(String message) {
        _logger.log(Level.FINE, message);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void event(EventListener.Event event) {
        if (Deployment.UNDEPLOYMENT_VALIDATION.equals((Object)event.type())) {
            DeploymentContext dc = (DeploymentContext)event.hook();
            UndeployCommandParameters dcp = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
            if ((dcp.name.equals(this.moduleName) || dcp.name.equals(this.applicationName) && this.moduleName.contains("#") && this.moduleName.startsWith(dcp.name)) && dcp.origin != OpsParams.Origin.deploy && dcp.origin == OpsParams.Origin.undeploy && !dcp.ignoreCascade.booleanValue() && !dcp.cascade.booleanValue() && this.getAllConnectorResources().size() > 0) {
                String message = "one or more resources of resource-adapter [ " + this.moduleName + " ] exist, " + "use '--cascade=true' to delete them during undeploy";
                _logger.log(Level.WARNING, "resources.of.rar.exist", this.moduleName);
                ActionReport report = dc.getActionReport();
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setActionDescription(message);
            }
        }
    }
}

