/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.naming;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.DynamicallyReconfigurableResource;
import com.sun.enterprise.resource.naming.ConnectorNamingUtils;
import com.sun.enterprise.resource.naming.DynamicResourceReconfigurator;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorObjectFactory
implements ObjectFactory {
    private ConnectorRuntime runtime;
    private static Logger _logger = LogDomains.getLogger(ConnectorObjectFactory.class, (String)"javax.enterprise.system.core.naming");
    protected static final StringManager localStrings = StringManager.getManager(ConnectorRuntime.class);

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Reference ref = (Reference)obj;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ConnectorObjectFactory: " + ref + " Name:" + name);
        }
        String poolName = (String)ref.get(0).getContent();
        String moduleName = (String)ref.get(1).getContent();
        if (this.getRuntime().isACCRuntime() || this.getRuntime().isNonACCRuntime()) {
            ConnectorDescriptor connectorDescriptor = null;
            String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(moduleName);
            InitialContext ic = new InitialContext(env);
            connectorDescriptor = (ConnectorDescriptor)ic.lookup(descriptorJNDIName);
            try {
                this.getRuntime().createActiveResourceAdapter(connectorDescriptor, moduleName, null);
            }
            catch (ConnectorRuntimeException e) {
                _logger.log(Level.FINE, "Failed to look up ConnectorDescriptor from JNDI", moduleName);
                NamingException ne = new NamingException("Failed to look up ConnectorDescriptor from JNDI");
                ne.setRootCause(e);
                throw ne;
            }
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!this.getRuntime().checkAccessibility(moduleName, loader)) {
            String msg = localStrings.getString("cof.no_access_to_embedded_rar", (Object)moduleName);
            throw new NamingException(msg);
        }
        Object cf = null;
        try {
            ManagedConnectionFactory mcf = this.getRuntime().obtainManagedConnectionFactory(poolName, env);
            if (mcf == null) {
                _logger.log(Level.FINE, "Failed to create MCF ", poolName);
                throw new ConnectorRuntimeException("Failed to create MCF");
            }
            boolean forceNoLazyAssoc = false;
            String jndiName = name.toString();
            if (jndiName.endsWith("__pm")) {
                forceNoLazyAssoc = true;
            }
            String derivedJndiName = ConnectorsUtil.deriveJndiName((String)jndiName, (Hashtable)env);
            ConnectionManagerImpl mgr = (ConnectionManagerImpl)this.getRuntime().obtainConnectionManager(poolName, forceNoLazyAssoc);
            mgr.setJndiName(derivedJndiName);
            mgr.setRarName(moduleName);
            String logicalName = (String)env.get("com.sun.enterprise.naming.logicalName");
            if (logicalName != null) {
                mgr.setLogicalName(logicalName);
            }
            mgr.initialize();
            cf = mcf.createConnectionFactory((ConnectionManager)mgr);
            if (cf == null) {
                String msg = localStrings.getString("cof.no.resource.adapter");
                throw new RuntimeException(new ConfigurationException(msg));
            }
            if (this.getRuntime().isServer() || this.getRuntime().isEmbedded()) {
                Object o;
                ResourcePool resourcePool = (ResourcePool)this.getRuntime().getResources().getResourceByName(ResourcePool.class, poolName);
                ResourceDeployer deployer = this.getRuntime().getResourceDeployer(resourcePool);
                if (deployer != null && deployer.supportsDynamicReconfiguration() && ConnectorsUtil.isDynamicReconfigurationEnabled((ResourcePool)resourcePool) && ((o = env.get("com.sun.enterprise.resource.reconfig.proxyCall")) == null || Boolean.valueOf(o.toString()).equals(false))) {
                    Class[] classes = deployer.getProxyClassesForDynamicReconfiguration();
                    Class[] proxyClasses = new Class[classes.length + 1];
                    for (int i = 0; i < classes.length; ++i) {
                        proxyClasses[i] = classes[i];
                    }
                    proxyClasses[proxyClasses.length - 1] = DynamicallyReconfigurableResource.class;
                    cf = this.getProxyObject(cf, proxyClasses, jndiName);
                    Map<DynamicallyReconfigurableResource, Boolean> resources = ConnectorRegistry.getInstance().getResourceFactories(jndiName);
                    resources.put((DynamicallyReconfigurableResource)((Object)Proxy.getInvocationHandler(cf)), true);
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Connection Factory:" + cf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cf;
    }

    protected <T> T getProxyObject(Object actualObject, Class<T>[] ifaces, String jndiName) throws Exception {
        DynamicResourceReconfigurator ih = new DynamicResourceReconfigurator(actualObject, jndiName);
        return (T)Proxy.newProxyInstance(actualObject.getClass().getClassLoader(), ifaces, (InvocationHandler)ih);
    }

    private ConnectorRuntime getRuntime() {
        if (this.runtime == null) {
            this.runtime = ConnectorNamingUtils.getRuntime();
        }
        return this.runtime;
    }
}

