/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import org.glassfish.admin.cli.resources.BindableResourcesHelper;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@Cluster(value={RuntimeType.DAS})
@Service(name="list-jndi-resources")
@Scoped(value=PerLookup.class)
@I18n(value="list.jndi.resources")
public class ListJndiResources
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListJndiResources.class);
    @Param(optional=true, defaultValue="server")
    private String target;
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;
    @Inject
    private ExternalJndiResource[] jndiResources;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (ExternalJndiResource jndiResource : this.jndiResources) {
                if (!this.bindableResourcesHelper.resourceExists(jndiResource.getJndiName(), this.target)) continue;
                list.add(jndiResource.getJndiName());
            }
            if (list.isEmpty()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(localStrings.getLocalString("list.jndi.resources.empty", "Nothing to list."));
            } else {
                for (String jndiName : list) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(jndiName);
                }
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.jndi.resources.fail", "Unable to list jndi resources.") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

