/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="flush-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="flush.connection.pool")
public class FlushConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FlushConnectionPool.class);
    @Param(name="pool_name", primary=true)
    String poolName;
    @Inject
    Resources resources;
    @Inject
    ConnectorRuntime _runtime;

    public void execute(AdminCommandContext context) {
        ConnectorConnectionPool ccp;
        ActionReport report = context.getActionReport();
        if (!this.isPoolExist()) {
            report.setMessage(localStrings.getLocalString("flush.connection.pool.notexist", "Resource pool {0} does not exist.", new Object[]{this.poolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        boolean poolingEnabled = false;
        ResourcePool pool = (ResourcePool)this.resources.getResourceByName(ResourcePool.class, this.poolName);
        if (pool instanceof ConnectorConnectionPool) {
            ccp = (ConnectorConnectionPool)pool;
            poolingEnabled = Boolean.valueOf(ccp.getPooling());
        } else {
            ccp = (JdbcConnectionPool)pool;
            poolingEnabled = Boolean.valueOf(ccp.getPooling());
        }
        if (!poolingEnabled) {
            String i18nMsg = localStrings.getLocalString("flush.connection.pool.pooling.disabled", "Attempt to Flush Connection Pool failed because Pooling is disabled for pool : {0}", new Object[]{this.poolName});
            report.setMessage(i18nMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            this._runtime.flushConnectionPool(this.poolName);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (ConnectorRuntimeException e) {
            report.setMessage(localStrings.getLocalString("flush.connection.pool.fail", "Failed to flush connection pool {0} due to {1}.", new Object[]{this.poolName, e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean isPoolExist() {
        for (Resource resource : this.resources.getResources()) {
            if (!(resource instanceof ResourcePool) || !((ResourcePool)resource).getName().equals(this.poolName)) continue;
            return true;
        }
        return false;
    }
}

