/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.connectors.module.ConnectorDeployer;
import com.sun.enterprise.connectors.module.ResourcesApplication;
import com.sun.enterprise.connectors.module.ResourcesContainer;
import com.sun.enterprise.resource.ResourceUtilities;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import org.glassfish.admin.cli.resources.ResourceConflictException;
import org.glassfish.admin.cli.resources.ResourceFactory;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.admin.cli.resources.ResourcesXMLParser;
import org.glassfish.admin.cli.resources.SunResourcesXML;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.javaee.services.ResourcesBinder;
import org.glassfish.resource.common.Resource;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.ConfigSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ResourcesDeployer
extends JavaEEDeployer<ResourcesContainer, ResourcesApplication>
implements PostConstruct,
PreDestroy,
EventListener {
    @Inject
    private static ResourceFactory resourceFactory;
    @Inject
    private Domain domain;
    @Inject
    private ServerContext context;
    @Inject
    private static ApplicationRegistry appRegistry;
    @Inject
    private static Habitat habitat;
    @Inject
    private static ResourcesBinder resourcesBinder;
    @Inject
    private ConfigSupport configSupport;
    @Inject
    private Events events;
    @Inject
    private static Applications applications;
    private static Logger _logger;

    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public void preDestroy() {
        this.events.unregister((EventListener)this);
    }

    protected String getModuleType() {
        return "resources_ear";
    }

    public ResourcesApplication load(ResourcesContainer container, DeploymentContext context) {
        super.load((Container)container, context);
        ResourcesDeployer.debug("App-Scoped-Resources ResourcesDeployer.load()");
        ResourcesApplication application = (ResourcesApplication)habitat.getComponent(ResourcesApplication.class);
        application.setApplicationName(ResourcesDeployer.getApplicationName(context));
        return application;
    }

    public void unload(ResourcesApplication appContainer, DeploymentContext context) {
        ResourcesDeployer.debug("Resources-Deployer :unload() called");
    }

    private void processArchive(DeploymentContext dc) {
        try {
            ReadableArchive archive = dc.getSource();
            if (DeploymentUtils.hasResourcesXML((ReadableArchive)archive)) {
                HashMap appScopedResources = new HashMap();
                HashMap<String, String> fileNames = new HashMap<String, String>();
                this.retrieveAllResourcesXMLs(fileNames, archive.getURI().getPath());
                for (String moduleName : fileNames.keySet()) {
                    String fileName = (String)fileNames.get(moduleName);
                    ResourcesDeployer.debug("Sun Resources XML : " + fileName);
                    String appName = ResourcesDeployer.getApplicationName(dc);
                    moduleName = ResourcesDeployer.getActualModuleName(moduleName);
                    String scope = "java:app";
                    scope = appName.equals(moduleName) ? "java:app/" : "java:module/";
                    File file = new File(fileName);
                    ResourcesXMLParser parser = new ResourcesXMLParser(file, scope);
                    this.validateResourcesXML(file, parser);
                    List list = parser.getResourcesList();
                    HashMap<String, List> resourcesList = new HashMap<String, List>();
                    List nonConnectorResources = ResourcesXMLParser.getNonConnectorResourcesList((List)list, (boolean)false, (boolean)true);
                    resourcesList.put("NON-CONNECTOR", nonConnectorResources);
                    List connectorResources = ResourcesXMLParser.getConnectorResourcesList((List)list, (boolean)false, (boolean)true);
                    resourcesList.put("CONNECTOR", connectorResources);
                    appScopedResources.put(moduleName, resourcesList);
                }
                dc.addTransientAppMetaData("app-scoped-resources-map", appScopedResources);
                String appName = ResourcesDeployer.getApplicationName(dc);
                ApplicationInfo appInfo = appRegistry.get(appName);
                if (appInfo != null) {
                    Application app = (Application)dc.getTransientAppMetaData("application", Application.class);
                    appInfo.addTransientAppMetaData("application", (Object)app);
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Failue while processing glassfish-resources.xml(s) in the archive ", (Throwable)e);
        }
    }

    private void validateResourcesXML(File file, ResourcesXMLParser parser) throws ResourceConflictException {
        String filePath = file.getPath();
        SunResourcesXML sunResourcesXML = new SunResourcesXML(filePath, parser.getResourcesList());
        ArrayList<SunResourcesXML> resourcesXMLList = new ArrayList<SunResourcesXML>();
        resourcesXMLList.add(sunResourcesXML);
        ResourceUtilities.resolveResourceDuplicatesConflictsWithinArchive(resourcesXMLList);
    }

    public static void populateResourceConfigInAppInfo(DeploymentContext dc) {
        String appName = ResourcesDeployer.getApplicationName(dc);
        Application application = applications.getApplication(appName);
        ApplicationInfo appInfo = appRegistry.get(appName);
        if (application != null && appInfo != null) {
            List modules;
            Resources appScopedResources = application.getResources();
            if (appScopedResources != null) {
                appInfo.addTransientAppMetaData("application", (Object)application);
            }
            if ((modules = application.getModule()) != null) {
                for (Module module : modules) {
                    Resources moduleScopedResources = module.getResources();
                    if (moduleScopedResources == null) continue;
                    appInfo.addTransientAppMetaData(module.getName() + "-resources", (Object)moduleScopedResources);
                }
            }
        }
    }

    public static void createResources(DeploymentContext dc, boolean embedded) throws ResourceException {
        String appName = ResourcesDeployer.getApplicationName(dc);
        Application app = (Application)dc.getTransientAppMetaData("application", Application.class);
        Map resourcesList = (Map)dc.getTransientAppMetadata().get("app-scoped-resources-map");
        if (resourcesList != null) {
            List modules;
            Map appLevelResources = (Map)resourcesList.get(appName);
            if (appLevelResources != null) {
                List connectorResources = (List)appLevelResources.get("CONNECTOR");
                ResourcesDeployer.createAppScopedResources(app, connectorResources, dc, embedded);
                List nonConnectorResources = (List)appLevelResources.get("NON-CONNECTOR");
                ResourcesDeployer.createAppScopedResources(app, nonConnectorResources, dc, embedded);
            }
            if ((modules = app.getModule()) != null) {
                for (Module module : modules) {
                    Map moduleResources;
                    String actualModuleName = ResourcesDeployer.getActualModuleName(module.getName());
                    if (appName.equals(actualModuleName) || (moduleResources = (Map)resourcesList.get(actualModuleName)) == null) continue;
                    List connectorResources = (List)moduleResources.get("CONNECTOR");
                    ResourcesDeployer.createModuleScopedResources(app, module, connectorResources, dc, embedded);
                    List nonConnectorResources = (List)moduleResources.get("NON-CONNECTOR");
                    ResourcesDeployer.createModuleScopedResources(app, module, nonConnectorResources, dc, embedded);
                }
            }
        }
    }

    private static String getActualModuleName(String moduleName) {
        String actualModuleName = moduleName;
        if (moduleName.endsWith("_war")) {
            int index = moduleName.lastIndexOf("_war");
            actualModuleName = moduleName.substring(0, index) + ".war";
        } else if (moduleName.endsWith("_rar")) {
            int index = moduleName.lastIndexOf("_rar");
            actualModuleName = moduleName.substring(0, index) + ".rar";
        } else if (moduleName.endsWith("_jar")) {
            int index = moduleName.lastIndexOf("_jar");
            actualModuleName = moduleName.substring(0, index) + ".jar";
        }
        return actualModuleName;
    }

    private static Collection<com.sun.enterprise.config.serverbeans.Resource> createConfig(Resources resources, Iterator<Resource> resourcesToRegister, boolean embedded) throws ResourceException {
        ArrayList<com.sun.enterprise.config.serverbeans.Resource> resourceConfigs = new ArrayList<com.sun.enterprise.config.serverbeans.Resource>();
        while (resourcesToRegister.hasNext()) {
            Resource resource = resourcesToRegister.next();
            HashMap attrList = resource.getAttributes();
            Properties props = resource.getProperties();
            String desc = resource.getDescription();
            if (desc != null) {
                attrList.put("description", desc);
            }
            try {
                ResourceManager rm = resourceFactory.getResourceManager(resource);
                com.sun.enterprise.config.serverbeans.Resource configBeanResource = rm.createConfigBean(resources, attrList, props);
                if (configBeanResource == null) continue;
                if (embedded && ResourcesDeployer.isEmbeddedRarResource(configBeanResource, resources.getResources()) == ConnectorConstants.TriState.yes) {
                    resources.getResources().add(configBeanResource);
                    resourceConfigs.add(configBeanResource);
                    continue;
                }
                if (embedded || ResourcesDeployer.isEmbeddedRarResource(configBeanResource, resources.getResources()) != ConnectorConstants.TriState.no) continue;
                resources.getResources().add(configBeanResource);
                resourceConfigs.add(configBeanResource);
            }
            catch (Exception e) {
                throw new ResourceException((Throwable)e);
            }
        }
        return resourceConfigs;
    }

    private static void createAppScopedResources(Application app, List<Resource> resources, DeploymentContext dc, boolean embedded) throws ResourceException {
        try {
            if (resources != null) {
                Application application = (Application)dc.getTransientAppMetaData("application", Application.class);
                Resources asc = (Resources)dc.getTransientAppMetaData("app-level-resources-config", Resources.class);
                if (asc == null) {
                    asc = (Resources)application.createChild(Resources.class);
                    application.setResources(asc);
                    dc.addTransientAppMetaData("app-level-resources-config", (Object)asc);
                }
                Collection<com.sun.enterprise.config.serverbeans.Resource> resourceConfigurations = ResourcesDeployer.createConfig(asc, resources.iterator(), embedded);
                ResourcesDeployer.deployResources(app.getName(), null, resourceConfigurations, embedded);
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{app.getName(), e};
            _logger.log(Level.SEVERE, "gf.resources.app.scope.deployment.failure", params);
            throw new ResourceException((Throwable)e);
        }
    }

    private static void createModuleScopedResources(Application app, Module module, List<Resource> resources, DeploymentContext dc, boolean embedded) throws ResourceException {
        try {
            if (resources != null) {
                Resources msc = (Resources)dc.getTransientAppMetaData(module.getName() + "-resources", Resources.class);
                if (msc == null) {
                    msc = (Resources)module.createChild(Resources.class);
                    module.setResources(msc);
                    dc.addTransientAppMetaData(module.getName() + "-resources", (Object)msc);
                    ApplicationInfo appInfo = appRegistry.get(app.getName());
                    if (appInfo != null) {
                        appInfo.addTransientAppMetaData(module.getName() + "-resources", (Object)msc);
                    }
                }
                Collection<com.sun.enterprise.config.serverbeans.Resource> resourceConfigurations = ResourcesDeployer.createConfig(msc, resources.iterator(), embedded);
                ResourcesDeployer.deployResources(app.getName(), module.getName(), resourceConfigurations, embedded);
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{module.getName(), app.getName(), e};
            _logger.log(Level.SEVERE, "gf.resources.module.scope.deployment.failure", params);
            throw new ResourceException((Throwable)e);
        }
    }

    public static void deployResources(String applicationName, String moduleName, Collection<com.sun.enterprise.config.serverbeans.Resource> configBeanResources, boolean embedded) throws Exception {
        for (com.sun.enterprise.config.serverbeans.Resource configBeanResource : configBeanResources) {
            if (configBeanResource instanceof ResourcePool) {
                ResourcePool resourcePool = (ResourcePool)configBeanResource;
                if (embedded) {
                    if (ResourcesDeployer.isEmbeddedRarResource(configBeanResource, configBeanResources) != ConnectorConstants.TriState.yes) continue;
                    ResourcesDeployer.getResourceDeployer(resourcePool).deployResource((Object)resourcePool, applicationName, moduleName);
                    continue;
                }
                if (ResourcesDeployer.isEmbeddedRarResource(configBeanResource, configBeanResources) != ConnectorConstants.TriState.no) continue;
                ResourcesDeployer.getResourceDeployer(resourcePool).deployResource((Object)resourcePool, applicationName, moduleName);
                continue;
            }
            if (configBeanResource instanceof BindableResource) {
                BindableResource resource = (BindableResource)configBeanResource;
                ResourceInfo resourceInfo = new ResourceInfo(resource.getJndiName(), applicationName, moduleName);
                if (embedded) {
                    if (ResourcesDeployer.isEmbeddedRarResource(configBeanResource, configBeanResources) != ConnectorConstants.TriState.yes) continue;
                    resourcesBinder.deployResource(resourceInfo, (com.sun.enterprise.config.serverbeans.Resource)resource);
                    continue;
                }
                if (ResourcesDeployer.isEmbeddedRarResource(configBeanResource, configBeanResources) != ConnectorConstants.TriState.no) continue;
                resourcesBinder.deployResource(resourceInfo, (com.sun.enterprise.config.serverbeans.Resource)resource);
                continue;
            }
            if (embedded) {
                if (ResourcesDeployer.isEmbeddedRarResource(configBeanResource, configBeanResources) != ConnectorConstants.TriState.yes) continue;
                ResourcesDeployer.getResourceDeployer(configBeanResource).deployResource((Object)configBeanResource);
                continue;
            }
            if (ResourcesDeployer.isEmbeddedRarResource(configBeanResource, configBeanResources) != ConnectorConstants.TriState.no) continue;
            ResourcesDeployer.getResourceDeployer(configBeanResource).deployResource((Object)configBeanResource);
        }
    }

    public static ConnectorConstants.TriState isEmbeddedRarResource(com.sun.enterprise.config.serverbeans.Resource configBeanResource, Collection<com.sun.enterprise.config.serverbeans.Resource> configBeanResources) {
        WorkSecurityMap wsm;
        ConnectorConstants.TriState result = ConnectorConstants.TriState.no;
        if (configBeanResource instanceof ConnectorResource) {
            String poolName = ((ConnectorResource)configBeanResource).getPoolName();
            ConnectorConnectionPool pool = ResourcesDeployer.getPool(configBeanResources, poolName);
            if (pool != null) {
                if (pool.getResourceAdapterName().contains("#")) {
                    result = ConnectorConstants.TriState.yes;
                }
            } else {
                result = ConnectorConstants.TriState.unknown;
            }
        } else if (configBeanResource instanceof AdminObjectResource) {
            AdminObjectResource aor = (AdminObjectResource)configBeanResource;
            if (aor.getResAdapter().contains("#")) {
                result = ConnectorConstants.TriState.yes;
            }
        } else if (configBeanResource instanceof ConnectorConnectionPool) {
            ConnectorConnectionPool ccp = (ConnectorConnectionPool)configBeanResource;
            if (ccp.getResourceAdapterName().contains("#")) {
                result = ConnectorConstants.TriState.yes;
            }
        } else if (configBeanResource instanceof WorkSecurityMap && (wsm = (WorkSecurityMap)configBeanResource).getResourceAdapterName().contains("#")) {
            result = ConnectorConstants.TriState.yes;
        }
        return result;
    }

    public static ConnectorConnectionPool getPool(Collection<com.sun.enterprise.config.serverbeans.Resource> configBeanResources, String poolName) {
        ConnectorConnectionPool result = null;
        for (com.sun.enterprise.config.serverbeans.Resource res : configBeanResources) {
            if (!(res instanceof ConnectorConnectionPool) || !((ConnectorConnectionPool)res).getName().equals(poolName)) continue;
            result = (ConnectorConnectionPool)res;
            break;
        }
        return result;
    }

    private static String getApplicationName(DeploymentContext dc) {
        DeployCommandParameters commandParams = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        return commandParams.name();
    }

    public void retrieveAllResourcesXMLs(Map<String, String> fileNames, String path) throws IOException {
        File file = new File(path);
        File[] files = file.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String name;
                String entry = files[i].getAbsolutePath();
                if (entry.endsWith("META-INF/glassfish-resources.xml")) {
                    if (files[i].isDirectory()) continue;
                    name = file.getParentFile().getName();
                    fileNames.put(name, files[i].getAbsolutePath());
                    continue;
                }
                if (entry.endsWith("WEB-INF/glassfish-resources.xml")) {
                    if (files[i].isDirectory()) continue;
                    name = file.getParentFile().getName();
                    fileNames.put(name, files[i].getAbsolutePath());
                    continue;
                }
                if (!files[i].isDirectory()) continue;
                this.retrieveAllResourcesXMLs(fileNames, files[i].getAbsolutePath());
            }
        }
    }

    private static ResourceDeployer getResourceDeployer(Object resource) {
        Collection deployers = habitat.getAllByContract(ResourceDeployer.class);
        for (ResourceDeployer deployer : deployers) {
            if (!deployer.handles(resource)) continue;
            return deployer;
        }
        return null;
    }

    public void event(EventListener.Event event) {
        if (Deployment.DEPLOYMENT_BEFORE_CLASSLOADER_CREATION.equals((Object)event.type())) {
            DeploymentContext dc = (DeploymentContext)event.hook();
            DeployCommandParameters deployParams = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            try {
                if (deployParams.origin == OpsParams.Origin.deploy) {
                    this.processArchive(dc);
                    ResourcesDeployer.createResources(dc, false);
                } else if (deployParams.origin == OpsParams.Origin.load) {
                    ResourcesDeployer.populateResourceConfigInAppInfo(dc);
                }
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    private static void debug(String message) {
        _logger.finest("[ASR] ResourceDeployer : " + message);
    }

    static {
        _logger = LogDomains.getLogger(ConnectorDeployer.class, (String)"javax.enterprise.resource.resourceadapter");
    }
}

