/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.deployer.GlobalResourceDeployer;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class AdminObjectResourceDeployer
extends GlobalResourceDeployer
implements ResourceDeployer {
    @Inject
    private ConnectorRuntime runtime;
    private static Logger _logger = LogDomains.getLogger(AdminObjectResourceDeployer.class, (String)"javax.enterprise.resource.resourceadapter");

    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        AdminObjectResource aor = (AdminObjectResource)resource;
        String jndiName = aor.getJndiName();
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        this.createAdminObjectResource(aor, resourceInfo);
    }

    public synchronized void deployResource(Object resource) throws Exception {
        AdminObjectResource aor = (AdminObjectResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)aor);
        this.createAdminObjectResource(aor, resourceInfo);
    }

    private void createAdminObjectResource(AdminObjectResource aor, ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Calling backend to add adminObject", resourceInfo);
        }
        this.runtime.addAdminObject(null, aor.getResAdapter(), resourceInfo, aor.getResType(), aor.getClassName(), this.transformProps(aor.getProperty()));
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Added adminObject in backend", resourceInfo);
        }
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        AdminObjectResource aor = (AdminObjectResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(aor.getJndiName(), applicationName, moduleName);
        this.deleteAdminObjectResource(resourceInfo);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        AdminObjectResource aor = (AdminObjectResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)aor);
        this.deleteAdminObjectResource(resourceInfo);
    }

    private void deleteAdminObjectResource(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Calling backend to delete adminObject", resourceInfo);
        }
        this.runtime.deleteAdminObject(resourceInfo);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Deleted adminObject in backend", resourceInfo);
        }
    }

    public boolean handles(Object resource) {
        return resource instanceof AdminObjectResource;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public synchronized void redeployResource(Object resource) throws Exception {
    }

    public synchronized void disableResource(Object resource) throws Exception {
    }

    public synchronized void enableResource(Object resource) throws Exception {
    }

    private Properties transformProps(List<Property> domainProps) {
        Properties props = new Properties();
        for (Property domainProp : domainProps) {
            props.setProperty(domainProp.getName(), domainProp.getValue());
        }
        return props;
    }
}

