/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceUtil;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-jndi-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.jndi.resource")
public class CreateJndiResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJndiResource.class);
    @Param(name="restype")
    private String resType;
    @Param(name="factoryclass")
    private String factoryClass;
    @Param(name="jndilookupname")
    private String jndiLookupName;
    @Param(optional=true, defaultValue="true")
    private Boolean enabled;
    @Param(optional=true)
    private String description;
    @Param(name="property", optional=true, separator=58)
    private Properties properties;
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Inject
    private Domain domain;
    @Inject
    private ResourceUtil resourceUtil;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.domain.getResources().getResourceByName(BindableResource.class, this.jndiName) != null) {
            report.setMessage(localStrings.getLocalString("create.jndi.resource.duplicate.1", "Resource named {0} already exists.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Boolean enabledValueForTarget = this.enabled;
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    ExternalJndiResource newResource = (ExternalJndiResource)param.createChild(ExternalJndiResource.class);
                    newResource.setJndiName(CreateJndiResource.this.jndiName);
                    newResource.setFactoryClass(CreateJndiResource.this.factoryClass);
                    newResource.setResType(CreateJndiResource.this.resType);
                    newResource.setJndiLookupName(CreateJndiResource.this.jndiLookupName);
                    if (CreateJndiResource.this.target != null) {
                        CreateJndiResource.this.enabled = Boolean.valueOf(CreateJndiResource.this.resourceUtil.computeEnabledValueForResourceBasedOnTarget(CreateJndiResource.this.enabled.toString(), CreateJndiResource.this.target));
                    }
                    newResource.setEnabled(CreateJndiResource.this.enabled.toString());
                    if (CreateJndiResource.this.description != null) {
                        newResource.setDescription(CreateJndiResource.this.description);
                    }
                    if (CreateJndiResource.this.properties != null) {
                        for (Map.Entry<Object, Object> e : CreateJndiResource.this.properties.entrySet()) {
                            Property prop = (Property)newResource.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)this.domain.getResources());
            this.resourceUtil.createResourceRef(this.jndiName, enabledValueForTarget.toString(), this.target);
            report.setMessage(localStrings.getLocalString("create.jndi.resource.success", "JNDI resource {0} created.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.jndi.resource.fail", "Unable to create JNDI resource {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
    }
}

