/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.JavaEEResource;
import com.sun.appserv.connectors.internal.api.ResourceNamingService;
import com.sun.appserv.connectors.internal.api.ResourcePropertyImpl;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.container.common.impl.MailNamingObjectFactory;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.interfaces.MailResourceIntf;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.resource.deployer.GlobalResourceDeployer;
import com.sun.enterprise.resource.naming.SerializableObjectRefAddr;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Session;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.glassfish.resource.common.GenericResourceInfo;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.types.Property;

@Service
@Scoped(value=Singleton.class)
public class MailResourceDeployer
extends GlobalResourceDeployer
implements ResourceDeployer {
    @Inject
    private ResourceNamingService namingService;
    private static final StringManager localStrings = StringManager.getManager(MailResourceDeployer.class);
    private static Logger _logger = LogDomains.getLogger(MailResourceDeployer.class, (String)"javax.enterprise.resource.resourceadapter");

    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        MailResource mailRes = (MailResource)resource;
        if (mailRes == null) {
            _logger.log(Level.INFO, "core.resourcedeploy_error");
        } else if (ConnectorsUtil.parseBoolean((String)mailRes.getEnabled())) {
            ResourceInfo resourceInfo = new ResourceInfo(mailRes.getJndiName(), applicationName, moduleName);
            this.installResource(mailRes, resourceInfo);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{mailRes.getJndiName(), "mail"});
        }
    }

    public synchronized void deployResource(Object resource) throws Exception {
        MailResource mailResource = (MailResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)mailResource);
        this.deployResource(resource, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    void installResource(MailResource mailResource, ResourceInfo resourceInfo) throws Exception {
        JavaEEResource j2eeRes = MailResourceDeployer.toMailJavaEEResource(mailResource, resourceInfo);
        this.installMailResource((com.sun.enterprise.resource.beans.MailResource)j2eeRes, resourceInfo);
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        MailResource mailRes = (MailResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(mailRes.getJndiName(), applicationName, moduleName);
        this.deleteResource(mailRes, resourceInfo);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        MailResource mailRes = (MailResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)mailRes);
        this.deleteResource(mailRes, resourceInfo);
    }

    private void deleteResource(MailResource mailRes, ResourceInfo resourceInfo) throws NamingException {
        this.namingService.unpublishObject((GenericResourceInfo)resourceInfo, mailRes.getJndiName());
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof MailResource;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public void installMailResource(com.sun.enterprise.resource.beans.MailResource mailResource, ResourceInfo resourceInfo) {
        try {
            MailConfiguration config = new MailConfiguration((MailResourceIntf)mailResource);
            Reference ref = new Reference(Session.class.getName(), MailNamingObjectFactory.class.getName(), null);
            SerializableObjectRefAddr serializableRefAddr = new SerializableObjectRefAddr("jndiName", config);
            ref.add(serializableRefAddr);
            this.namingService.publishObject(resourceInfo, (Object)ref, true);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "mailrsrc.create_obj_error", resourceInfo);
            _logger.log(Level.SEVERE, "mailrsrc.create_obj_error_excp", ex);
        }
    }

    public static JavaEEResource toMailJavaEEResource(MailResource mailResourceConfig, ResourceInfo resourceInfo) {
        com.sun.enterprise.resource.beans.MailResource mailResource = new com.sun.enterprise.resource.beans.MailResource(resourceInfo);
        mailResource.setEnabled(ConnectorsUtil.parseBoolean((String)mailResourceConfig.getEnabled()));
        mailResource.setStoreProtocol(mailResourceConfig.getStoreProtocol());
        mailResource.setStoreProtocolClass(mailResourceConfig.getStoreProtocolClass());
        mailResource.setTransportProtocol(mailResourceConfig.getTransportProtocol());
        mailResource.setTransportProtocolClass(mailResourceConfig.getTransportProtocolClass());
        mailResource.setMailHost(mailResourceConfig.getHost());
        mailResource.setUsername(mailResourceConfig.getUser());
        mailResource.setMailFrom(mailResourceConfig.getFrom());
        mailResource.setDebug(ConnectorsUtil.parseBoolean((String)mailResourceConfig.getDebug()));
        List properties = mailResourceConfig.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                ResourcePropertyImpl rp = new ResourcePropertyImpl(property.getName(), (Object)property.getValue());
                mailResource.addProperty((ResourceProperty)rp);
            }
        }
        return mailResource;
    }
}

