/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.PoolMetaData;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.DynamicallyReconfigurableResource;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnectionFactory;
import javax.validation.Validator;
import org.glassfish.resource.common.PoolInfo;
import org.glassfish.resource.common.ResourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorRegistry {
    static final Logger _logger = LogDomains.getLogger(ConnectorRegistry.class, (String)"javax.enterprise.resource.resourceadapter");
    protected static final ConnectorRegistry connectorRegistryInstance = new ConnectorRegistry();
    protected final Map<String, ActiveResourceAdapter> resourceAdapters = Collections.synchronizedMap(new HashMap());
    protected final Map<PoolInfo, PoolMetaData> factories = Collections.synchronizedMap(new HashMap());
    protected final Map<String, ResourceAdapterConfig> resourceAdapterConfig = Collections.synchronizedMap(new HashMap());
    protected final Map<String, ConnectorApplication> rarModules = Collections.synchronizedMap(new HashMap());
    protected final Map<String, Validator> beanValidators = Collections.synchronizedMap(new HashMap());
    protected final Map<ResourceInfo, Map<DynamicallyReconfigurableResource, Boolean>> resourceProxies = new HashMap<ResourceInfo, Map<DynamicallyReconfigurableResource, Boolean>>();

    public static ConnectorRegistry getInstance() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("returning the connector registry");
        }
        return connectorRegistryInstance;
    }

    protected ConnectorRegistry() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "initialized the connector registry");
        }
    }

    public void addActiveResourceAdapter(String rarModuleName, ActiveResourceAdapter rar) {
        this.resourceAdapters.put(rarModuleName, rar);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Added the active resource adapter to connector registry", rarModuleName);
        }
    }

    public Map<DynamicallyReconfigurableResource, Boolean> getResourceFactories(ResourceInfo resourceInfo) {
        Map<DynamicallyReconfigurableResource, Boolean> map = this.resourceProxies.get(resourceInfo);
        if (map == null) {
            map = new HashMap<DynamicallyReconfigurableResource, Boolean>();
            this.resourceProxies.put(resourceInfo, map);
        }
        return map;
    }

    public boolean removeResourceFactories(ResourceInfo resourceInfo) {
        boolean mapRemoved = false;
        Map<DynamicallyReconfigurableResource, Boolean> map = this.resourceProxies.remove(resourceInfo);
        if (map != null) {
            for (DynamicallyReconfigurableResource resource : map.keySet()) {
                resource.setInvalid();
            }
            map.clear();
            mapRemoved = true;
        }
        return mapRemoved;
    }

    public boolean removeActiveResourceAdapter(String rarModuleName) {
        ActiveResourceAdapter o = this.resourceAdapters.remove(rarModuleName);
        if (o == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Failed to remove the resource adapter from connector registry" + rarModuleName);
            }
            return false;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("removed the active resource adapter from connector registry" + rarModuleName);
        }
        return true;
    }

    public ActiveResourceAdapter getActiveResourceAdapter(String rarModuleName) {
        if (rarModuleName != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("returning/found the resource adapter from connector registry" + rarModuleName);
            }
            return this.resourceAdapters.get(rarModuleName);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Resourceadapter not found in connector registry.Returning null" + rarModuleName);
        }
        return null;
    }

    public void addBeanValidator(String rarModuleName, Validator validator) {
        this.beanValidators.put(rarModuleName, validator);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Added the bean validator for RAR [ " + rarModuleName + " ] to connector registry");
        }
    }

    public Validator getBeanValidator(String rarModuleName) {
        if (rarModuleName != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("returning/found the validator for RAR [ " + rarModuleName + " ] from connector registry");
            }
            return this.beanValidators.get(rarModuleName);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("bean validator for RAR [ " + rarModuleName + " ] not found in connector registry.Returning null");
        }
        return null;
    }

    public boolean removeBeanValidator(String rarModuleName) {
        Validator o = this.beanValidators.remove(rarModuleName);
        if (o == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Failed to remove the bean validator for RAR [ " + rarModuleName + " ] from connector registry");
            }
            return false;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("removed the active bean validator for RAR [ " + rarModuleName + " ] from connector registry");
        }
        return true;
    }

    public boolean isMCFCreated(PoolInfo poolInfo) {
        boolean created = this.factories.containsKey(poolInfo);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("isMCFCreated " + poolInfo + " - " + created);
        }
        return created;
    }

    public boolean removeManagedConnectionFactory(PoolInfo poolInfo) {
        if (this.factories.remove(poolInfo) == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Failed to remove the MCF from connector registry.", poolInfo);
            }
            return false;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("removeMCF " + poolInfo + " - " + !this.factories.containsKey(poolInfo));
        }
        return true;
    }

    public void addManagedConnectionFactory(PoolInfo poolInfo, PoolMetaData pmd) {
        this.factories.put(poolInfo, pmd);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Added MCF to connector registry for: " + poolInfo);
        }
    }

    public ManagedConnectionFactory getManagedConnectionFactory(PoolInfo poolInfo) {
        if (poolInfo != null) {
            PoolMetaData pmd;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Returning the MCF from connector registry.", poolInfo);
            }
            if ((pmd = this.factories.get(poolInfo)) != null) {
                return pmd.getMCF();
            }
        }
        return null;
    }

    public boolean isRegistered(String rarModuleName) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Checking for MCF presence in connector registry.", rarModuleName);
        }
        return this.resourceAdapters.containsKey(rarModuleName);
    }

    public ConnectorDescriptor getDescriptor(String rarModuleName) {
        ActiveResourceAdapter ar = null;
        if (rarModuleName != null) {
            ar = this.resourceAdapters.get(rarModuleName);
        }
        if (ar != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Found/returing Connector descriptor in connector registry.", rarModuleName);
            }
            return ar.getDescriptor();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Couldnot find Connector descriptor in connector registry.", rarModuleName);
        }
        return null;
    }

    public RuntimeSecurityMap getRuntimeSecurityMap(PoolInfo poolInfo) {
        if (poolInfo != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Returing the security map from connector registry.", poolInfo);
            }
            PoolMetaData pmd = this.factories.get(poolInfo);
            return pmd.getRuntimeSecurityMap();
        }
        return null;
    }

    public ResourceAdapterConfig getResourceAdapterConfig(String rarName) {
        if (rarName != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Returing the resourceadapter Config from registry.", rarName);
            }
            return this.resourceAdapterConfig.get(rarName);
        }
        return null;
    }

    public void addResourceAdapterConfig(String rarName, ResourceAdapterConfig raConfig) {
        if (rarName != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Adding the resourceAdapter Config to connector registry.", rarName);
            }
            this.resourceAdapterConfig.put(rarName, raConfig);
        }
    }

    public boolean removeResourceAdapterConfig(String rarName) {
        if (this.resourceAdapterConfig.remove(rarName) == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "failed to remove the resourceAdapter config from registry.", rarName);
            }
            return false;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Removed the resourceAdapter config map from registry.", rarName);
        }
        return true;
    }

    public ActiveResourceAdapter[] getAllActiveResourceAdapters() {
        return this.resourceAdapters.values().toArray(new ActiveResourceAdapter[0]);
    }

    public PoolMetaData getPoolMetaData(PoolInfo poolInfo) {
        return this.factories.get(poolInfo);
    }

    public void addConnectorApplication(ConnectorApplication rarModule) {
        this.rarModules.put(rarModule.getModuleName(), rarModule);
    }

    public ConnectorApplication getConnectorApplication(String rarName) {
        return this.rarModules.get(rarName);
    }

    public void removeConnectorApplication(String rarName) {
        this.rarModules.remove(rarName);
    }

    public List<String> getConnectorsSupportingMessageListener(String messageListener) {
        ArrayList<String> rars = new ArrayList<String>();
        for (ActiveResourceAdapter ara : this.resourceAdapters.values()) {
            ConnectorDescriptor desc = ara.getDescriptor();
            if (!desc.getInBoundDefined() || desc.getInboundResourceAdapter().getMessageListener(messageListener) == null) continue;
            rars.add(ara.getModuleName());
        }
        return rars;
    }
}

