/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.MCFConfigParser;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.logging.LogDomains;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MCFConfigParserImpl
implements MCFConfigParser {
    static Logger _logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"javax.enterprise.resource.resourceadapter");

    public String[] getConnectionDefinitionNames(ConnectorDescriptor desc) throws ConnectorRuntimeException {
        if (desc == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }
        ConnectionDefDescriptor[] cdd = ConnectorDDTransformUtils.getConnectionDefs(desc);
        String[] connDefNames = new String[]{};
        if (cdd != null) {
            connDefNames = new String[cdd.length];
            for (int i = 0; i < cdd.length; ++i) {
                connDefNames[i] = cdd[i].getConnectionFactoryIntf();
            }
        }
        return connDefNames;
    }

    public Properties getJavaBeanProps(ConnectorDescriptor desc, String connectionDefName, String rarName) throws ConnectorRuntimeException {
        if (desc == null || connectionDefName == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }
        OutboundResourceAdapter ora = desc.getOutboundResourceAdapter();
        if (ora == null || ora.getConnectionDefs().size() == 0) {
            return null;
        }
        Set connectionDefs = ora.getConnectionDefs();
        if (connectionDefs == null || connectionDefs.size() == 0) {
            return null;
        }
        Iterator iter = connectionDefs.iterator();
        ConnectionDefDescriptor cdd = null;
        boolean connectionDefFound = false;
        while (iter.hasNext()) {
            cdd = (ConnectionDefDescriptor)iter.next();
            if (!connectionDefName.equals(cdd.getConnectionFactoryIntf())) continue;
            connectionDefFound = true;
            break;
        }
        if (!connectionDefFound) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "No such connectiondefinition found in ra.xml", connectionDefName);
            }
            throw new ConnectorRuntimeException("No such connectiondefinition found in ra.xml : " + connectionDefName);
        }
        Properties mergedVals = null;
        Set ddVals = cdd.getConfigProperties();
        String className = cdd.getManagedConnectionFactoryImpl();
        if (className != null && className.length() != 0) {
            Properties introspectedVals = configParserUtil.introspectJavaBean(className, ddVals, true, rarName);
            mergedVals = configParserUtil.mergeProps(ddVals, introspectedVals);
        }
        return mergedVals;
    }
}

