/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.admin.cli.ConnectorResourceManager;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-connector-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.connector.resource")
public class CreateConnectorResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateConnectorResource.class);
    @Param(name="poolname")
    private String poolName;
    @Param(name="enabled", optional=true, defaultValue="true")
    private Boolean enabled;
    @Param(name="description", optional=true)
    private String description;
    @Param(name="objecttype", defaultValue="user", optional=true)
    private String objectType;
    @Param(name="property", optional=true, separator=58)
    private Properties properties;
    @Param(name="target", optional=true)
    private String target = "server";
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Inject
    private Domain domain;
    @Inject
    private ConnectorResourceManager connResMgr;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("pool-name", this.poolName);
        attrList.put("enabled", this.enabled.toString());
        attrList.put("jndi-name", this.jndiName);
        attrList.put("description", this.description);
        attrList.put("object-type", this.objectType);
        try {
            rs = this.connResMgr.create(this.domain.getResources(), attrList, this.properties, this.target);
        }
        catch (Exception e) {
            Logger.getLogger(CreateConnectorResource.class.getName()).log(Level.SEVERE, "Unable to create connector resource " + this.jndiName, e);
            String def = "Connector resource: {0} could not be created, reason: {1}";
            report.setMessage(localStrings.getLocalString("create.connector.resource.fail", def, new Object[]{this.jndiName}) + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getMessage() == null) {
                report.setMessage(localStrings.getLocalString("create.connector.resource.fail", "Connector resource {0} creation failed", new Object[]{this.jndiName, ""}));
            }
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        if (rs.getMessage() != null) {
            report.setMessage(rs.getMessage());
        }
        report.setActionExitCode(ec);
    }
}

