/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.connectors.module.ResourcesDeployer;
import com.sun.enterprise.connectors.util.ClassLoadingUtility;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.net.URI;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.RelativePathResolver;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.resource.common.GenericResourceInfo;
import org.glassfish.resource.common.PoolInfo;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.config.ConfigBeanProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesUtil {
    static Logger _logger = LogDomains.getLogger(ResourcesUtil.class, (String)"javax.enterprise.resource.resourceadapter");
    static StringManager localStrings = StringManager.getManager(ResourcesUtil.class);
    static ServerContext sc_ = null;
    protected Domain domain = null;
    protected Resources resources = null;
    private ConnectorRuntime runtime;
    private Server server;
    private static ResourcesUtil resourcesUtil;

    private ResourcesUtil() {
    }

    private Resources getGlobalResources() {
        ResourceInfo resourceInfo = null;
        return this.getRuntime().getResources(resourceInfo);
    }

    public Resources getResources(ResourceInfo resourceInfo) {
        return this.getRuntime().getResources(resourceInfo);
    }

    public Resources getResources(PoolInfo poolInfo) {
        return this.getRuntime().getResources(poolInfo);
    }

    private Domain getDomain() {
        if (this.domain == null) {
            this.domain = this.getRuntime().getDomain();
        }
        return this.domain;
    }

    private ConnectorRuntime getRuntime() {
        if (this.runtime == null) {
            this.runtime = ConnectorRuntime.getRuntime();
        }
        return this.runtime;
    }

    private Server getServer() {
        if (this.server == null) {
            this.server = this.getDomain().getServerNamed(this.getRuntime().getServerEnvironment().getInstanceName());
        }
        return this.server;
    }

    private Applications getApplications() {
        return this.getRuntime().getApplications();
    }

    private ConnectorModule getConnectorModuleByName(String name) {
        ConnectorModule module = null;
        List modules = this.getApplications().getModules(ConnectorModule.class);
        for (ConnectorModule connectorModule : modules) {
            if (!connectorModule.getName().equals(name)) continue;
            module = connectorModule;
            break;
        }
        return module;
    }

    private com.sun.enterprise.config.serverbeans.Application getApplicationByName(String name) {
        com.sun.enterprise.config.serverbeans.Application application = null;
        List apps = this.getApplications().getApplications();
        for (com.sun.enterprise.config.serverbeans.Application app : apps) {
            if (!app.getName().equals(name)) continue;
            application = app;
            break;
        }
        return application;
    }

    public String getApplicationDeployLocation(String appName) {
        String location = null;
        com.sun.enterprise.config.serverbeans.Application app = this.getApplicationByName(appName);
        if (app != null) {
            location = RelativePathResolver.resolvePath((String)app.getLocation());
        }
        return location;
    }

    public boolean belongToStandAloneRar(String resourceAdapterName) {
        ConnectorModule connectorModule = this.getConnectorModuleByName(resourceAdapterName);
        return connectorModule != null;
    }

    public static ResourcesUtil createInstance() {
        if (resourcesUtil == null) {
            resourcesUtil = new ResourcesUtil();
        }
        return resourcesUtil;
    }

    public String getRANameofJdbcConnectionPool(JdbcConnectionPool pool) {
        String dsRAName = "__ds_jdbc_ra";
        Class dsClass = null;
        if (pool.getDatasourceClassname() != null) {
            try {
                dsClass = ClassLoadingUtility.loadClass(pool.getDatasourceClassname());
            }
            catch (ClassNotFoundException cnfe) {
                Object[] params = new Object[]{dsRAName, pool.getName()};
                _logger.log(Level.WARNING, "using.default.ds", params);
                return dsRAName;
            }
        }
        if (pool.getDriverClassname() != null) {
            try {
                dsClass = ClassLoadingUtility.loadClass(pool.getDriverClassname());
            }
            catch (ClassNotFoundException cnfe) {
                Object[] params = new Object[]{dsRAName, pool.getName()};
                _logger.log(Level.WARNING, "using.default.ds", params);
                return dsRAName;
            }
        }
        if ("javax.sql.XADataSource".equals(pool.getResType()) && XADataSource.class.isAssignableFrom(dsClass)) {
            return "__xa_jdbc_ra";
        }
        if ("javax.sql.ConnectionPoolDataSource".equals(pool.getResType()) && ConnectionPoolDataSource.class.isAssignableFrom(dsClass)) {
            return "__cp_jdbc_ra";
        }
        if ("java.sql.Driver".equals(pool.getResType()) && Driver.class.isAssignableFrom(dsClass)) {
            return "__dm_jdbc_ra";
        }
        if ("javax.sql.DataSource".equals(pool.getResType()) && DataSource.class.isAssignableFrom(dsClass)) {
            return dsRAName;
        }
        Object[] params = new Object[]{dsRAName, pool.getName()};
        _logger.log(Level.WARNING, "using.default.ds", params);
        return dsRAName;
    }

    public DeferredResourceConfig getDeferredResourceConfig(ResourceInfo resourceInfo) {
        DeferredResourceConfig resConfig = this.getDeferredConnectorResourceConfigs(resourceInfo);
        if (resConfig != null) {
            return resConfig;
        }
        resConfig = this.getDeferredJdbcResourceConfigs(resourceInfo);
        if (resConfig != null) {
            return resConfig;
        }
        resConfig = this.getDeferredAdminObjectConfigs(resourceInfo);
        return resConfig;
    }

    public DeferredResourceConfig getDeferredPoolConfig(PoolInfo poolInfo) {
        DeferredResourceConfig resConfig = this.getDeferredConnectorPoolConfigs(poolInfo);
        if (resConfig != null) {
            return resConfig;
        }
        if (poolInfo == null) {
            return null;
        }
        resConfig = this.getDeferredJdbcPoolConfigs(poolInfo);
        return resConfig;
    }

    public DeferredResourceConfig getDeferredResourceConfig(Object resource, Object pool, String resType, String raName) throws ConnectorRuntimeException {
        String resourceAdapterName = raName;
        DeferredResourceConfig resConfig = null;
        if ("jdbc".equalsIgnoreCase(resType) || "jcp".equalsIgnoreCase(resType)) {
            JdbcConnectionPool jdbcPool = (JdbcConnectionPool)pool;
            JdbcResource jdbcResource = (JdbcResource)resource;
            resourceAdapterName = this.getRANameofJdbcConnectionPool((JdbcConnectionPool)pool);
            resConfig = new DeferredResourceConfig(resourceAdapterName, null, null, null, jdbcPool, jdbcResource, null);
            Resource[] resourcesToload = new Resource[]{jdbcPool, jdbcResource};
            resConfig.setResourcesToLoad(resourcesToload);
        } else if ("cr".equalsIgnoreCase(resType) || "ccp".equalsIgnoreCase(resType)) {
            ConnectorConnectionPool connPool = (ConnectorConnectionPool)pool;
            ConnectorResource connResource = (ConnectorResource)resource;
            resourceAdapterName = connPool.getResourceAdapterName();
            resConfig = new DeferredResourceConfig(resourceAdapterName, null, connPool, connResource, null, null, null);
            Resource[] resourcesToload = new Resource[]{connPool, connResource};
            resConfig.setResourcesToLoad(resourcesToload);
        } else {
            throw new ConnectorRuntimeException("unsupported resource type : " + resType);
        }
        return resConfig;
    }

    public DeferredResourceConfig getDeferredJdbcResourceConfig(JdbcResource resource, JdbcConnectionPool pool) {
        DeferredResourceConfig resConfig = null;
        if (this.parseBoolean(resource.getEnabled())) {
            String rarName = this.getRANameofJdbcConnectionPool(pool);
            resConfig = new DeferredResourceConfig(rarName, null, null, null, pool, resource, null);
            Resource[] resourcesToload = new Resource[]{pool, resource};
            resConfig.setResourcesToLoad(resourcesToload);
        }
        return resConfig;
    }

    protected DeferredResourceConfig getDeferredConnectorResourceConfigs(ResourceInfo resourceInfo) {
        ConnectorResource connectorResource;
        Resource[] resourcesToload;
        block7: {
            if (resourceInfo == null) {
                return null;
            }
            resourcesToload = new Resource[2];
            try {
                if (!this.isReferenced(resourceInfo)) {
                    return null;
                }
            }
            catch (Exception e) {
                String message = localStrings.getString("error.finding.resources.references", (Object)resourceInfo);
                _logger.log(Level.WARNING, message + e.getMessage());
                if (!_logger.isLoggable(Level.FINE)) break block7;
                _logger.log(Level.FINE, message + e.getMessage(), e);
            }
        }
        if ((connectorResource = (ConnectorResource)this.getResources(resourceInfo).getResourceByName(ConnectorResource.class, resourceInfo.getName())) == null || !ConnectorsUtil.parseBoolean((String)connectorResource.getEnabled())) {
            return null;
        }
        String poolName = connectorResource.getPoolName();
        ConnectorConnectionPool ccPool = (ConnectorConnectionPool)this.getResources(resourceInfo).getResourceByName(ConnectorConnectionPool.class, poolName);
        if (ccPool == null) {
            return null;
        }
        String rarName = ccPool.getResourceAdapterName();
        if (rarName != null) {
            resourcesToload[0] = ccPool;
            resourcesToload[1] = connectorResource;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{(ResourceAdapterConfig)this.getGlobalResources().getResourceByName(ResourceAdapterConfig.class, rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, ccPool, connectorResource, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredJdbcResourceConfigs(ResourceInfo resourceInfo) {
        JdbcConnectionPool jdbcPool;
        JdbcResource jdbcResource;
        Resource[] resourcesToload;
        block8: {
            resourcesToload = new Resource[2];
            if (resourceInfo == null) {
                return null;
            }
            try {
                if (!resourceInfo.getName().endsWith("__pm") && !this.isReferenced(resourceInfo)) {
                    return null;
                }
            }
            catch (Exception e) {
                String message = localStrings.getString("error.finding.resources.references", (Object)resourceInfo);
                _logger.log(Level.WARNING, message + e.getMessage());
                if (!_logger.isLoggable(Level.FINE)) break block8;
                _logger.log(Level.FINE, message + e.getMessage(), e);
            }
        }
        if ((jdbcResource = (JdbcResource)this.getResources(resourceInfo).getResourceByName(JdbcResource.class, resourceInfo.getName())) == null || !ConnectorsUtil.parseBoolean((String)jdbcResource.getEnabled())) {
            String cmpResourceName = this.getCorrespondingCmpResourceName(resourceInfo);
            jdbcResource = (JdbcResource)this.getResources(resourceInfo).getResourceByName(JdbcResource.class, cmpResourceName);
            if (jdbcResource == null) {
                return null;
            }
        }
        if ((jdbcPool = (JdbcConnectionPool)this.getResources(resourceInfo).getResourceByName(JdbcConnectionPool.class, jdbcResource.getPoolName())) == null) {
            return null;
        }
        String rarName = this.getRANameofJdbcConnectionPool(jdbcPool);
        if (rarName != null && ConnectorsUtil.belongsToSystemRA((String)rarName)) {
            resourcesToload[0] = jdbcPool;
            resourcesToload[1] = jdbcResource;
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, null, null, jdbcPool, jdbcResource, null);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredAdminObjectConfigs(ResourceInfo resourceInfo) {
        AdminObjectResource adminObjectResource;
        Resource[] resourcesToload;
        block6: {
            if (resourceInfo == null) {
                return null;
            }
            resourcesToload = new Resource[1];
            try {
                if (!this.isReferenced(resourceInfo)) {
                    return null;
                }
            }
            catch (Exception e) {
                String message = localStrings.getString("error.finding.resources.references", (Object)resourceInfo);
                _logger.log(Level.WARNING, message + e.getMessage());
                if (!_logger.isLoggable(Level.FINE)) break block6;
                _logger.log(Level.FINE, message + e.getMessage(), e);
            }
        }
        if ((adminObjectResource = (AdminObjectResource)this.getResources(resourceInfo).getResourceByName(AdminObjectResource.class, resourceInfo.getName())) == null || !ConnectorsUtil.parseBoolean((String)adminObjectResource.getEnabled())) {
            return null;
        }
        String rarName = adminObjectResource.getResAdapter();
        if (rarName != null) {
            resourcesToload[0] = adminObjectResource;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{(ResourceAdapterConfig)this.getGlobalResources().getResourceByName(ResourceAdapterConfig.class, rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, adminObjectResource, null, null, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected String getCorrespondingCmpResourceName(ResourceInfo resourceInfo) {
        int index = resourceInfo.getName().lastIndexOf("__pm");
        if (index != -1) {
            return resourceInfo.getName().substring(0, index);
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredConnectorPoolConfigs(PoolInfo poolInfo) {
        Resource[] resourcesToload = new Resource[1];
        if (poolInfo == null) {
            return null;
        }
        ConnectorConnectionPool ccPool = (ConnectorConnectionPool)this.getResources(poolInfo).getResourceByName(ConnectorConnectionPool.class, poolInfo.getName());
        if (ccPool == null) {
            return null;
        }
        String rarName = ccPool.getResourceAdapterName();
        if (rarName != null) {
            resourcesToload[0] = ccPool;
            ResourceAdapterConfig[] resourceAdapterConfig = new ResourceAdapterConfig[]{(ResourceAdapterConfig)this.getGlobalResources().getResourceByName(ResourceAdapterConfig.class, rarName)};
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, ccPool, null, null, null, resourceAdapterConfig);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected DeferredResourceConfig getDeferredJdbcPoolConfigs(PoolInfo poolInfo) {
        Resource[] resourcesToload = new Resource[1];
        if (poolInfo == null) {
            return null;
        }
        JdbcConnectionPool jdbcPool = (JdbcConnectionPool)this.getResources(poolInfo).getResourceByName(JdbcConnectionPool.class, poolInfo.getName());
        if (jdbcPool == null) {
            return null;
        }
        String rarName = this.getRANameofJdbcConnectionPool(jdbcPool);
        if (rarName != null && ConnectorsUtil.belongsToSystemRA((String)rarName)) {
            resourcesToload[0] = jdbcPool;
            DeferredResourceConfig resourceConfig = new DeferredResourceConfig(rarName, null, null, null, jdbcPool, null, null);
            resourceConfig.setResourcesToLoad(resourcesToload);
            return resourceConfig;
        }
        return null;
    }

    protected boolean isReferenced(ResourceInfo resourceInfo) {
        boolean refExists = false;
        if (ConnectorsUtil.isModuleScopedResource((GenericResourceInfo)resourceInfo) || ConnectorsUtil.isApplicationScopedResource((GenericResourceInfo)resourceInfo)) {
            refExists = this.getServer().getApplicationRef(resourceInfo.getApplicationName()) != null;
        } else {
            String resourceName = resourceInfo.getName();
            refExists = this.getServer().isResourceRefExists(resourceName);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("isReferenced :: " + resourceInfo + " - " + refExists);
        }
        return refExists;
    }

    public boolean isEnabled(com.sun.enterprise.config.serverbeans.Application application) {
        if (application == null) {
            return false;
        }
        boolean appEnabled = Boolean.valueOf(application.getEnabled());
        ApplicationRef appRef = this.getServer().getApplicationRef(application.getName());
        boolean appRefEnabled = false;
        if (appRef != null) {
            appRefEnabled = Boolean.valueOf(appRef.getEnabled());
        }
        return appEnabled && appRefEnabled;
    }

    public boolean isEnabled(Resource resource) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: isEnabled");
        }
        if (resource == null) {
            return false;
        }
        if (resource instanceof BindableResource) {
            ResourceRef resRef = this.getServer().getResourceRef(((BindableResource)resource).getJndiName());
            return this.isEnabled((BindableResource)resource) && resRef != null && this.parseBoolean(resRef.getEnabled());
        }
        if (resource instanceof ResourcePool) {
            return this.isEnabled((ResourcePool)resource);
        }
        return resource instanceof WorkSecurityMap || resource instanceof ResourceAdapterConfig;
    }

    public boolean isEnabled(ResourcePool pool) {
        boolean enabled = true;
        if (pool == null) {
            return false;
        }
        if (pool instanceof JdbcConnectionPool) {
            enabled = true;
        } else if (pool instanceof ConnectorConnectionPool) {
            ConnectorConnectionPool ccpool = (ConnectorConnectionPool)pool;
            String raName = ccpool.getResourceAdapterName();
            enabled = this.isRarEnabled(raName);
        }
        return enabled;
    }

    public boolean isEnabled(BindableResource br) {
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)br);
        boolean enabled = false;
        if (br == null) {
            return false;
        }
        boolean resourceEnabled = ConnectorsUtil.parseBoolean((String)br.getEnabled());
        boolean refEnabled = this.isResourceReferenceEnabled(resourceInfo);
        if (br instanceof JdbcResource || br instanceof MailResource || br instanceof ExternalJndiResource || br instanceof CustomResource) {
            if (resourceEnabled && refEnabled) {
                enabled = true;
            }
        } else if (br instanceof ConnectorResource) {
            ConnectorResource cr = (ConnectorResource)br;
            String poolName = cr.getPoolName();
            ConnectorConnectionPool ccp = (ConnectorConnectionPool)this.getResources(resourceInfo).getResourceByName(ConnectorConnectionPool.class, poolName);
            if (ccp == null) {
                return false;
            }
            boolean poolEnabled = this.isEnabled((ResourcePool)ccp);
            enabled = poolEnabled && resourceEnabled && refEnabled;
        } else if (br instanceof AdminObjectResource) {
            AdminObjectResource aor = (AdminObjectResource)br;
            String raName = aor.getResAdapter();
            boolean isRarEnabled = this.isRarEnabled(raName);
            if (resourceEnabled && refEnabled) {
                enabled = true;
            }
        }
        return enabled;
    }

    private boolean isRarEnabled(String raName) {
        if (raName == null || raName.length() == 0) {
            return false;
        }
        com.sun.enterprise.config.serverbeans.Application application = this.getDomain().getApplications().getApplication(raName);
        if (application != null) {
            return this.isApplicationReferenceEnabled(raName);
        }
        if (ConnectorsUtil.belongsToSystemRA((String)raName)) {
            return true;
        }
        return this.belongToEmbeddedRarAndEnabled(raName);
    }

    private boolean isApplicationReferenceEnabled(String appName) {
        ApplicationRef appRef = this.getServer().getApplicationRef(appName);
        if (appRef == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ResourcesUtil :: isApplicationReferenceEnabled null ref");
            }
            return false;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: isApplicationReferenceEnabled appRef enabled ?" + appRef.getEnabled());
        }
        return ConnectorsUtil.parseBoolean((String)appRef.getEnabled());
    }

    public Collection<AdminObjectResource> getEnabledAdminObjectResources(String raName) {
        ArrayList<AdminObjectResource> allResources = new ArrayList<AdminObjectResource>();
        allResources.addAll(this.getEnabledAdminObjectResources(raName, this.getGlobalResources()));
        return allResources;
    }

    public Collection<AdminObjectResource> getEnabledAdminObjectResources(String raName, Resources resources) {
        ArrayList<AdminObjectResource> adminObjectResources = new ArrayList<AdminObjectResource>();
        for (AdminObjectResource resource : resources.getResources(AdminObjectResource.class)) {
            AdminObjectResource adminObjectResource = resource;
            String resourceAdapterName = adminObjectResource.getResAdapter();
            if (resourceAdapterName == null || raName != null && !raName.equals(resourceAdapterName) || !this.isEnabled((BindableResource)adminObjectResource)) continue;
            adminObjectResources.add(adminObjectResource);
        }
        return adminObjectResources;
    }

    private boolean belongToEmbeddedRarAndEnabled(String resourceAdapterName) {
        String appName = this.getAppNameToken(resourceAdapterName);
        if (appName == null) {
            return false;
        }
        Applications apps = this.getDomain().getApplications();
        com.sun.enterprise.config.serverbeans.Application app = apps.getApplication(appName);
        if (app == null || !ConnectorsUtil.parseBoolean((String)app.getEnabled())) {
            return false;
        }
        return this.isApplicationReferenceEnabled(appName);
    }

    private String getAppNameToken(String rarName) {
        if (rarName == null) {
            return null;
        }
        int index = rarName.indexOf("#");
        if (index != -1) {
            return rarName.substring(0, index);
        }
        return null;
    }

    private boolean isResourceReferenceEnabled(ResourceInfo resourceInfo) {
        String enabled = "false";
        if (ConnectorsUtil.isModuleScopedResource((GenericResourceInfo)resourceInfo) || ConnectorsUtil.isApplicationScopedResource((GenericResourceInfo)resourceInfo)) {
            ApplicationRef appRef = this.getServer().getApplicationRef(resourceInfo.getApplicationName());
            if (appRef != null) {
                enabled = appRef.getEnabled();
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ResourcesUtil :: isResourceReferenceEnabled null app-ref");
            }
        } else {
            ResourceRef ref = this.getServer().getResourceRef(resourceInfo.getName());
            if (ref != null) {
                enabled = ref.getEnabled();
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ResourcesUtil :: isResourceReferenceEnabled null ref");
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: isResourceReferenceEnabled ref enabled ?" + enabled);
        }
        return ConnectorsUtil.parseBoolean((String)enabled);
    }

    public String getResourceType(ConfigBeanProxy cb) {
        if (cb instanceof ConnectorConnectionPool) {
            return "ccp";
        }
        if (cb instanceof ConnectorResource) {
            return "cr";
        }
        if (cb instanceof JdbcConnectionPool) {
            return "jcp";
        }
        if (cb instanceof JdbcResource) {
            return "jdbc";
        }
        return null;
    }

    private boolean parseBoolean(String enabled) {
        return Boolean.parseBoolean(enabled);
    }

    public ConnectorDescriptor getConnectorDescriptorFromUri(String rarName, String raLoc) {
        try {
            String appName = rarName.substring(0, rarName.indexOf("#"));
            String appDeployLocation = ResourcesUtil.createInstance().getApplicationDeployLocation(appName);
            FileArchive in = ConnectorRuntime.getRuntime().getFileArchive();
            in.open(new URI(appDeployLocation));
            ApplicationArchivist archivist = ConnectorRuntime.getRuntime().getApplicationArchivist();
            Application application = archivist.open((ReadableArchive)in);
            return application.getRarDescriptorByUri(raLoc);
        }
        catch (Exception e) {
            Object[] params = new Object[]{rarName, e};
            _logger.log(Level.WARNING, "error.getting.connector.descriptor", params);
            return null;
        }
    }

    public boolean isPoolReferredInServerInstance(PoolInfo poolInfo) {
        Collection connectorResources = this.getRuntime().getResources(poolInfo).getResources(ConnectorResource.class);
        for (ConnectorResource resource : connectorResources) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("poolname " + resource.getPoolName() + "resource " + resource.getJndiName());
            }
            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)resource);
            if (!resource.getPoolName().equalsIgnoreCase(poolInfo.getName()) || !this.isReferenced(resourceInfo)) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Connector resource " + resource.getJndiName() + "refers " + poolInfo + "in this server instance");
            }
            return true;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("No Connector resource refers [ " + poolInfo + " ] in this server instance");
        }
        return false;
    }

    public boolean isJdbcPoolReferredInServerInstance(PoolInfo poolInfo) {
        Collection jdbcResources = this.getRuntime().getResources(poolInfo).getResources(JdbcResource.class);
        for (JdbcResource resource : jdbcResources) {
            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)resource);
            if (!resource.getPoolName().equalsIgnoreCase(poolInfo.getName()) || !this.isReferenced(resourceInfo)) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("pool " + poolInfo + "resource " + resourceInfo + " referred " + this.isReferenced(resourceInfo));
                _logger.fine("JDBC resource " + resource.getJndiName() + "refers " + poolInfo + "in this server instance");
            }
            return true;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("No JDBC resource refers [ " + poolInfo + " ] in this server instance");
        }
        return false;
    }

    public JdbcConnectionPool getJdbcConnectionPoolOfResource(ResourceInfo resourceInfo) {
        JdbcResource resource = null;
        JdbcConnectionPool pool = null;
        Resources resources = this.getResources(resourceInfo);
        if (resources != null && (resource = (JdbcResource)resources.getResourceByName(JdbcResource.class, resourceInfo.getName())) != null) {
            pool = (JdbcConnectionPool)resources.getResourceByName(JdbcConnectionPool.class, resource.getPoolName());
        }
        return pool;
    }

    public ResourcePool getPoolConfig(PoolInfo poolInfo) {
        Resources resources = this.getResources(poolInfo);
        ResourcePool pool = null;
        if (resources != null) {
            pool = (ResourcePool)resources.getResourceByName(ResourcePool.class, poolInfo.getName());
        }
        return pool;
    }

    public ConnectorConnectionPool getConnectorConnectionPoolOfResource(ResourceInfo resourceInfo) {
        ConnectorResource resource = null;
        ConnectorConnectionPool pool = null;
        Resources resources = this.getResources(resourceInfo);
        if (resources != null && (resource = (ConnectorResource)resources.getResourceByName(ConnectorResource.class, resourceInfo.getName())) != null) {
            pool = (ConnectorConnectionPool)resources.getResourceByName(ConnectorConnectionPool.class, resource.getPoolName());
        }
        return pool;
    }

    public boolean isRARResource(Resource resource) {
        return resource instanceof ConnectorResource || resource instanceof AdminObjectResource || resource instanceof ConnectorConnectionPool || resource instanceof ResourceAdapterConfig || resource instanceof WorkSecurityMap;
    }

    public String getRarNameOfResource(Resource resource, Resources resources) {
        String rarName = null;
        if (this.isRARResource(resource)) {
            if (resource instanceof ConnectorResource) {
                String poolName = ((ConnectorResource)resource).getPoolName();
                for (Resource res : resources.getResources()) {
                    ConnectorConnectionPool ccp;
                    if (!(res instanceof ConnectorConnectionPool) || !(ccp = (ConnectorConnectionPool)res).getName().equals(poolName)) continue;
                    return ccp.getResourceAdapterName();
                }
            } else {
                if (resource instanceof ConnectorConnectionPool) {
                    ConnectorConnectionPool ccp = (ConnectorConnectionPool)resource;
                    return ccp.getResourceAdapterName();
                }
                if (resource instanceof AdminObjectResource) {
                    AdminObjectResource aor = (AdminObjectResource)resource;
                    return aor.getResAdapter();
                }
                if (resource instanceof ResourceAdapterConfig) {
                    ResourceAdapterConfig rac = (ResourceAdapterConfig)resource;
                    return rac.getResourceAdapterName();
                }
                if (resource instanceof WorkSecurityMap) {
                    WorkSecurityMap wsm = (WorkSecurityMap)resource;
                    return wsm.getResourceAdapterName();
                }
            }
        }
        return rarName;
    }

    public Resource getResource(ResourceInfo resourceInfo, Class resourceType) {
        Resource resource = null;
        String appName = resourceInfo.getApplicationName();
        String jndiName = resourceInfo.getName();
        String moduleName = resourceInfo.getModuleName();
        Resources resources = null;
        if (ConnectorsUtil.isApplicationScopedResource((GenericResourceInfo)resourceInfo) || ConnectorsUtil.isModuleScopedResource((GenericResourceInfo)resourceInfo)) {
            if (this.getApplicationByName(appName) != null) {
                resources = this.getResources(resourceInfo);
            }
        } else {
            resources = this.getResources(resourceInfo);
        }
        if (resources != null) {
            resource = resources.getResourceByName(resourceType, jndiName);
        } else if (ConnectorsUtil.isApplicationScopedResource((GenericResourceInfo)resourceInfo) || ConnectorsUtil.isModuleScopedResource((GenericResourceInfo)resourceInfo)) {
            if (ConnectorsUtil.isApplicationScopedResource((GenericResourceInfo)resourceInfo)) {
                moduleName = appName;
            }
            if ((resources = ResourcesDeployer.getResources(appName, moduleName)) != null) {
                resource = resources.getResourceByName(resourceType, jndiName);
            }
        }
        return resource;
    }

    public Resource getResource(String jndiName, String appName, String moduleName, Class resourceType) {
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, appName, moduleName);
        return this.getResource(resourceInfo, resourceType);
    }
}

