/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ResourceAdapterConfigDeployer
implements ResourceDeployer {
    private static Logger _logger = LogDomains.getLogger(ResourceAdapterConfigDeployer.class, (String)"javax.enterprise.resource.resourceadapter");

    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void deployResource(Object resource) throws Exception {
        ResourceAdapterConfig domainConfig = (ResourceAdapterConfig)resource;
        String rarName = domainConfig.getResourceAdapterName();
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Calling backend to add resource adapterConfig ", rarName);
        }
        crt.addResourceAdapterConfig(rarName, domainConfig);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Added resource adapterConfig in backend", rarName);
        }
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        this.undeployResource(resource);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        ResourceAdapterConfig domainConfig = (ResourceAdapterConfig)resource;
        String rarName = domainConfig.getResourceAdapterName();
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        crt.deleteResourceAdapterConfig(rarName);
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        boolean canHandle = false;
        if (resource instanceof ResourceAdapterConfig) {
            canHandle = true;
        }
        return canHandle;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public synchronized void disableResource(Object resource) throws Exception {
    }

    public synchronized void enableResource(Object resource) throws Exception {
    }
}

