/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.ResourceNamingService;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.glassfish.javaee.services.DataSourceDefinitionProxy;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DataSourceDefinitionDeployer
implements ResourceDeployer {
    @Inject
    private Habitat habitat;
    private static Logger _logger = LogDomains.getLogger(DataSourceDefinitionDeployer.class, (String)"javax.enterprise.resource.resourceadapter");

    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    public void deployResource(Object resource) throws Exception {
        DataSourceDefinitionDescriptor desc = (DataSourceDefinitionDescriptor)resource;
        String poolName = ConnectorsUtil.deriveDataSourceDefinitionPoolName((String)desc.getResourceId(), (String)desc.getName());
        String resourceName = ConnectorsUtil.deriveDataSourceDefinitionResourceName((String)desc.getResourceId(), (String)desc.getName());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "DataSourceDefinitionDeployer.deployResource() : pool-name [" + poolName + "], " + " resource-name [" + resourceName + "]");
        }
        MyJdbcConnectionPool jdbcCp = new MyJdbcConnectionPool(desc, poolName);
        Collection deployers = this.habitat.getAllByContract(ResourceDeployer.class);
        this.getDeployer(jdbcCp, deployers).deployResource((Object)jdbcCp);
        MyJdbcResource jdbcResource = new MyJdbcResource(poolName, resourceName);
        this.getDeployer(jdbcResource, deployers).deployResource((Object)jdbcResource);
    }

    private ResourceDeployer getDeployer(Object resource, Collection<ResourceDeployer> deployers) {
        ResourceDeployer resourceDeployer = null;
        for (ResourceDeployer deployer : deployers) {
            if (!deployer.handles(resource)) continue;
            resourceDeployer = deployer;
            break;
        }
        return resourceDeployer;
    }

    private DataSourceProperty convertProperty(String name, String value) {
        return new DataSourceProperty(name, value);
    }

    public void registerDataSourceDefinitions(Application application) {
        Set bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle : bundles) {
            if (bundle instanceof JndiNameEnvironment) {
                JndiNameEnvironment env = (JndiNameEnvironment)bundle;
                for (DataSourceDefinitionDescriptor dsd : env.getDataSourceDefinitionDescriptors()) {
                    this.deployDataSourceDefinition(application, dsd);
                }
            }
            if (bundle instanceof EjbBundleDescriptor) {
                EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)bundle;
                Set ejbDescriptors = ejbDesc.getEjbs();
                for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                    for (DataSourceDefinitionDescriptor dsd : ejbDescriptor.getDataSourceDefinitionDescriptors()) {
                        this.deployDataSourceDefinition(application, dsd);
                    }
                }
                Set ejbInterceptors = ejbDesc.getInterceptors();
                for (EjbInterceptor ejbInterceptor : ejbInterceptors) {
                    for (DataSourceDefinitionDescriptor dsd : ejbInterceptor.getDataSourceDefinitionDescriptors()) {
                        this.deployDataSourceDefinition(application, dsd);
                    }
                }
            }
            Set managedBeanDescriptors = bundle.getManagedBeans();
            for (ManagedBeanDescriptor mbd : managedBeanDescriptors) {
                for (DataSourceDefinitionDescriptor dsd : mbd.getDataSourceDefinitionDescriptors()) {
                    this.deployDataSourceDefinition(application, dsd);
                }
            }
        }
    }

    private void deployDataSourceDefinition(Application application, DataSourceDefinitionDescriptor dsd) {
        if (!dsd.isDeployed()) {
            DataSourceDefinitionProxy proxy = (DataSourceDefinitionProxy)this.habitat.getComponent(DataSourceDefinitionProxy.class);
            ResourceNamingService resourceNamingService = (ResourceNamingService)this.habitat.getComponent(ResourceNamingService.class);
            proxy.setDescriptor(dsd);
            String appName = application.getAppName();
            String moduleName = null;
            if (dsd.getName().startsWith("java:app/")) {
                dsd.setResourceId(appName);
            }
            if (dsd.getName().startsWith("java:global/") || dsd.getName().startsWith("java:app/")) {
                ResourceInfo resourceInfo = new ResourceInfo(dsd.getName(), appName, moduleName);
                try {
                    resourceNamingService.publishObject(resourceInfo, (Object)proxy, true);
                    dsd.setDeployed(true);
                }
                catch (NamingException e) {
                    Object[] params = new Object[]{appName, dsd.getName(), e};
                    _logger.log(Level.WARNING, "dsd.registration.failed", params);
                }
            }
        }
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    public void undeployResource(Object resource) throws Exception {
        DataSourceDefinitionDescriptor desc = (DataSourceDefinitionDescriptor)resource;
        Collection deployers = this.habitat.getAllByContract(ResourceDeployer.class);
        String poolName = ConnectorsUtil.deriveDataSourceDefinitionPoolName((String)desc.getResourceId(), (String)desc.getName());
        String resourceName = ConnectorsUtil.deriveDataSourceDefinitionResourceName((String)desc.getResourceId(), (String)desc.getName());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "DataSourceDefinitionDeployer.undeployResource() : pool-name [" + poolName + "], " + " resource-name [" + resourceName + "]");
        }
        MyJdbcResource jdbcResource = new MyJdbcResource(poolName, resourceName);
        this.getDeployer(jdbcResource, deployers).undeployResource((Object)jdbcResource);
        MyJdbcConnectionPool jdbcCp = new MyJdbcConnectionPool(desc, poolName);
        this.getDeployer(jdbcCp, deployers).undeployResource((Object)jdbcCp);
    }

    public void redeployResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("redeploy() not supported for datasource-definition type");
    }

    public void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for datasource-definition type");
    }

    public void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for datasource-definition type");
    }

    public boolean handles(Object resource) {
        return resource instanceof DataSourceDefinitionDescriptor;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyJdbcConnectionPool
    extends FakeConfigBean
    implements JdbcConnectionPool {
        private DataSourceDefinitionDescriptor desc;
        private String name;

        public MyJdbcConnectionPool(DataSourceDefinitionDescriptor desc, String name) {
            this.desc = desc;
            this.name = name;
        }

        public String getDatasourceClassname() {
            if (!this.getResType().equals("java.sql.Driver")) {
                return this.desc.getClassName();
            }
            return null;
        }

        public void setDatasourceClassname(String value) throws PropertyVetoException {
        }

        public String getResType() {
            String type;
            block9: {
                type = "javax.sql.DataSource";
                try {
                    Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(this.desc.getClassName());
                    if (XADataSource.class.isAssignableFrom(clz)) {
                        type = "javax.sql.XADataSource";
                    } else if (ConnectionPoolDataSource.class.isAssignableFrom(clz)) {
                        type = "javax.sql.ConnectionPoolDataSource";
                    } else if (DataSource.class.isAssignableFrom(clz)) {
                        type = "javax.sql.DataSource";
                    } else if (Driver.class.isAssignableFrom(clz)) {
                        type = "java.sql.Driver";
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!_logger.isLoggable(Level.FINEST)) break block9;
                    _logger.log(Level.FINEST, "Unable to load class [ " + this.desc.getClassName() + " ] to " + "determine its res-type, defaulting to [" + "javax.sql.DataSource" + "]");
                }
            }
            return type;
        }

        public void setResType(String value) throws PropertyVetoException {
        }

        public String getObjectType() {
            return null;
        }

        public void setObjectType(String value) throws PropertyVetoException {
        }

        public String getSteadyPoolSize() {
            int minPoolSize = this.desc.getMinPoolSize();
            if (minPoolSize == -1) {
                minPoolSize = 8;
            }
            return String.valueOf(minPoolSize);
        }

        public void setSteadyPoolSize(String value) throws PropertyVetoException {
        }

        public String getMaxPoolSize() {
            int maxPoolSize = this.desc.getMaxPoolSize();
            if (maxPoolSize == -1) {
                maxPoolSize = 32;
            }
            return String.valueOf(maxPoolSize);
        }

        public void setMaxPoolSize(String value) throws PropertyVetoException {
        }

        public String getMaxWaitTimeInMillis() {
            return String.valueOf(60000);
        }

        public void setMaxWaitTimeInMillis(String value) throws PropertyVetoException {
        }

        public String getPoolResizeQuantity() {
            return String.valueOf(2);
        }

        public void setPoolResizeQuantity(String value) throws PropertyVetoException {
        }

        public String getIdleTimeoutInSeconds() {
            long maxIdleTime = this.desc.getMaxIdleTime();
            if (maxIdleTime == -1L) {
                maxIdleTime = 300L;
            }
            return String.valueOf(maxIdleTime);
        }

        public void setIdleTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        public String getTransactionIsolationLevel() {
            if (this.desc.getIsolationLevel() == -1) {
                return null;
            }
            return ConnectorsUtil.getTransactionIsolationInt((int)this.desc.getIsolationLevel());
        }

        public void setTransactionIsolationLevel(String value) throws PropertyVetoException {
        }

        public String getIsIsolationLevelGuaranteed() {
            return String.valueOf("true");
        }

        public void setIsIsolationLevelGuaranteed(String value) throws PropertyVetoException {
        }

        public String getIsConnectionValidationRequired() {
            return String.valueOf("false");
        }

        public void setIsConnectionValidationRequired(String value) throws PropertyVetoException {
        }

        public String getConnectionValidationMethod() {
            return null;
        }

        public void setConnectionValidationMethod(String value) throws PropertyVetoException {
        }

        public String getValidationTableName() {
            return null;
        }

        public void setValidationTableName(String value) throws PropertyVetoException {
        }

        public String getValidationClassname() {
            return null;
        }

        public void setValidationClassname(String value) throws PropertyVetoException {
        }

        public String getFailAllConnections() {
            return String.valueOf("false");
        }

        public void setFailAllConnections(String value) throws PropertyVetoException {
        }

        public String getNonTransactionalConnections() {
            return String.valueOf(!this.desc.isTransactional());
        }

        public void setNonTransactionalConnections(String value) throws PropertyVetoException {
        }

        public String getAllowNonComponentCallers() {
            return String.valueOf("false");
        }

        public void setAllowNonComponentCallers(String value) throws PropertyVetoException {
        }

        public String getValidateAtmostOncePeriodInSeconds() {
            return String.valueOf(0);
        }

        public void setValidateAtmostOncePeriodInSeconds(String value) throws PropertyVetoException {
        }

        public String getConnectionLeakTimeoutInSeconds() {
            return String.valueOf(0);
        }

        public void setConnectionLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        public String getConnectionLeakReclaim() {
            return String.valueOf(false);
        }

        public void setConnectionLeakReclaim(String value) throws PropertyVetoException {
        }

        public String getConnectionCreationRetryAttempts() {
            return String.valueOf(0);
        }

        public void setConnectionCreationRetryAttempts(String value) throws PropertyVetoException {
        }

        public String getConnectionCreationRetryIntervalInSeconds() {
            return String.valueOf(10);
        }

        public void setConnectionCreationRetryIntervalInSeconds(String value) throws PropertyVetoException {
        }

        public String getStatementTimeoutInSeconds() {
            return String.valueOf(-1);
        }

        public void setStatementTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        public String getLazyConnectionEnlistment() {
            return String.valueOf(false);
        }

        public void setLazyConnectionEnlistment(String value) throws PropertyVetoException {
        }

        public String getLazyConnectionAssociation() {
            return String.valueOf(false);
        }

        public void setLazyConnectionAssociation(String value) throws PropertyVetoException {
        }

        public String getAssociateWithThread() {
            return String.valueOf(false);
        }

        public void setAssociateWithThread(String value) throws PropertyVetoException {
        }

        public String getPooling() {
            return String.valueOf(true);
        }

        public void setPooling(String value) throws PropertyVetoException {
        }

        public String getStatementCacheSize() {
            return String.valueOf(0);
        }

        public void setStatementCacheSize(String value) throws PropertyVetoException {
        }

        public String getMatchConnections() {
            return String.valueOf(true);
        }

        public void setMatchConnections(String value) throws PropertyVetoException {
        }

        public String getMaxConnectionUsageCount() {
            return String.valueOf(0);
        }

        public void setMaxConnectionUsageCount(String value) throws PropertyVetoException {
        }

        public String getWrapJdbcObjects() {
            return String.valueOf(true);
        }

        public void setWrapJdbcObjects(String value) throws PropertyVetoException {
        }

        public String getDescription() {
            return this.desc.getDescription();
        }

        public void setDescription(String value) throws PropertyVetoException {
        }

        public List<Property> getProperty() {
            DataSourceProperty property;
            Properties p = this.desc.getProperties();
            ArrayList<Property> dataSourceProperties = new ArrayList<Property>();
            for (Object o : p.keySet()) {
                String key = (String)o;
                String value = (String)p.get(o);
                DataSourceProperty dp = DataSourceDefinitionDeployer.this.convertProperty(key, value);
                dataSourceProperties.add(dp);
            }
            if (this.desc.getUser() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("user", String.valueOf(this.desc.getUser()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getPassword() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("password", String.valueOf(this.desc.getPassword()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getDatabaseName() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("databaseName", String.valueOf(this.desc.getDatabaseName()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getServerName() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("serverName", String.valueOf(this.desc.getServerName()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getPortNumber() != -1) {
                property = DataSourceDefinitionDeployer.this.convertProperty("portNumber", String.valueOf(this.desc.getPortNumber()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getUrl() != null && !this.isStandardPropertiesSet(this.desc)) {
                property = DataSourceDefinitionDeployer.this.convertProperty("url", String.valueOf(this.desc.getUrl()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getLoginTimeout() != 0L) {
                property = DataSourceDefinitionDeployer.this.convertProperty("loginTimeout", String.valueOf(this.desc.getLoginTimeout()));
                dataSourceProperties.add(property);
            }
            if (this.desc.getMaxStatements() != -1) {
                property = DataSourceDefinitionDeployer.this.convertProperty("maxStatements", String.valueOf(this.desc.getMaxStatements()));
                dataSourceProperties.add(property);
            }
            return dataSourceProperties;
        }

        private boolean isStandardPropertiesSet(DataSourceDefinitionDescriptor desc) {
            boolean result = false;
            if (desc.getServerName() != null && desc.getDatabaseName() != null && desc.getPortNumber() != -1) {
                result = true;
            }
            return result;
        }

        public Property getProperty(String name) {
            String value = (String)this.desc.getProperties().get(name);
            return new DataSourceProperty(name, value);
        }

        public String getPropertyValue(String name) {
            return (String)this.desc.getProperties().get(name);
        }

        public String getPropertyValue(String name, String defaultValue) {
            String value = null;
            value = (String)this.desc.getProperties().get(name);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        public void injectedInto(Object o) {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) throws PropertyVetoException {
        }

        public String getSqlTraceListeners() {
            return null;
        }

        public void setSqlTraceListeners(String value) throws PropertyVetoException {
        }

        public String getPing() {
            return String.valueOf(false);
        }

        public void setPing(String value) throws PropertyVetoException {
        }

        public String getInitSql() {
            return null;
        }

        public void setInitSql(String value) throws PropertyVetoException {
        }

        public String getDriverClassname() {
            if (this.getResType().equals("java.sql.Driver")) {
                return this.desc.getClassName();
            }
            return null;
        }

        public void setDriverClassname(String value) throws PropertyVetoException {
        }

        public String getStatementLeakTimeoutInSeconds() {
            return String.valueOf(0);
        }

        public void setStatementLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        public String getStatementLeakReclaim() {
            return String.valueOf(false);
        }

        public void setStatementLeakReclaim(String value) throws PropertyVetoException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyJdbcResource
    extends FakeConfigBean
    implements JdbcResource {
        private String poolName;
        private String jndiName;

        MyJdbcResource(String poolName, String jndiName) {
            this.poolName = poolName;
            this.jndiName = jndiName;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public void setPoolName(String value) throws PropertyVetoException {
            this.poolName = value;
        }

        public String getObjectType() {
            return null;
        }

        public void setObjectType(String value) throws PropertyVetoException {
        }

        public String getEnabled() {
            return String.valueOf(true);
        }

        public void setEnabled(String value) throws PropertyVetoException {
        }

        public String getDescription() {
            return null;
        }

        public void setDescription(String value) throws PropertyVetoException {
        }

        public List<Property> getProperty() {
            return null;
        }

        public Property getProperty(String name) {
            return null;
        }

        public String getPropertyValue(String name) {
            return null;
        }

        public String getPropertyValue(String name, String defaultValue) {
            return null;
        }

        public void injectedInto(Object o) {
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public void setJndiName(String value) throws PropertyVetoException {
            this.jndiName = value;
        }
    }

    class DataSourceProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        DataSourceProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean() {
        }

        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        public ConfigBeanProxy getParent() {
            return null;
        }

        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }
}

