/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.admin.cli.resources.ResourceUtil;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="external-jndi-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.jndi.resource")
public class JndiResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JndiResourceManager.class);
    private static final String DESCRIPTION = "description";
    @Inject
    private ResourceUtil resourceUtil;
    private String resType;
    private String factoryClass;
    private String jndiLookupName;
    private String enabled;
    private String enabledValueForTarget = null;
    private String description;
    private String jndiName;

    public String getResourceType() {
        return "external-jndi-resource";
    }

    public ResourceStatus create(Resources resources, HashMap attributes, final Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    return JndiResourceManager.this.createResource(param, properties);
                }
            }, (ConfigBeanProxy)resources);
            this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.jndi.resource.fail", "Unable to create jndi resource {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg, true);
        }
        String msg = localStrings.getLocalString("create.jndi.resource.success", "jndi resource {0} created.", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg, true);
    }

    private ResourceStatus isValid(Resources resources) {
        ResourceStatus status = new ResourceStatus(0, "Validation Successful");
        if (this.resType == null) {
            String msg = localStrings.getLocalString("create.jndi.resource.noResType", "No type defined for JNDI resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.factoryClass == null) {
            String msg = localStrings.getLocalString("create.jndi.resource.noFactoryClassName", "No Factory class name defined for JNDI resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.jndiLookupName == null) {
            String msg = localStrings.getLocalString("create.jndi.resource.noJndiLookupName", "No Jndi Lookup name defined for JNDI resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (resources.getResourceByName(BindableResource.class, this.jndiName) != null) {
            String msg = localStrings.getLocalString("create.jndi.resource.duplicate", "A JNDI resource named {0} already exists.", new Object[]{this.jndiName});
            return new ResourceStatus(1, msg, true);
        }
        return status;
    }

    private void setAttributes(HashMap attributes, String target) {
        this.jndiName = (String)attributes.get("jndi-name");
        this.jndiLookupName = (String)attributes.get("jndi-lookup-name");
        this.resType = (String)attributes.get("res-type");
        this.factoryClass = (String)attributes.get("factory-class");
        this.enabled = target != null ? this.resourceUtil.computeEnabledValueForResourceBasedOnTarget((String)attributes.get("enabled"), target) : (String)attributes.get("enabled");
        this.enabledValueForTarget = (String)attributes.get("enabled");
        this.description = (String)attributes.get(DESCRIPTION);
    }

    private Object createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ExternalJndiResource newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private ExternalJndiResource createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ExternalJndiResource newResource = (ExternalJndiResource)param.createChild(ExternalJndiResource.class);
        newResource.setJndiName(this.jndiName);
        newResource.setFactoryClass(this.factoryClass);
        newResource.setJndiLookupName(this.jndiLookupName);
        newResource.setResType(this.resType);
        newResource.setEnabled(this.enabled);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = null;
        status = !validate ? new ResourceStatus(0, "") : this.isValid(resources);
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage());
    }
}

