/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-connector-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="delete.connector.connection.pool")
public class DeleteConnectorConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteConnectorConnectionPool.class);
    @Param(optional=true, obsolete=true)
    private String target = "server";
    @Param(optional=true, defaultValue="false")
    private Boolean cascade;
    @Param(name="poolname", primary=true)
    private String poolname;
    @Inject
    private Domain domain;
    @Inject
    private Server[] servers;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.poolname == null) {
            report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.noJndiName", "No id defined for connector connection pool."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.domain.getResources().getResourceByName(ConnectorConnectionPool.class, this.poolname) == null) {
            report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.notfound", "A connector connection pool named {0} does not exist.", new Object[]{this.poolname}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            Object obj = this.deleteAssociatedResources(this.servers, this.domain.getResources(), this.cascade, this.poolname);
            if (obj instanceof Integer && (Integer)obj == 1) {
                report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.pool_in_use", "Some connector resources are referencing connection pool {0}. Use 'cascade' option to delete them as well.", new Object[]{this.poolname}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    ConnectorConnectionPool cp = (ConnectorConnectionPool)DeleteConnectorConnectionPool.this.domain.getResources().getResourceByName(ConnectorConnectionPool.class, DeleteConnectorConnectionPool.this.poolname);
                    if (cp != null) {
                        return param.getResources().remove(cp);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)this.domain.getResources()) == null) {
                report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.notfound", "A connector connection pool named {0} does not exist.", new Object[]{this.poolname}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        catch (TransactionFailure tfe) {
            Logger.getLogger(DeleteConnectorConnectionPool.class.getName()).log(Level.SEVERE, "Something went wrong in delete-connector-connection-pool", tfe);
            report.setMessage(tfe.getMessage() != null ? tfe.getLocalizedMessage() : localStrings.getLocalString("delete.connector.connection.pool.fail", "Connector connection pool {0} delete failed ", new Object[]{this.poolname}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.success", "Connector connection pool {0} deleted successfully", new Object[]{this.poolname}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private Object deleteAssociatedResources(final Server[] servers, Resources resources, boolean cascade, final String poolName) throws TransactionFailure {
        if (cascade) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    Collection referringResources = param.getResourcesOfPool(poolName);
                    for (BindableResource referringResource : referringResources) {
                        DeleteConnectorConnectionPool.this.deleteResourceRefs(servers, referringResource.getJndiName());
                        param.getResources().remove(referringResource);
                    }
                    return true;
                }
            }, (ConfigBeanProxy)resources);
        } else {
            Collection referringResources = resources.getResourcesOfPool(poolName);
            if (referringResources.size() > 0) {
                return 1;
            }
        }
        return true;
    }

    private void deleteResourceRefs(Server[] servers, String refName) throws TransactionFailure {
        for (Server server : servers) {
            server.deleteResourceRef(refName);
        }
    }
}

