/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsClassLoaderUtil;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.ResourceNamingService;
import com.sun.appserv.connectors.internal.api.WorkContextHandler;
import com.sun.appserv.connectors.internal.api.WorkManagerFactory;
import com.sun.appserv.connectors.internal.spi.ConnectorNamingEventListener;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.connectors.ActiveRAFactory;
import com.sun.enterprise.connectors.ConnectionManagerFactory;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.XATerminatorProxy;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.connectors.naming.ConnectorNamingEventNotifier;
import com.sun.enterprise.connectors.service.ConnectorAdminObjectAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorAdminServicesFactory;
import com.sun.enterprise.connectors.service.ConnectorConfigurationParserServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorConnectionPoolAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorResourceAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorSecurityAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.service.JdbcAdminServiceImpl;
import com.sun.enterprise.connectors.service.ResourceAdapterAdminServiceImpl;
import com.sun.enterprise.connectors.util.ConnectorJavaBeanValidator;
import com.sun.enterprise.connectors.util.ConnectorTimerProxy;
import com.sun.enterprise.connectors.util.DriverLoader;
import com.sun.enterprise.connectors.util.RAWriterAdapter;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.ConnectorArchivist;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.resource.deployer.DataSourceDefinitionDeployer;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolProbeProviderUtil;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.jmac.callback.ContainerCallbackHandler;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.security.auth.callback.CallbackHandler;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.glassfish.admin.monitor.MonitoringBootstrap;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassLoaderService;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.resource.common.GenericResourceInfo;
import org.glassfish.resource.common.PoolInfo;
import org.glassfish.resource.common.ResourceInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ConnectorRuntime
implements com.sun.appserv.connectors.internal.api.ConnectorRuntime,
PostConstruct,
PreDestroy {
    private static ConnectorRuntime _runtime;
    private Logger _logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"javax.enterprise.resource.resourceadapter");
    private ConnectorConnectionPoolAdminServiceImpl ccPoolAdmService;
    private ConnectorResourceAdminServiceImpl connectorResourceAdmService;
    private ConnectorService connectorService;
    private ConnectorConfigurationParserServiceImpl configParserAdmService;
    private ResourceAdapterAdminServiceImpl resourceAdapterAdmService;
    private ConnectorSecurityAdminServiceImpl connectorSecurityAdmService;
    private ConnectorAdminObjectAdminServiceImpl adminObjectAdminService;
    private ConnectorRegistry connectorRegistry = ConnectorRegistry.getInstance();
    private JdbcAdminServiceImpl jdbcAdminService;
    @Inject
    private GlassfishNamingManager namingManager;
    @Inject
    private PoolManager poolManager;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private ComponentEnvManager componentEnvManager;
    @Inject
    private Habitat wmf;
    @Inject
    private Habitat allResources;
    @Inject
    private Habitat deployerHabitat;
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    private ConnectorsClassLoaderUtil cclUtil;
    @Inject
    private ActiveRAFactory activeRAFactory;
    @Inject
    private Habitat applications;
    @Inject
    private Habitat habitat;
    @Inject
    private ProcessEnvironment processEnvironment;
    @Inject
    private DriverLoader driverLoader;
    @Inject
    private ConnectorJavaBeanValidator connectorBeanValidator;
    @Inject
    private ConnectorClassLoaderService connectorClassLoaderService;
    @Inject
    private ServerEnvironmentImpl env;
    @Inject
    private ResourceNamingService resourceNamingService;
    private Resources globalResources;
    private JavaEETransactionManager transactionManager;
    private ProcessEnvironment.ProcessType processType;

    public static ConnectorRuntime getRuntime() {
        if (_runtime == null) {
            throw new RuntimeException("Connector Runtime not initialized");
        }
        return _runtime;
    }

    public ConnectorRuntime() {
        _runtime = this;
    }

    public ConnectionPoolProbeProviderUtil getProbeProviderUtil() {
        return (ConnectionPoolProbeProviderUtil)this.habitat.getComponent(ConnectionPoolProbeProviderUtil.class);
    }

    public ResourceNamingService getResourceNamingService() {
        return this.resourceNamingService;
    }

    public ProcessEnvironment.ProcessType getEnvironment() {
        return this.processType;
    }

    public MonitoringBootstrap getMonitoringBootstrap() {
        return (MonitoringBootstrap)this.habitat.getComponent(MonitoringBootstrap.class);
    }

    public String getDefaultPoolName(String moduleName, String connectionDefName) {
        return this.connectorService.getDefaultPoolName(moduleName, connectionDefName);
    }

    public void deleteConnectorConnectionPool(PoolInfo poolInfo) throws ConnectorRuntimeException {
        this.ccPoolAdmService.deleteConnectorConnectionPool(poolInfo);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj) throws ConnectorRuntimeException {
        this.ccPoolAdmService.createConnectorConnectionPool(connectorPoolObj);
    }

    public void createConnectorResource(ResourceInfo resourceInfo, PoolInfo poolInfo, String resourceType) throws ConnectorRuntimeException {
        this.connectorResourceAdmService.createConnectorResource(resourceInfo, poolInfo, resourceType);
    }

    public String getDefaultResourceName(String moduleName, String connectionDefName) {
        return this.connectorService.getDefaultResourceName(moduleName, connectionDefName);
    }

    public PrintWriter getResourceAdapterLogWriter() {
        Logger logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"javax.enterprise.resource.resourceadapter");
        RAWriterAdapter writerAdapter = new RAWriterAdapter(logger);
        return new PrintWriter(writerAdapter);
    }

    public void deleteConnectorResource(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        this.connectorResourceAdmService.deleteConnectorResource(resourceInfo);
    }

    public ConnectorDescriptor getConnectorDescriptor(String rarName) throws ConnectorRuntimeException {
        return this.connectorService.getConnectorDescriptor(rarName);
    }

    public void createActiveResourceAdapter(String moduleDir, String moduleName, ClassLoader loader) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.createActiveResourceAdapter(moduleDir, moduleName, loader);
    }

    public void createActiveResourceAdapter(ConnectorDescriptor connectorDescriptor, String moduleName, String moduleDir, ClassLoader loader) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.createActiveResourceAdapter(connectorDescriptor, moduleName, moduleDir, loader);
    }

    public void createActiveResourceAdapter(ConnectorDescriptor connectorDescriptor, String moduleName, String moduleDir) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.createActiveResourceAdapter(connectorDescriptor, moduleName, moduleDir, null);
    }

    public void destroyActiveResourceAdapter(String moduleName) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.stopActiveResourceAdapter(moduleName);
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(PoolInfo poolInfo) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.obtainManagedConnectionFactory(poolInfo);
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(PoolInfo poolInfo, Hashtable env) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.obtainManagedConnectionFactory(poolInfo, env);
    }

    public ManagedConnectionFactory[] obtainManagedConnectionFactories(PoolInfo poolInfo) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.obtainManagedConnectionFactories(poolInfo);
    }

    public ConnectionManager obtainConnectionManager(PoolInfo poolInfo, boolean forceNoLazyAssoc, ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        ConnectionManager mgr = ConnectionManagerFactory.getAvailableConnectionManager(poolInfo, forceNoLazyAssoc, resourceInfo);
        return mgr;
    }

    public Object lookupPMResource(ResourceInfo resourceInfo, boolean force) throws NamingException {
        Object result;
        try {
            if (!resourceInfo.getName().endsWith("__pm")) {
                ResourceInfo tmpInfo;
                resourceInfo = tmpInfo = new ResourceInfo(resourceInfo.getName() + "__pm", resourceInfo.getApplicationName(), resourceInfo.getModuleName());
            }
            result = this.connectorResourceAdmService.lookup(resourceInfo);
        }
        catch (NamingException ne) {
            if (force && this.isDAS()) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "jdbc.unable_to_lookup_resource", new Object[]{resourceInfo});
                }
                result = this.lookupDataSourceInDAS(resourceInfo);
            }
            throw ne;
        }
        return result;
    }

    public Object lookupPMResource(String jndiName, boolean force) throws NamingException {
        ResourceInfo resourceInfo = new ResourceInfo(jndiName);
        return this.lookupPMResource(resourceInfo, force);
    }

    public Object lookupNonTxResource(String jndiName, boolean force) throws NamingException {
        ResourceInfo resourceInfo = new ResourceInfo(jndiName);
        return this.lookupNonTxResource(resourceInfo, force);
    }

    public Object lookupNonTxResource(ResourceInfo resourceInfo, boolean force) throws NamingException {
        Object result;
        try {
            if (!resourceInfo.getName().endsWith("__nontx")) {
                ResourceInfo tmpInfo;
                resourceInfo = tmpInfo = new ResourceInfo(resourceInfo.getName() + "__nontx", resourceInfo.getApplicationName(), resourceInfo.getModuleName());
            }
            result = this.connectorResourceAdmService.lookup(resourceInfo);
        }
        catch (NamingException ne) {
            if (force && this.isDAS()) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "jdbc.unable_to_lookup_resource", new Object[]{resourceInfo});
                }
                result = this.lookupDataSourceInDAS(resourceInfo);
            }
            throw ne;
        }
        return result;
    }

    private boolean isDAS() {
        return this.env.isDas();
    }

    private Object lookupDataSourceInDAS(ResourceInfo resourceInfo) {
        try {
            return this.connectorResourceAdmService.lookupDataSourceInDAS(resourceInfo);
        }
        catch (ConnectorRuntimeException cre) {
            throw new RuntimeException(cre.getMessage(), cre);
        }
    }

    public Connection getConnection(ResourceInfo resourceInfo, String user, String password) throws SQLException {
        return this.ccPoolAdmService.getConnection(resourceInfo, user, password);
    }

    public Connection getConnection(ResourceInfo resourceInfo) throws SQLException {
        return this.ccPoolAdmService.getConnection(resourceInfo);
    }

    public Map<String, Object> getConnectionDefinitionPropertiesAndDefaults(String connectionDefinitionClassName, String resType) {
        return ConnectorConnectionPoolAdminServiceImpl.getConnectionDefinitionPropertiesAndDefaults(connectionDefinitionClassName, resType);
    }

    public Map<String, String> getBuiltInCustomResources() {
        return ConnectorsUtil.getBuiltInCustomResources();
    }

    public String[] getSystemConnectorsAllowingPoolCreation() {
        String[] systemRarNames = new String[systemRarsAllowingPoolCreation.size()];
        return systemRarsAllowingPoolCreation.toArray(systemRarNames);
    }

    public String[] getConnectionDefinitionNames(String rarName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getConnectionDefinitionNames(rarName);
    }

    public String getSecurityPermissionSpec(String moduleName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getSecurityPermissionSpec(moduleName);
    }

    public String[] getAdminObjectInterfaceNames(String rarName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getAdminObjectInterfaceNames(rarName);
    }

    public String[] getAdminObjectClassNames(String rarName, String intfName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getAdminObjectClassNames(rarName, intfName);
    }

    public boolean hasAdminObject(String rarName, String intfName, String className) throws ConnectorRuntimeException {
        return this.configParserAdmService.hasAdminObject(rarName, intfName, className);
    }

    public Map<String, String> getResourceAdapterConfigProps(String rarName) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getResourceAdapterConfigProps(rarName);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public Map<String, String> getMCFConfigProps(String rarName, String connectionDefName) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getMCFConfigProps(rarName, connectionDefName);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public Map<String, String> getAdminObjectConfigProps(String rarName, String adminObjectIntf) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getAdminObjectConfigProps(rarName, adminObjectIntf);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public Map<String, String> getAdminObjectConfigProps(String rarName, String adminObjectIntf, String adminObjectClass) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getAdminObjectConfigProps(rarName, adminObjectIntf, adminObjectClass);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public Map<String, String> getConnectorConfigJavaBeans(String rarName, String connectionDefName, String type) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getConnectorConfigJavaBeans(rarName, connectionDefName, type);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public String getActivationSpecClass(String rarName, String messageListenerType) throws ConnectorRuntimeException {
        return this.configParserAdmService.getActivationSpecClass(rarName, messageListenerType);
    }

    public String[] getMessageListenerTypes(String rarName) throws ConnectorRuntimeException {
        return this.configParserAdmService.getMessageListenerTypes(rarName);
    }

    public Map<String, String> getMessageListenerConfigProps(String rarName, String messageListenerType) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getMessageListenerConfigProps(rarName, messageListenerType);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public Map<String, String> getMessageListenerConfigPropTypes(String rarName, String messageListenerType) throws ConnectorRuntimeException {
        Properties properties = this.configParserAdmService.getMessageListenerConfigPropTypes(rarName, messageListenerType);
        return ConnectorsUtil.convertPropertiesToMap((Properties)properties);
    }

    public void switchOnMatching(String rarName, PoolInfo poolInfo) {
        this.connectorService.switchOnMatching(rarName, poolInfo);
    }

    public void switchOnMatchingInJndi(PoolInfo poolInfo) throws ConnectorRuntimeException {
        this.ccPoolAdmService.switchOnMatching(poolInfo);
    }

    public GlassfishNamingManager getNamingManager() {
        return this.namingManager;
    }

    public void postConstruct() {
        this.ccPoolAdmService = (ConnectorConnectionPoolAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorConnectionPool");
        this.connectorResourceAdmService = (ConnectorResourceAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorResource");
        this.connectorService = new ConnectorService();
        this.resourceAdapterAdmService = (ResourceAdapterAdminServiceImpl)ConnectorAdminServicesFactory.getService("ResourceAdapter");
        this.connectorSecurityAdmService = (ConnectorSecurityAdminServiceImpl)ConnectorAdminServicesFactory.getService("Security");
        this.adminObjectAdminService = (ConnectorAdminObjectAdminServiceImpl)ConnectorAdminServicesFactory.getService("AdminObjectResource");
        this.configParserAdmService = new ConnectorConfigurationParserServiceImpl();
        this.jdbcAdminService = (JdbcAdminServiceImpl)ConnectorAdminServicesFactory.getService("Jdbc");
        this.initializeEnvironment(this.processEnvironment);
        if (this.isServer()) {
            this.getProbeProviderUtil().registerProbeProvider();
        }
    }

    private void initializeEnvironment(ProcessEnvironment processEnvironment) {
        this.processType = processEnvironment.getProcessType();
    }

    public boolean isConnectorConnectionPoolDeployed(PoolInfo poolInfo) {
        return this.ccPoolAdmService.isConnectorConnectionPoolDeployed(poolInfo);
    }

    public boolean reconfigureConnectorConnectionPool(ConnectorConnectionPool ccp, Set excludedProps) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.reconfigureConnectorConnectionPool(ccp, excludedProps);
    }

    public void recreateConnectorConnectionPool(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        this.ccPoolAdmService.recreateConnectorConnectionPool(ccp);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, String connectionDefinitionName, String rarName, List<Property> props, List<SecurityMap> securityMaps) throws ConnectorRuntimeException {
        this.ccPoolAdmService.createConnectorConnectionPool(ccp, connectionDefinitionName, rarName, props, securityMaps);
    }

    public boolean checkAndLoadResource(Object resource, Object pool, String resourceType, String resourceName, String raName) throws ConnectorRuntimeException {
        return this.connectorService.checkAndLoadResource(resource, pool, resourceType, resourceName, raName);
    }

    public void cleanUpResourcesAndShutdownAllActiveRAs() {
        this.poolManager.killFreeConnectionsInPools();
        this.resourceAdapterAdmService.stopAllActiveResourceAdapters();
    }

    public void shutdownAllActiveResourceAdapters() {
        this.resourceAdapterAdmService.stopAllActiveResourceAdapters();
    }

    public PoolManager getPoolManager() {
        return this.poolManager;
    }

    public InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    public Timer getTimer() {
        return ConnectorTimerProxy.getProxy();
    }

    public Set getResourceReferenceDescriptor() {
        JndiNameEnvironment jndiEnv = this.componentEnvManager.getCurrentJndiNameEnvironment();
        if (jndiEnv != null) {
            return jndiEnv.getResourceReferenceDescriptors();
        }
        return null;
    }

    public void preDestroy() {
    }

    public AuthenticationService getAuthenticationService(String rarName, PoolInfo poolInfo) {
        return this.connectorSecurityAdmService.getAuthenticationService(rarName, poolInfo);
    }

    public boolean isEmbedded() {
        return ProcessEnvironment.ProcessType.Embedded.equals((Object)this.processType);
    }

    public boolean isNonACCRuntime() {
        return ProcessEnvironment.ProcessType.Other.equals((Object)this.processType);
    }

    public boolean isServer() {
        return ProcessEnvironment.ProcessType.Server.equals((Object)this.processType);
    }

    public boolean isACCRuntime() {
        return ProcessEnvironment.ProcessType.ACC.equals((Object)this.processType);
    }

    public Transaction getTransaction() throws SystemException {
        return this.getTransactionManager().getTransaction();
    }

    public JavaEETransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = (JavaEETransactionManager)this.habitat.getComponent(JavaEETransactionManager.class);
        }
        return this.transactionManager;
    }

    private ConnectorNamingEventNotifier getResourceRebindEventNotifier() {
        return this.connectorResourceAdmService.getResourceRebindEventNotifier();
    }

    public void registerConnectorNamingEventListener(ConnectorNamingEventListener listener) {
        this.connectorResourceAdmService.getResourceRebindEventNotifier().addListener(listener);
    }

    public void unregisterConnectorNamingEventListener(ConnectorNamingEventListener listener) {
        this.connectorResourceAdmService.getResourceRebindEventNotifier().removeListener(listener);
    }

    public ResourcePool getConnectionPoolConfig(PoolInfo poolInfo) {
        if (ConnectorsUtil.isApplicationScopedResource((GenericResourceInfo)poolInfo) || ConnectorsUtil.isModuleScopedResource((GenericResourceInfo)poolInfo)) {
            String applicationName = poolInfo.getApplicationName();
            String moduleName = poolInfo.getModuleName();
            Resources asc = null;
            if (applicationName != null && moduleName != null) {
                asc = this.getApplications().getApplication(applicationName).getModule(moduleName).getResources();
            } else if (applicationName != null) {
                asc = this.getApplications().getApplication(applicationName).getResources();
            }
            ResourcePool pool = ConnectorsUtil.getConnectionPoolConfig((PoolInfo)poolInfo, asc);
            if (pool == null) {
                throw new RuntimeException("No pool by name [" + poolInfo + "] found for applicaton [" + applicationName + "]");
            }
            return pool;
        }
        return ConnectorsUtil.getConnectionPoolConfig((PoolInfo)poolInfo, (Resources)this.getResources());
    }

    public boolean pingConnectionPool(PoolInfo poolInfo) throws ResourceException {
        return this.ccPoolAdmService.testConnectionPool(poolInfo);
    }

    public ConnectorConstants.PoolType getPoolType(PoolInfo poolInfo) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.getPoolType(poolInfo);
    }

    public WorkManager getWorkManagerProxy(String poolId, String moduleName, ClassLoader rarCL) throws ConnectorRuntimeException {
        return ((WorkManagerFactory)this.habitat.getComponent(WorkManagerFactory.class)).getWorkManagerProxy(poolId, moduleName, rarCL);
    }

    public XATerminator getXATerminatorProxy(String moduleName) {
        XATerminator xat = this.getTransactionManager().getXATerminator();
        return new XATerminatorProxy(xat);
    }

    public void removeWorkManagerProxy(String moduleName) {
        ((WorkManagerFactory)this.habitat.getComponent(WorkManagerFactory.class)).removeWorkManager(moduleName);
    }

    public void addAdminObject(String appName, String connectorName, ResourceInfo resourceInfo, String adminObjectType, String adminObjectClassName, Properties props) throws ConnectorRuntimeException {
        this.adminObjectAdminService.addAdminObject(appName, connectorName, resourceInfo, adminObjectType, adminObjectClassName, props);
    }

    public void deleteAdminObject(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        this.adminObjectAdminService.deleteAdminObject(resourceInfo);
    }

    public ClassLoader getSystemRARClassLoader(String rarName) throws ConnectorRuntimeException {
        return this.cclUtil.getSystemRARClassLoader(rarName);
    }

    public ClassLoader createConnectorClassLoader(String moduleDirectory, ClassLoader parent, String rarModuleName) throws ConnectorRuntimeException {
        List libraries = ConnectorsUtil.getInstalledLibrariesFromManifest((String)moduleDirectory, (ServerEnvironment)this.env);
        return this.cclUtil.createRARClassLoader(moduleDirectory, parent, rarModuleName, libraries);
    }

    public ResourceDeployer getResourceDeployer(Object resource) {
        Collection deployers = this.deployerHabitat.getAllByContract(ResourceDeployer.class);
        for (ResourceDeployer deployer : deployers) {
            if (!deployer.handles(resource)) continue;
            return deployer;
        }
        return null;
    }

    public void addResourceAdapterConfig(String rarName, ResourceAdapterConfig raConfig) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.addResourceAdapterConfig(rarName, raConfig);
    }

    public void deleteResourceAdapterConfig(String rarName) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.deleteResourceAdapterConfig(rarName);
    }

    public void registerConnectorApplication(ConnectorApplication rarModule) {
        this.connectorRegistry.addConnectorApplication(rarModule);
    }

    public void unregisterConnectorApplication(String rarName) {
        this.connectorRegistry.removeConnectorApplication(rarName);
    }

    public void undeployResourcesOfModule(String rarName) {
        ConnectorApplication app = this.connectorRegistry.getConnectorApplication(rarName);
        app.undeployResources();
    }

    public void deployResourcesOfModule(String rarName) {
        ConnectorApplication app = this.connectorRegistry.getConnectorApplication(rarName);
        app.deployResources();
    }

    public ActiveRAFactory getActiveRAFactory() {
        return this.activeRAFactory;
    }

    public Applications getApplications() {
        return (Applications)this.applications.getComponent(Applications.class);
    }

    public ApplicationRegistry getAppRegistry() {
        return (ApplicationRegistry)this.habitat.getComponent(ApplicationRegistry.class);
    }

    public ApplicationArchivist getApplicationArchivist() {
        return (ApplicationArchivist)this.habitat.getComponent(ApplicationArchivist.class);
    }

    public FileArchive getFileArchive() {
        return (FileArchive)this.habitat.getComponent(FileArchive.class);
    }

    public Domain getDomain() {
        return (Domain)this.habitat.getComponent(Domain.class);
    }

    public ServerEnvironment getServerEnvironment() {
        return this.env;
    }

    public void createActiveResourceAdapterForEmbeddedRar(String rarModuleName) throws ConnectorRuntimeException {
        this.connectorService.createActiveResourceAdapterForEmbeddedRar(rarModuleName);
    }

    public boolean checkAccessibility(String rarName, ClassLoader loader) {
        return this.connectorService.checkAccessibility(rarName, loader);
    }

    public void loadDeferredResourceAdapter(String rarName) throws ConnectorRuntimeException {
        this.connectorService.loadDeferredResourceAdapter(rarName);
    }

    public SecurityRoleMapperFactory getSecurityRoleMapperFactory() {
        return (SecurityRoleMapperFactory)this.habitat.getComponent(SecurityRoleMapperFactory.class);
    }

    public CallbackHandler getCallbackHandler() {
        this.habitat.getComponent(SecurityServicesUtil.class);
        return (CallbackHandler)this.habitat.getComponent(ContainerCallbackHandler.class);
    }

    public ConnectorArchivist getConnectorArchvist() throws ConnectorRuntimeException {
        try {
            ArchivistFactory archivistFactory = (ArchivistFactory)this.habitat.getComponent(ArchivistFactory.class);
            return (ConnectorArchivist)archivistFactory.getArchivist(XModuleType.RAR);
        }
        catch (IOException ioe) {
            this._logger.log(Level.WARNING, "unable to get Connector Archivist : ", ioe);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(ioe.getMessage());
            cre.setStackTrace(ioe.getStackTrace());
            throw cre;
        }
    }

    public WorkContextHandler getWorkContextHandler() {
        return (WorkContextHandler)this.habitat.getComponent(WorkContextHandler.class);
    }

    public ComponentEnvManager getComponentEnvManager() {
        return this.componentEnvManager;
    }

    public DelegatingClassLoader getConnectorClassLoader() {
        return this.clh.getConnectorClassLoader(null);
    }

    public ClassLoaderHierarchy getClassLoaderHierarchy() {
        return this.clh;
    }

    public void registerDataSourceDefinitions(Application application) {
        ((DataSourceDefinitionDeployer)this.habitat.getComponent(DataSourceDefinitionDeployer.class)).registerDataSourceDefinitions(application);
    }

    public List<WorkSecurityMap> getWorkSecurityMap(String raName) {
        List workSecurityMap = ConnectorsUtil.getWorkSecurityMaps((String)raName, (Resources)this.getResources());
        List appScopedMap = null;
        String appName = raName;
        if (!ConnectorsUtil.isStandAloneRA((String)raName)) {
            Resources msr;
            String resourceAdapterName;
            Module module;
            appName = ConnectorsUtil.getApplicationNameOfEmbeddedRar((String)raName);
            com.sun.enterprise.config.serverbeans.Application application = this.getApplications().getApplication(appName);
            if (application != null && (module = application.getModule(resourceAdapterName = ConnectorsUtil.getRarNameFromApplication((String)raName))) != null && (msr = module.getResources()) != null) {
                appScopedMap = ConnectorsUtil.getWorkSecurityMaps((String)raName, (Resources)msr);
            }
        } else {
            Resources asc;
            com.sun.enterprise.config.serverbeans.Application app = this.getApplications().getApplication(appName);
            if (app != null && (asc = app.getResources()) != null) {
                appScopedMap = ConnectorsUtil.getWorkSecurityMaps((String)raName, (Resources)asc);
            }
        }
        if (appScopedMap != null) {
            workSecurityMap.addAll(appScopedMap);
        }
        return workSecurityMap;
    }

    public Resources getResources(PoolInfo poolInfo) {
        if (ConnectorsUtil.isModuleScopedResource((GenericResourceInfo)poolInfo)) {
            com.sun.enterprise.config.serverbeans.Application application = this.getApplications().getApplication(poolInfo.getApplicationName());
            if (application != null) {
                Module module = application.getModule(poolInfo.getModuleName());
                return module.getResources();
            }
            return null;
        }
        if (ConnectorsUtil.isApplicationScopedResource((GenericResourceInfo)poolInfo)) {
            com.sun.enterprise.config.serverbeans.Application application = this.getApplications().getApplication(poolInfo.getApplicationName());
            if (application != null) {
                return application.getResources();
            }
            return null;
        }
        return this.getResources();
    }

    public Resources getResources(ResourceInfo resourceInfo) {
        if (ConnectorsUtil.isModuleScopedResource((GenericResourceInfo)resourceInfo)) {
            com.sun.enterprise.config.serverbeans.Application application = this.getApplications().getApplication(resourceInfo.getApplicationName());
            Module module = application.getModule(resourceInfo.getModuleName());
            return module.getResources();
        }
        if (ConnectorsUtil.isApplicationScopedResource((GenericResourceInfo)resourceInfo)) {
            com.sun.enterprise.config.serverbeans.Application application = this.getApplications().getApplication(resourceInfo.getApplicationName());
            return application.getResources();
        }
        return this.getResources();
    }

    private Resources getResources() {
        if (this.globalResources == null) {
            this.globalResources = ((Domain)this.habitat.getComponent(Domain.class)).getResources();
        }
        return this.globalResources;
    }

    public long getShutdownTimeout() {
        return ConnectorsUtil.getShutdownTimeout((com.sun.enterprise.config.serverbeans.ConnectorService)((com.sun.enterprise.config.serverbeans.ConnectorService)this.habitat.getComponent(com.sun.enterprise.config.serverbeans.ConnectorService.class)));
    }

    public boolean flushConnectionPool(String poolName) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.flushConnectionPool(new PoolInfo(poolName));
    }

    public boolean flushConnectionPool(PoolInfo poolInfo) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.flushConnectionPool(poolInfo);
    }

    public Set<String> getValidationTableNames(PoolInfo poolInfo) throws ResourceException {
        return this.jdbcAdminService.getValidationTableNames(poolInfo);
    }

    public Set<String> getValidationClassNames(String dbVendor) {
        return this.jdbcAdminService.getValidationClassNames(dbVendor);
    }

    public Set<String> getJdbcDriverClassNames(String dbVendor, String resType) {
        return this.driverLoader.getJdbcDriverClassNames(dbVendor, resType);
    }

    public Set<String> getJdbcDriverClassNames(String dbVendor, String resType, boolean introspect) {
        return this.driverLoader.getJdbcDriverClassNames(dbVendor, resType, introspect);
    }

    public ConnectorJavaBeanValidator getConnectorBeanValidator() {
        return this.connectorBeanValidator;
    }

    public boolean getPingDuringPoolCreation(PoolInfo poolInfo) {
        return ConnectorsUtil.getPingDuringPoolCreation((PoolInfo)poolInfo, (Resources)this.getResources(poolInfo));
    }

    public Set<String> getDatabaseVendorNames() {
        return this.driverLoader.getDatabaseVendorNames();
    }
}

