/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.connectors.module.ConnectorDeployer;
import com.sun.enterprise.connectors.module.ResourcesApplication;
import com.sun.enterprise.connectors.module.ResourcesContainer;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.resource.ResourceUtilities;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import org.glassfish.admin.cli.resources.ResourceConflictException;
import org.glassfish.admin.cli.resources.ResourceFactory;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.admin.cli.resources.ResourcesXMLParser;
import org.glassfish.admin.cli.resources.SunResourcesXML;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.javaee.services.ResourcesBinder;
import org.glassfish.resource.common.Resource;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.ConfigSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ResourcesDeployer
extends JavaEEDeployer<ResourcesContainer, ResourcesApplication>
implements PostConstruct,
PreDestroy,
EventListener {
    @Inject
    private static ResourceFactory resourceFactory;
    @Inject
    private Domain domain;
    @Inject
    private ServerContext context;
    @Inject
    private static ApplicationRegistry appRegistry;
    @Inject
    private static Habitat habitat;
    @Inject
    private static ResourcesBinder resourcesBinder;
    @Inject
    private ConfigSupport configSupport;
    @Inject
    private Events events;
    @Inject
    private static Applications applications;
    private static Map<String, Map<String, Resources>> resourceConfigurations;
    private static Map<String, Application> preservedApps;
    private static Logger _logger;
    private static final String RESOURCES_XML_META_INF = "META-INF/glassfish-resources.xml";
    private static final String RESOURCES_XML_WEB_INF = "WEB-INF/glassfish-resources.xml";

    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public void preDestroy() {
        this.events.unregister((EventListener)this);
    }

    protected String getModuleType() {
        return "resources_ear";
    }

    public ResourcesApplication load(ResourcesContainer container, DeploymentContext context) {
        super.load((Container)container, context);
        ResourcesDeployer.debug("App-Scoped-Resources ResourcesDeployer.load()");
        ResourcesApplication application = (ResourcesApplication)habitat.getComponent(ResourcesApplication.class);
        application.setApplicationName(ResourcesDeployer.getAppNameFromDeployCmdParams(context));
        return application;
    }

    public void unload(ResourcesApplication appContainer, DeploymentContext context) {
        ResourcesDeployer.debug("Resources-Deployer :unload() called");
    }

    public static Resources getResources(String appName, String moduleName) {
        Map<String, Resources> allResources = resourceConfigurations.get(appName);
        if (allResources != null) {
            return allResources.get(moduleName);
        }
        return null;
    }

    private void processArchive(DeploymentContext dc) {
        try {
            ReadableArchive archive = dc.getSource();
            if (DeploymentUtils.hasResourcesXML((ReadableArchive)archive)) {
                HashMap appScopedResources = new HashMap();
                HashMap<String, String> fileNames = new HashMap<String, String>();
                String appName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
                this.retrieveAllResourcesXMLs(fileNames, archive, appName);
                for (String moduleName : fileNames.keySet()) {
                    String fileName = (String)fileNames.get(moduleName);
                    ResourcesDeployer.debug("Sun Resources XML : " + fileName);
                    moduleName = ResourcesDeployer.getActualModuleName(moduleName);
                    String scope = appName.equals(moduleName) ? "java:app/" : "java:module/";
                    File file = new File(fileName);
                    ResourcesXMLParser parser = new ResourcesXMLParser(file, scope);
                    this.validateResourcesXML(file, parser);
                    List list = parser.getResourcesList();
                    HashMap<String, List> resourcesList = new HashMap<String, List>();
                    List nonConnectorResources = ResourcesXMLParser.getNonConnectorResourcesList((List)list, (boolean)false, (boolean)true);
                    resourcesList.put("NON-CONNECTOR", nonConnectorResources);
                    List connectorResources = ResourcesXMLParser.getConnectorResourcesList((List)list, (boolean)false, (boolean)true);
                    resourcesList.put("CONNECTOR", connectorResources);
                    appScopedResources.put(moduleName, resourcesList);
                }
                dc.addTransientAppMetaData("app-scoped-resources-map", appScopedResources);
                ApplicationInfo appInfo = appRegistry.get(appName);
                if (appInfo != null) {
                    Application app = (Application)dc.getTransientAppMetaData("application", Application.class);
                    appInfo.addTransientAppMetaData("application", (Object)app);
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Failue while processing glassfish-resources.xml(s) in the archive ", (Throwable)e);
        }
    }

    private void validateResourcesXML(File file, ResourcesXMLParser parser) throws ResourceConflictException {
        String filePath = file.getPath();
        SunResourcesXML sunResourcesXML = new SunResourcesXML(filePath, parser.getResourcesList());
        ArrayList<SunResourcesXML> resourcesXMLList = new ArrayList<SunResourcesXML>();
        resourcesXMLList.add(sunResourcesXML);
        ResourceUtilities.resolveResourceDuplicatesConflictsWithinArchive(resourcesXMLList);
    }

    public static void retainResourceConfig(DeploymentContext dc, Map<String, Resources> allResources) throws Exception {
        List modules;
        String appName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
        Application application = (Application)dc.getTransientAppMetaData("application", Application.class);
        Resources appScopedResources = allResources.get(appName);
        if (appScopedResources != null) {
            application.setResources(appScopedResources);
        }
        if (DeploymentUtils.isEAR((ReadableArchive)dc.getSource()) && (modules = application.getModule()) != null) {
            for (Module module : modules) {
                Resources moduleScopedResources = allResources.get(module.getName());
                if (moduleScopedResources == null) continue;
                module.setResources(moduleScopedResources);
            }
        }
    }

    public static void populateResourceConfigInAppInfo(DeploymentContext dc) {
        String appName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
        Application application = applications.getApplication(appName);
        ApplicationInfo appInfo = appRegistry.get(appName);
        if (application != null && appInfo != null) {
            List modules;
            Resources appScopedResources = application.getResources();
            if (appScopedResources != null) {
                appInfo.addTransientAppMetaData("application", (Object)application);
                appInfo.addTransientAppMetaData(application.getName() + "-resources", (Object)appScopedResources);
            }
            if ((modules = application.getModule()) != null) {
                for (Module module : modules) {
                    Resources moduleScopedResources = module.getResources();
                    if (moduleScopedResources == null) continue;
                    appInfo.addTransientAppMetaData(module.getName() + "-resources", (Object)moduleScopedResources);
                }
            }
        }
    }

    public static void createResources(DeploymentContext dc, boolean embedded, boolean deployResources) throws ResourceException {
        String appName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
        Application app = (Application)dc.getTransientAppMetaData("application", Application.class);
        Map resourcesList = (Map)dc.getTransientAppMetadata().get("app-scoped-resources-map");
        if (resourcesList != null) {
            List modules;
            Map appLevelResources = (Map)resourcesList.get(appName);
            if (appLevelResources != null) {
                List connectorResources = (List)appLevelResources.get("CONNECTOR");
                ResourcesDeployer.createAppScopedResources(app, connectorResources, dc, embedded);
                List nonConnectorResources = (List)appLevelResources.get("NON-CONNECTOR");
                ResourcesDeployer.createAppScopedResources(app, nonConnectorResources, dc, embedded);
            }
            if ((modules = app.getModule()) != null) {
                for (Module module : modules) {
                    Map moduleResources;
                    String actualModuleName = ResourcesDeployer.getActualModuleName(module.getName());
                    if (appName.equals(actualModuleName) || (moduleResources = (Map)resourcesList.get(actualModuleName)) == null) continue;
                    List connectorResources = (List)moduleResources.get("CONNECTOR");
                    ResourcesDeployer.createModuleScopedResources(app, module, connectorResources, dc, embedded);
                    List nonConnectorResources = (List)moduleResources.get("NON-CONNECTOR");
                    ResourcesDeployer.createModuleScopedResources(app, module, nonConnectorResources, dc, embedded);
                }
            }
        }
    }

    private static String getActualModuleName(String moduleName) {
        String actualModuleName = moduleName;
        if (moduleName.endsWith("_war")) {
            int index = moduleName.lastIndexOf("_war");
            actualModuleName = moduleName.substring(0, index) + ".war";
        } else if (moduleName.endsWith("_rar")) {
            int index = moduleName.lastIndexOf("_rar");
            actualModuleName = moduleName.substring(0, index) + ".rar";
        } else if (moduleName.endsWith("_jar")) {
            int index = moduleName.lastIndexOf("_jar");
            actualModuleName = moduleName.substring(0, index) + ".jar";
        }
        return actualModuleName;
    }

    private static Collection<com.sun.enterprise.config.serverbeans.Resource> createConfig(Resources resources, Collection<Resource> resourcesToRegister, boolean embedded) throws ResourceException {
        ArrayList<com.sun.enterprise.config.serverbeans.Resource> resourceConfigs = new ArrayList<com.sun.enterprise.config.serverbeans.Resource>();
        for (Resource resource : resourcesToRegister) {
            HashMap attrList = resource.getAttributes();
            Properties props = resource.getProperties();
            String desc = resource.getDescription();
            if (desc != null) {
                attrList.put("description", desc);
            }
            try {
                com.sun.enterprise.config.serverbeans.Resource configBeanResource;
                ResourceManager rm = resourceFactory.getResourceManager(resource);
                if (embedded && ResourcesDeployer.isEmbeddedResource(resource, resourcesToRegister)) {
                    configBeanResource = rm.createConfigBean(resources, attrList, props, false);
                    resources.getResources().add(configBeanResource);
                    resourceConfigs.add(configBeanResource);
                    continue;
                }
                if (embedded || ResourcesDeployer.isEmbeddedResource(resource, resourcesToRegister)) continue;
                configBeanResource = rm.createConfigBean(resources, attrList, props, true);
                resources.getResources().add(configBeanResource);
                resourceConfigs.add(configBeanResource);
            }
            catch (Exception e) {
                throw new ResourceException((Throwable)e);
            }
        }
        return resourceConfigs;
    }

    private static boolean isConnectorResource(Resource resource) {
        return resource.getType().equals("admin-object-resource") || resource.getType().equals("connector-connection-pool") || resource.getType().equals("connector-resource") || resource.getType().equals("resource-adapter-config") || resource.getType().equals("work-security-map");
    }

    private static boolean isEmbeddedResource(Resource resource, Collection<Resource> resources) {
        boolean result = false;
        if (ResourcesDeployer.isConnectorResource(resource)) {
            String attributeName = null;
            if (resource.getType().equals("admin-object-resource")) {
                attributeName = "res-adapter";
            } else if (resource.getType().equals("connector-connection-pool")) {
                attributeName = "resource-adapter-name";
            } else if (resource.getType().equals("connector-resource")) {
                String poolName = (String)resource.getAttributes().get("pool-name");
                if (poolName != null) {
                    Resource poolResource;
                    resource = poolResource = ResourcesDeployer.getPoolResource(poolName, resources);
                    attributeName = "resource-adapter-name";
                }
            } else if (resource.getType().equals("work-security-map")) {
                attributeName = "resource-adapter-name";
            }
            if (attributeName != null && resource != null) {
                result = ResourcesDeployer.isEmbeddedRar(resource, attributeName);
            }
        }
        return result;
    }

    private static Resource getPoolResource(String poolName, Collection<Resource> resources) {
        Resource result = null;
        for (Resource resource : resources) {
            String cpName;
            if (!resource.getType().equals("connector-connection-pool") || !poolName.equals(cpName = (String)resource.getAttributes().get("name"))) continue;
            result = resource;
            break;
        }
        return result;
    }

    private static boolean isEmbeddedRar(Resource resource, String attributeName) {
        boolean result = false;
        String raName = (String)resource.getAttributes().get(attributeName);
        if (raName != null && raName.contains("#")) {
            result = true;
        }
        return result;
    }

    private static void createAppScopedResources(Application app, List<Resource> resources, DeploymentContext dc, boolean embedded) throws ResourceException {
        try {
            if (resources != null) {
                Application application = (Application)dc.getTransientAppMetaData("application", Application.class);
                Resources asc = (Resources)dc.getTransientAppMetaData("app-level-resources-config", Resources.class);
                if (asc == null) {
                    asc = (Resources)application.createChild(Resources.class);
                    application.setResources(asc);
                    dc.addTransientAppMetaData("app-level-resources-config", (Object)asc);
                    ApplicationInfo appInfo = appRegistry.get(app.getName());
                    if (appInfo != null) {
                        appInfo.addTransientAppMetaData(app.getName() + "-resources", (Object)asc);
                    }
                }
                Collection<com.sun.enterprise.config.serverbeans.Resource> resourceConfigurations = ResourcesDeployer.createConfig(asc, resources, embedded);
                String appName = app.getName();
                ResourcesDeployer.preserveResources(asc, appName, appName);
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{app.getName(), e};
            _logger.log(Level.SEVERE, "gf.resources.app.scope.deployment.failure", params);
            throw new ResourceException((Throwable)e);
        }
    }

    private static void preserveResources(Resources resources, String appName, String moduleName) {
        Map<String, Resources> allResources = resourceConfigurations.get(appName);
        if (allResources != null) {
            allResources.put(moduleName, resources);
        } else {
            allResources = new HashMap<String, Resources>();
            allResources.put(moduleName, resources);
            resourceConfigurations.put(appName, allResources);
        }
    }

    private static void createModuleScopedResources(Application app, Module module, List<Resource> resources, DeploymentContext dc, boolean embedded) throws ResourceException {
        try {
            if (resources != null) {
                Resources msc = (Resources)dc.getTransientAppMetaData(module.getName() + "-resources", Resources.class);
                if (msc == null) {
                    msc = (Resources)module.createChild(Resources.class);
                    module.setResources(msc);
                    dc.addTransientAppMetaData(module.getName() + "-resources", (Object)msc);
                    ApplicationInfo appInfo = appRegistry.get(app.getName());
                    if (appInfo != null) {
                        appInfo.addTransientAppMetaData(module.getName() + "-resources", (Object)msc);
                    }
                }
                Collection<com.sun.enterprise.config.serverbeans.Resource> resourceConfigurations = ResourcesDeployer.createConfig(msc, resources, embedded);
                ResourcesDeployer.preserveResources(msc, app.getName(), module.getName());
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{module.getName(), app.getName(), e};
            _logger.log(Level.SEVERE, "gf.resources.module.scope.deployment.failure", params);
            throw new ResourceException((Throwable)e);
        }
    }

    public static void deployResourcesFromConfiguration(String appName, boolean embedded) throws Exception {
        Application application = applications.getApplication(appName);
        ApplicationInfo appInfo = appRegistry.get(appName);
        if (application != null && appInfo != null) {
            List modules;
            Resources appScopedResources = application.getResources();
            if (appScopedResources != null) {
                ResourcesDeployer.deployResources(appName, null, appScopedResources.getResources(), embedded);
            }
            if ((modules = application.getModule()) != null) {
                for (Module module : modules) {
                    Resources moduleScopedResources = module.getResources();
                    String moduleName = module.getName();
                    if (moduleScopedResources == null) continue;
                    ResourcesDeployer.deployResources(appName, moduleName, moduleScopedResources.getResources(), embedded);
                }
            }
        }
    }

    public static void deployResources(String applicationName, boolean embedded) throws Exception {
        Map<String, Resources> allResources = resourceConfigurations.get(applicationName);
        if (allResources != null) {
            for (String moduleName : allResources.keySet()) {
                Resources resources = allResources.get(moduleName);
                if (applicationName.equals(moduleName)) {
                    ResourcesDeployer.deployResources(applicationName, null, resources.getResources(), embedded);
                    continue;
                }
                ResourcesDeployer.deployResources(applicationName, moduleName, resources.getResources(), embedded);
            }
        }
    }

    public static void deployResources(String applicationName, String moduleName, Collection<com.sun.enterprise.config.serverbeans.Resource> configBeanResources, boolean embedded) throws Exception {
        for (com.sun.enterprise.config.serverbeans.Resource configBeanResource : configBeanResources) {
            if (configBeanResource instanceof ResourcePool) {
                ResourcePool resourcePool = (ResourcePool)configBeanResource;
                if (embedded) {
                    if (ResourcesDeployer.isEmbeddedRarResource(configBeanResource, configBeanResources) != ConnectorConstants.TriState.TRUE) continue;
                    ResourcesDeployer.getResourceDeployer(resourcePool).deployResource((Object)resourcePool, applicationName, moduleName);
                    continue;
                }
                if (ResourcesDeployer.isEmbeddedRarResource(configBeanResource, configBeanResources) != ConnectorConstants.TriState.FALSE) continue;
                ResourcesDeployer.getResourceDeployer(resourcePool).deployResource((Object)resourcePool, applicationName, moduleName);
                continue;
            }
            if (configBeanResource instanceof BindableResource) {
                BindableResource resource = (BindableResource)configBeanResource;
                ResourceInfo resourceInfo = new ResourceInfo(resource.getJndiName(), applicationName, moduleName);
                if (embedded) {
                    if (ResourcesDeployer.isEmbeddedRarResource(configBeanResource, configBeanResources) != ConnectorConstants.TriState.TRUE) continue;
                    resourcesBinder.deployResource(resourceInfo, (com.sun.enterprise.config.serverbeans.Resource)resource);
                    continue;
                }
                if (ResourcesDeployer.isEmbeddedRarResource(configBeanResource, configBeanResources) != ConnectorConstants.TriState.FALSE) continue;
                resourcesBinder.deployResource(resourceInfo, (com.sun.enterprise.config.serverbeans.Resource)resource);
                continue;
            }
            if (embedded) {
                if (ResourcesDeployer.isEmbeddedRarResource(configBeanResource, configBeanResources) != ConnectorConstants.TriState.TRUE) continue;
                ResourcesDeployer.getResourceDeployer(configBeanResource).deployResource((Object)configBeanResource);
                continue;
            }
            if (ResourcesDeployer.isEmbeddedRarResource(configBeanResource, configBeanResources) != ConnectorConstants.TriState.FALSE) continue;
            ResourcesDeployer.getResourceDeployer(configBeanResource).deployResource((Object)configBeanResource);
        }
    }

    public static ConnectorConstants.TriState isEmbeddedRarResource(com.sun.enterprise.config.serverbeans.Resource configBeanResource, Collection<com.sun.enterprise.config.serverbeans.Resource> configBeanResources) {
        WorkSecurityMap wsm;
        ConnectorConstants.TriState result = ConnectorConstants.TriState.FALSE;
        if (configBeanResource instanceof ConnectorResource) {
            String poolName = ((ConnectorResource)configBeanResource).getPoolName();
            ConnectorConnectionPool pool = ResourcesDeployer.getPool(configBeanResources, poolName);
            if (pool != null) {
                if (pool.getResourceAdapterName().contains("#")) {
                    result = ConnectorConstants.TriState.TRUE;
                }
            } else {
                result = ConnectorConstants.TriState.UNKNOWN;
            }
        } else if (configBeanResource instanceof AdminObjectResource) {
            AdminObjectResource aor = (AdminObjectResource)configBeanResource;
            if (aor.getResAdapter().contains("#")) {
                result = ConnectorConstants.TriState.TRUE;
            }
        } else if (configBeanResource instanceof ConnectorConnectionPool) {
            ConnectorConnectionPool ccp = (ConnectorConnectionPool)configBeanResource;
            if (ccp.getResourceAdapterName().contains("#")) {
                result = ConnectorConstants.TriState.TRUE;
            }
        } else if (configBeanResource instanceof WorkSecurityMap && (wsm = (WorkSecurityMap)configBeanResource).getResourceAdapterName().contains("#")) {
            result = ConnectorConstants.TriState.TRUE;
        }
        return result;
    }

    public static ConnectorConnectionPool getPool(Collection<com.sun.enterprise.config.serverbeans.Resource> configBeanResources, String poolName) {
        ConnectorConnectionPool result = null;
        for (com.sun.enterprise.config.serverbeans.Resource res : configBeanResources) {
            if (!(res instanceof ConnectorConnectionPool) || !((ConnectorConnectionPool)res).getName().equals(poolName)) continue;
            result = (ConnectorConnectionPool)res;
            break;
        }
        return result;
    }

    private static String getAppNameFromDeployCmdParams(DeploymentContext dc) {
        DeployCommandParameters commandParams = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        return commandParams.name();
    }

    public void retrieveAllResourcesXMLs(Map<String, String> fileNames, ReadableArchive archive, String actualArchiveName) throws IOException {
        if (DeploymentUtils.isEAR((ReadableArchive)archive)) {
            if (archive.exists(RESOURCES_XML_META_INF)) {
                String archivePath = archive.getURI().getPath();
                String fileName = archivePath + RESOURCES_XML_META_INF;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("GlassFish-Resources Deployer - fileName : " + fileName + " - parent : " + archive.getName());
                }
                fileNames.put(actualArchiveName, fileName);
            }
            Enumeration entries = archive.entries();
            while (entries.hasMoreElements()) {
                ReadableArchive subArchive;
                String element = (String)entries.nextElement();
                if (!element.endsWith(".jar") && !element.endsWith(".war") && !element.endsWith(".rar") && !element.endsWith("_jar") && !element.endsWith("_war") && !element.endsWith("_rar") || (subArchive = archive.getSubArchive(element)) == null) continue;
                this.retrieveResourcesXMLFromArchive(fileNames, subArchive, subArchive.getName());
            }
        } else {
            this.retrieveResourcesXMLFromArchive(fileNames, archive, actualArchiveName);
        }
    }

    private void retrieveResourcesXMLFromArchive(Map<String, String> fileNames, ReadableArchive archive, String actualArchiveName) {
        if (DeploymentUtils.hasResourcesXML((ReadableArchive)archive)) {
            String archivePath = archive.getURI().getPath();
            String fileName = DeploymentUtils.isWebArchive((ReadableArchive)archive) ? archivePath + RESOURCES_XML_WEB_INF : archivePath + RESOURCES_XML_META_INF;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("GlassFish-Resources Deployer - fileName : " + fileName + " - parent : " + archive.getName());
            }
            fileNames.put(actualArchiveName, fileName);
        }
    }

    private static ResourceDeployer getResourceDeployer(Object resource) {
        Collection deployers = habitat.getAllByContract(ResourceDeployer.class);
        for (ResourceDeployer deployer : deployers) {
            if (!deployer.handles(resource)) continue;
            return deployer;
        }
        return null;
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.DEPLOYMENT_BEFORE_CLASSLOADER_CREATION)) {
            DeploymentContext dc = (DeploymentContext)event.hook();
            DeployCommandParameters deployParams = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            this.processResources(dc, deployParams);
        } else if (event.is(Deployment.UNDEPLOYMENT_VALIDATION)) {
            DeploymentContext dc = (DeploymentContext)event.hook();
            UndeployCommandParameters undeployCommandParameters = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
            this.preserveResources(dc, undeployCommandParameters);
        } else if (Deployment.UNDEPLOYMENT_FAILURE.equals((Object)event.type())) {
            DeploymentContext dc = (DeploymentContext)event.hook();
            this.cleanupPreservedResources(dc, event);
        } else if (Deployment.DEPLOYMENT_FAILURE.equals((Object)event.type())) {
            DeploymentContext dc = (DeploymentContext)event.hook();
            String appName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
            this.cleanupResources(appName, ((DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class)).origin);
            this.cleanupPreservedResources(dc, event);
        } else if (Deployment.DEPLOYMENT_SUCCESS.equals((Object)event.type())) {
            ApplicationInfo applicationInfo = (ApplicationInfo)event.hook();
            String appName = applicationInfo.getName();
            resourceConfigurations.remove(appName);
        }
    }

    private void processResources(DeploymentContext dc, DeployCommandParameters deployParams) {
        try {
            if (deployParams.origin == OpsParams.Origin.deploy || deployParams.origin == OpsParams.Origin.deploy_instance) {
                String preserve;
                Properties properties = deployParams.properties;
                if (properties != null && (preserve = properties.getProperty("preserveAppScopedResources")) != null && Boolean.valueOf(preserve).booleanValue()) {
                    String appName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
                    Map<String, Resources> allResources = resourceConfigurations.remove(appName);
                    Application oldApp = preservedApps.remove(appName);
                    if (allResources != null && oldApp != null) {
                        Application application = (Application)dc.getTransientAppMetaData("application", Application.class);
                        this.validatePreservedResources(allResources, oldApp, application);
                        ResourcesDeployer.retainResourceConfig(dc, allResources);
                    }
                    return;
                }
                Application app = (Application)dc.getTransientAppMetaData("application", Application.class);
                String applicationName = ResourcesDeployer.getAppNameFromDeployCmdParams(dc);
                if (app != null) {
                    this.processArchive(dc);
                    ResourcesDeployer.createResources(dc, false, true);
                    ResourcesDeployer.createResources(dc, true, false);
                    ResourcesDeployer.deployResources(applicationName, false);
                } else {
                    ResourcesDeployer.deployResourcesFromConfiguration(applicationName, false);
                    ResourcesDeployer.populateResourceConfigInAppInfo(dc);
                }
            } else if (deployParams.origin == OpsParams.Origin.load) {
                ResourcesDeployer.populateResourceConfigInAppInfo(dc);
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Exception while processing archive of application [ " + ResourcesDeployer.getAppNameFromDeployCmdParams(dc) + " ] for resources definitions : " + e.getCause());
            }
            throw new DeploymentException((Throwable)e);
        }
    }

    private void validatePreservedResources(Map<String, Resources> allResources, Application oldApp, Application newApp) throws ResourceConflictException {
        ArrayList<Module> oldRARModules = new ArrayList<Module>();
        List oldModules = oldApp.getModule();
        for (Module oldModule : oldModules) {
            if (oldModule.getEngine("connector") == null) continue;
            oldRARModules.add(oldModule);
        }
        List newRARModules = newApp.getModule();
        ArrayList<Module> staleRars = new ArrayList<Module>();
        for (Module oldRARModule : oldRARModules) {
            String oldRARModuleName = oldRARModule.getName();
            boolean found = false;
            for (Module newRARModule : newRARModules) {
                String newRARModuleName = newRARModule.getName();
                if (!newRARModuleName.equals(oldRARModuleName)) continue;
                found = true;
            }
            if (found) continue;
            staleRars.add(oldRARModule);
        }
        String appName = newApp.getName();
        if (staleRars.size() > 0) {
            Resources appScopedResources = allResources.get(appName);
            if (appScopedResources != null) {
                this.validateResourcesForStaleReference(appName, staleRars, appScopedResources);
            }
            List newModules = newApp.getModule();
            for (Module newModule : newModules) {
                Resources oldModuleResources;
                Module oldModule = oldApp.getModule(newModule.getName());
                if (oldModule == null || (oldModuleResources = oldModule.getResources()) == null) continue;
                this.validateResourcesForStaleReference(appName, staleRars, oldModuleResources);
            }
        }
    }

    private void validateResourcesForStaleReference(String appName, List<Module> staleRars, Resources resources) throws ResourceConflictException {
        boolean found = false;
        for (com.sun.enterprise.config.serverbeans.Resource resource : resources.getResources()) {
            String rarNameOfResource;
            ResourcesUtil resourcesUtil = ResourcesUtil.createInstance();
            if (!resourcesUtil.isRARResource(resource) || !(rarNameOfResource = resourcesUtil.getRarNameOfResource(resource, resources)).contains("#")) continue;
            String embeddedRARName = ConnectorsUtil.getRarNameFromApplication((String)rarNameOfResource);
            for (Module module : staleRars) {
                if (!ResourcesDeployer.getActualModuleName(module.getName()).equals(embeddedRARName)) continue;
                throw new ResourceConflictException("Existing resources refer RAR [ " + embeddedRARName + " ] which is" + "not present in the re-deployed application [" + appName + "] anymore. " + "re-deploy the application after resolving the conflicts");
            }
        }
    }

    private void cleanupResources(String appName, OpsParams.Origin deploymentPhase) {
        try {
            Application application;
            if (deploymentPhase == OpsParams.Origin.deploy || deploymentPhase == OpsParams.Origin.deploy_instance || deploymentPhase == OpsParams.Origin.create_application_ref) {
                Map<String, Resources> allResources = resourceConfigurations.remove(appName);
                if (allResources != null) {
                    for (Map.Entry<String, Resources> entry : allResources.entrySet()) {
                        String moduleName = entry.getKey();
                        Resources resources = entry.getValue();
                        String actualModuleName = moduleName;
                        if (appName.equals(moduleName)) {
                            actualModuleName = null;
                        }
                        this.undeployResources(resources, appName, actualModuleName);
                    }
                }
            } else if (deploymentPhase == OpsParams.Origin.load && (application = applications.getApplication(appName)) != null) {
                Resources appScopedResources = application.getResources();
                this.undeployResources(appScopedResources, appName, null);
                List modules = application.getModule();
                if (modules != null) {
                    for (Module module : modules) {
                        Resources moduleScopedResources = module.getResources();
                        this.undeployResources(moduleScopedResources, appName, module.getName());
                    }
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception while cleaning-up resources during deployment failure", e);
        }
    }

    private void undeployResources(Resources resources, String appName, String moduleName) {
        if (resources != null) {
            for (com.sun.enterprise.config.serverbeans.Resource resource : resources.getResources()) {
                try {
                    if (resource instanceof ResourcePool) continue;
                    ResourcesDeployer.getResourceDeployer(resource).undeployResource((Object)resource, appName, moduleName);
                }
                catch (Exception e) {}
            }
            Collection pools = resources.getResources(ResourcePool.class);
            for (ResourcePool pool : pools) {
                try {
                    ResourcesDeployer.getResourceDeployer(pool).undeployResource((Object)pool, appName, moduleName);
                }
                catch (Exception e) {}
            }
        }
    }

    private void cleanupPreservedResources(DeploymentContext dc, EventListener.Event event) {
        if (Deployment.DEPLOYMENT_FAILURE.equals((Object)event.type())) {
            DeployCommandParameters deployCommandParameters = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            if (deployCommandParameters.origin == OpsParams.Origin.deploy || deployCommandParameters.origin == OpsParams.Origin.deploy_instance || deployCommandParameters.origin == OpsParams.Origin.create_application_ref) {
                Properties properties = deployCommandParameters.properties;
                String appName = deployCommandParameters.name();
                this.cleanupPreservedResources(appName, properties);
            }
        } else if (Deployment.UNDEPLOYMENT_FAILURE.equals((Object)event.type())) {
            UndeployCommandParameters undeployCommandParameters = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
            if (undeployCommandParameters.origin == OpsParams.Origin.undeploy) {
                Properties properties = undeployCommandParameters.properties;
                String appName = undeployCommandParameters.name();
                this.cleanupPreservedResources(appName, properties);
            }
        }
    }

    private void cleanupPreservedResources(String appName, Properties properties) {
        String preserve;
        if (properties != null && (preserve = properties.getProperty("preserveAppScopedResources")) != null && Boolean.valueOf(preserve).booleanValue()) {
            resourceConfigurations.remove(appName);
            preservedApps.remove(appName);
        }
    }

    private void preserveResources(DeploymentContext dc, UndeployCommandParameters undeployCommandParameters) {
        try {
            String preserve;
            Properties properties;
            if (undeployCommandParameters.origin == OpsParams.Origin.undeploy && (properties = undeployCommandParameters.properties) != null && (preserve = properties.getProperty("preserveAppScopedResources")) != null && Boolean.valueOf(preserve).booleanValue()) {
                ResourcesDeployer.debug("Preserve app scoped resources enabled");
                UndeployCommandParameters commandParams = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
                String appName = commandParams.name();
                Application app = applications.getApplication(appName);
                this.preserveResources(app);
                preservedApps.put(appName, app);
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    private void preserveResources(Application app) {
        List modules;
        String appName = app.getName();
        HashMap<String, Resources> allResources = new HashMap<String, Resources>();
        Resources appScopedResources = app.getResources();
        if (appScopedResources != null) {
            allResources.put(appName, appScopedResources);
        }
        if ((modules = app.getModule()) != null) {
            for (Module module : modules) {
                Resources moduleScopedResources = module.getResources();
                if (moduleScopedResources == null) continue;
                allResources.put(module.getName(), moduleScopedResources);
            }
        }
        resourceConfigurations.put(appName, allResources);
    }

    private static void debug(String message) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("[ASR] ResourceDeployer : " + message);
        }
    }

    static {
        resourceConfigurations = new HashMap<String, Map<String, Resources>>();
        preservedApps = new HashMap<String, Application>();
        _logger = LogDomains.getLogger(ConnectorDeployer.class, (String)"javax.enterprise.resource.resourceadapter");
    }
}

