/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.service.ConnectorAdminServicesFactory;
import com.sun.enterprise.connectors.service.ConnectorConnectionPoolAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.glassfish.resource.common.PoolInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcAdminServiceImpl
extends ConnectorService {
    private ConnectorConnectionPoolAdminServiceImpl ccPoolAdmService = (ConnectorConnectionPoolAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorConnectionPool");

    public Set<String> getValidationClassNames(String dbVendor) {
        TreeSet<String> classNames = new TreeSet<String>();
        if (dbVendor.equalsIgnoreCase("DERBY")) {
            classNames.add("org.glassfish.api.jdbc.validation.DerbyConnectionValidation");
        } else if (dbVendor.equalsIgnoreCase("MYSQL")) {
            classNames.add("org.glassfish.api.jdbc.validation.MySQLConnectionValidation");
        } else if (dbVendor.equalsIgnoreCase("ORACLE")) {
            classNames.add("org.glassfish.api.jdbc.validation.OracleConnectionValidation");
        } else if (dbVendor.equalsIgnoreCase("POSTGRES")) {
            classNames.add("org.glassfish.api.jdbc.validation.PostgresConnectionValidation");
        }
        return classNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getValidationTableNames(PoolInfo poolInfo) throws ResourceException {
        Set<String> set;
        ManagedConnectionFactory mcf = null;
        Subject defaultSubject = null;
        ManagedConnection mc = null;
        Connection con = null;
        try {
            try {
                mc = (ManagedConnection)this.ccPoolAdmService.getUnpooledConnection(poolInfo, null, false);
                mcf = this.ccPoolAdmService.obtainManagedConnectionFactory(poolInfo);
                if (mc != null) {
                    con = (Connection)mc.getConnection(defaultSubject, null);
                }
                set = JdbcAdminServiceImpl.getValidationTableNames(con, this.getDefaultDatabaseName(poolInfo, mcf));
                Object var8_8 = null;
            }
            catch (Exception re) {
                _logger.log(Level.WARNING, "pool.get_validation_table_names_failure", re.getMessage());
                throw new ResourceException((Throwable)re);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (mc == null) throw throwable;
                mc.destroy();
                throw throwable;
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINEST)) throw throwable;
                _logger.log(Level.FINEST, "pool.get_validation_table_names_mc_destroy", poolInfo);
                throw throwable;
            }
        }
        try {}
        catch (Exception ex) {
            if (!_logger.isLoggable(Level.FINEST)) return set;
            _logger.log(Level.FINEST, "pool.get_validation_table_names_mc_destroy", poolInfo);
            return set;
        }
        if (mc == null) return set;
        mc.destroy();
        return set;
    }

    private String getDefaultDatabaseName(PoolInfo poolInfo, ManagedConnectionFactory mcf) throws NamingException {
        String databaseName = null;
        ConnectorConnectionPool connectorConnectionPool = null;
        String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
        Context ic = this._runtime.getNamingManager().getInitialContext();
        connectorConnectionPool = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
        databaseName = this.ccPoolAdmService.getPropertyValue("DATABASENAME", connectorConnectionPool);
        if (databaseName == null || databaseName.trim().equals("")) {
            databaseName = ConnectionPoolObjectsUtils.getValueFromMCF("DatabaseName", poolInfo, mcf);
        }
        return databaseName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> getValidationTableNames(Connection con, String catalog) throws ResourceException {
        TreeSet<String> tableNames = new TreeSet<String>();
        if (catalog.trim().equals("")) {
            catalog = null;
        }
        if (con == null) throw new ResourceException("The connection is not valid as the connection is null");
        ResultSet rs = null;
        try {
            try {
                DatabaseMetaData dmd = con.getMetaData();
                rs = dmd.getTables(catalog, null, null, null);
                while (rs.next()) {
                    String tableName;
                    String schemaName = rs.getString(2);
                    String actualTableName = tableName = rs.getString(3);
                    if (schemaName != null && !schemaName.equals("")) {
                        actualTableName = schemaName + "." + tableName;
                    }
                    tableNames.add(actualTableName);
                }
                Object var9_9 = null;
            }
            catch (Exception sqle) {
                _logger.log(Level.INFO, "pool.get_validation_table_names");
                throw new ResourceException((Throwable)sqle);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (rs == null) throw throwable;
                rs.close();
                throw throwable;
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e1) {}
        if (rs == null) return tableNames;
        rs.close();
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean isPingable(String tableName, Connection con) {
        block19: {
            Statement stmt = null;
            ResultSet rs = null;
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM " + tableName);
            Object var7_4 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                break block19;
            }
            catch (Exception e2) {}
            break block19;
            {
                catch (Exception sqle) {
                    _logger.log(Level.INFO, "pool.exc_is_pingable", tableName);
                    boolean bl = false;
                    Object var7_5 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }
}

