/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-resource-adapter-config")
@Scoped(value=PerLookup.class)
@I18n(value="delete.resource.adapter.config")
public class DeleteResourceAdapterConfig
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteResourceAdapterConfig.class);
    @Param(name="raname", primary=true)
    private String raName;
    @Param(optional=true, obsolete=true)
    private String target = "server";
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.raName == null) {
            report.setMessage(localStrings.getLocalString("delete.resource.adapter.config.noRARName", "No RAR name defined for resource adapter config."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.domain.getResources().getResourceByName(ResourceAdapterConfig.class, this.raName) == null) {
            report.setMessage(localStrings.getLocalString("delete.resource.adapter.config.notfound", "Resource-Adapter-Config for {0} does not exist.", new Object[]{this.raName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    ResourceAdapterConfig resource = (ResourceAdapterConfig)DeleteResourceAdapterConfig.this.domain.getResources().getResourceByName(ResourceAdapterConfig.class, DeleteResourceAdapterConfig.this.raName);
                    if (resource != null && resource.getResourceAdapterName().equals(DeleteResourceAdapterConfig.this.raName)) {
                        return param.getResources().remove(resource);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)this.domain.getResources()) == null) {
                report.setMessage(localStrings.getLocalString("delete.resource.adapter.config.fail", "Unable to delete resource adapter config {0}", new Object[]{this.raName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.resource.adapter.config.fail", "Unable to delete resource adapter config {0}", new Object[]{this.raName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

