/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.ResourceNamingService;
import com.sun.appserv.connectors.internal.spi.ConnectorNamingEvent;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.naming.ConnectorNamingEventNotifier;
import com.sun.enterprise.connectors.naming.ConnectorResourceNamingEventNotifier;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.resource.naming.SerializableObjectRefAddr;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.glassfish.resource.common.GenericResourceInfo;
import org.glassfish.resource.common.PoolInfo;
import org.glassfish.resource.common.ResourceInfo;

public class ConnectorResourceAdminServiceImpl
extends ConnectorService {
    private ResourceNamingService namingService;

    public ConnectorResourceAdminServiceImpl() {
        this.namingService = this._runtime.getResourceNamingService();
    }

    public void createConnectorResource(ResourceInfo resourceInfo, PoolInfo poolInfo, String resourceType) throws ConnectorRuntimeException {
        try {
            ConnectorConnectionPool ccp = null;
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
            try {
                ccp = (ConnectorConnectionPool)this.namingService.lookup((GenericResourceInfo)poolInfo, jndiNameForPool);
            }
            catch (NamingException ne) {
                try {
                    this.checkAndLoadPool(poolInfo);
                    ccp = (ConnectorConnectionPool)this.namingService.lookup((GenericResourceInfo)poolInfo, jndiNameForPool);
                }
                catch (NamingException e) {
                    Object[] params = new Object[]{poolInfo, e};
                    _logger.log(Level.SEVERE, "unable.to.lookup.pool", params);
                }
            }
            if (ccp == null) {
                ccp = (ConnectorConnectionPool)this.namingService.lookup((GenericResourceInfo)poolInfo, jndiNameForPool);
            }
            ConnectorDescriptorInfo cdi = ccp.getConnectorDescriptorInfo();
            Reference ref = new Reference(cdi.getConnectionFactoryClass(), "com.sun.enterprise.resource.naming.ConnectorObjectFactory", null);
            RefAddr addr = new SerializableObjectRefAddr(PoolInfo.class.getName(), poolInfo);
            ref.add(addr);
            addr = new StringRefAddr("rarName", cdi.getRarName());
            ref.add(addr);
            SerializableObjectRefAddr resAddr = new SerializableObjectRefAddr(ResourceInfo.class.getName(), resourceInfo);
            ref.add(resAddr);
            try {
                this.namingService.publishObject(resourceInfo, (Object)ref, true);
                _registry.addResourceInfo(resourceInfo);
            }
            catch (NamingException ne) {
                ConnectorRuntimeException cre = new ConnectorRuntimeException(ne.getMessage());
                cre.initCause((Throwable)ne);
                Object[] params = new Object[]{resourceInfo, cre};
                _logger.log(Level.SEVERE, "rardeployment.resource_jndi_bind_failure", params);
                throw cre;
            }
            ConnectorResourceNamingEventNotifier.getInstance().notifyListeners(new ConnectorNamingEvent(resourceInfo.toString(), 0));
        }
        catch (NamingException ne) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(ne.getMessage());
            cre.initCause((Throwable)ne);
            Object[] params = new Object[]{resourceInfo, cre};
            _logger.log(Level.SEVERE, "rardeployment.jndi_lookup_failed", params);
            throw cre;
        }
    }

    public void deleteConnectorResource(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        try {
            try {
                this.namingService.unpublishObject((GenericResourceInfo)resourceInfo, resourceInfo.getName());
            }
            catch (NamingException ne) {
                if (ne instanceof NameNotFoundException) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "rardeployment.connectorresource_removal_from_jndi_error", resourceInfo);
                        _logger.log(Level.FINE, "", ne);
                    }
                    Object var5_3 = null;
                    _registry.removeResourceInfo(resourceInfo);
                    return;
                }
                ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to delete connector resource from jndi");
                cre.initCause((Throwable)ne);
                _logger.log(Level.SEVERE, "rardeployment.connectorresource_removal_from_jndi_error", resourceInfo);
                _logger.log(Level.SEVERE, "", cre);
                throw cre;
            }
            Object var5_2 = null;
            _registry.removeResourceInfo(resourceInfo);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            _registry.removeResourceInfo(resourceInfo);
            throw throwable;
        }
    }

    public ConnectorNamingEventNotifier getResourceRebindEventNotifier() {
        return ConnectorResourceNamingEventNotifier.getInstance();
    }

    public Object lookup(ResourceInfo resourceInfo) throws NamingException {
        Hashtable<String, String> env = null;
        String jndiName = resourceInfo.getName();
        String suffix = ConnectorsUtil.getValidSuffix((String)jndiName);
        if (suffix != null) {
            env = new Hashtable<String, String>();
            env.put("com.sun.enterprise.connectors.jndisuffix", suffix);
            jndiName = jndiName.substring(0, jndiName.lastIndexOf(suffix));
        }
        ResourceInfo actualResourceInfo = new ResourceInfo(jndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        return this.namingService.lookup((GenericResourceInfo)actualResourceInfo, actualResourceInfo.getName(), env);
    }

    public Object lookupDataSourceInDAS(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        MyDataSource myDS = new MyDataSource();
        myDS.setResourceInfo(resourceInfo);
        return myDS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyDataSource
    implements DataSource {
        private ResourceInfo resourceInfo;
        private PrintWriter logWriter;
        private int loginTimeout;

        MyDataSource() {
        }

        public void setResourceInfo(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
            this.validateResource(resourceInfo);
            this.resourceInfo = resourceInfo;
        }

        private void validateResource(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
            String tmpJndiName;
            ResourcesUtil resourcesUtil = ResourcesUtil.createInstance();
            String jndiName = resourceInfo.getName();
            String suffix = ConnectorsUtil.getValidSuffix((String)jndiName);
            if (suffix != null && resourcesUtil.getResource(tmpJndiName = jndiName.substring(0, jndiName.lastIndexOf(suffix)), resourceInfo.getApplicationName(), resourceInfo.getModuleName(), JdbcResource.class) != null) {
                return;
            }
            if (resourcesUtil.getResource(resourceInfo, JdbcResource.class) == null) {
                throw new ConnectorRuntimeException("Invalid resource : " + resourceInfo);
            }
        }

        @Override
        public Connection getConnection() throws SQLException {
            return ConnectorRuntime.getRuntime().getConnection(this.resourceInfo);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return ConnectorRuntime.getRuntime().getConnection(this.resourceInfo, username, password);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.logWriter;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.logWriter = out;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.loginTimeout = seconds;
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.loginTimeout;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new SQLException("Not supported operation");
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLException("Not supported operation");
        }
    }
}

