/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.listener.PoolLifeCycle;
import com.sun.enterprise.resource.pool.PoolManager;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.resource.common.PoolInfo;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.Singleton;

@Scoped(value=Singleton.class)
public class PoolLifeCycleRegistry
implements PoolLifeCycle {
    protected List<PoolLifeCycle> lifeCycleListeners = new ArrayList<PoolLifeCycle>();
    private static PoolLifeCycleRegistry __poolLifeCycleRegistry = new PoolLifeCycleRegistry();

    public static PoolLifeCycleRegistry getRegistry() {
        if (__poolLifeCycleRegistry == null) {
            throw new RuntimeException("PoolLifeCycleRegistry not initialized");
        }
        return __poolLifeCycleRegistry;
    }

    public void registerPoolLifeCycle(PoolLifeCycle listener) {
        this.lifeCycleListeners.add(listener);
        if (this.lifeCycleListeners.size() <= 1) {
            PoolManager poolMgr = ConnectorRuntime.getRuntime().getPoolManager();
            poolMgr.registerPoolLifeCycleListener(this);
        }
    }

    public void unRegisterPoolLifeCycle(PoolLifeCycle listener) {
        if (this.lifeCycleListeners != null && !this.lifeCycleListeners.isEmpty()) {
            this.lifeCycleListeners.remove(listener);
        }
    }

    public void poolCreated(PoolInfo poolInfo) {
        for (PoolLifeCycle listener : this.lifeCycleListeners) {
            listener.poolCreated(poolInfo);
        }
    }

    public void poolDestroyed(PoolInfo poolInfo) {
        for (PoolLifeCycle listener : this.lifeCycleListeners) {
            listener.poolDestroyed(poolInfo);
        }
    }
}

