/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectorRARClassLoader;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RARUtils {
    private static final Logger _logger = LogDomains.getLogger(RARUtils.class, (String)"javax.enterprise.resource.resourceadapter");
    private static StringManager localStrings = StringManager.getManager(RARUtils.class);

    private static Map extractRABeanProps(String raClassName, ClassLoader classLoader) throws ClassNotFoundException {
        Map hMap = new HashMap();
        if (raClassName.trim().length() != 0) {
            Class<?> c = classLoader.loadClass(raClassName);
            if (_logger.isLoggable(Level.FINER)) {
                RARUtils.printClassDetails(c);
            }
            hMap = RARUtils.getJavaBeanProperties(c);
        }
        return hMap;
    }

    private static Map getJavaBeanProperties(Class c) {
        Method[] m = c.getMethods();
        HashMap hMap = new HashMap();
        for (int i = 0; i < m.length; ++i) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer(m[i].getName());
            }
            if (!m[i].getName().startsWith("get") || !RARUtils.isValidRABeanConfigProperty(m[i].getReturnType())) continue;
            hMap.put(m[i].getName().substring(3), m[i].getReturnType());
        }
        hMap.remove("Class");
        return hMap;
    }

    public static boolean isValidRABeanConfigProperty(Class clz) {
        return clz.isPrimitive() || clz.equals(String.class) || RARUtils.isPrimitiveWrapper(clz);
    }

    private static boolean isPrimitiveWrapper(Class clz) {
        return clz.equals(Boolean.class) || clz.equals(Character.class) || clz.equals(Byte.class) || clz.equals(Short.class) || clz.equals(Integer.class) || clz.equals(Long.class) || clz.equals(Float.class) || clz.equals(Double.class);
    }

    private static void printClassDetails(Class c) {
        Method[] m = c.getMethods();
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("Methods in " + c.getName());
        }
        for (int i = 0; i < m.length; ++i) {
            if (!_logger.isLoggable(Level.FINER)) continue;
            _logger.finer(m[i].toString());
        }
    }

    public static Set getMergedActivationConfigProperties(EjbMessageBeanDescriptor msgDesc) {
        Set standardProps;
        HashSet<EnvironmentProperty> mergedProps = new HashSet<EnvironmentProperty>();
        HashSet<String> runtimePropNames = new HashSet<String>();
        Set runtimeProps = msgDesc.getRuntimeActivationConfigProperties();
        if (runtimeProps != null) {
            for (EnvironmentProperty entry : runtimeProps) {
                mergedProps.add(entry);
                String propName = entry.getName();
                runtimePropNames.add(propName);
            }
        }
        if ((standardProps = msgDesc.getActivationConfigProperties()) != null) {
            for (EnvironmentProperty entry : standardProps) {
                String propName = entry.getName();
                if (runtimePropNames.contains(propName)) continue;
                mergedProps.add(entry);
            }
        }
        return mergedProps;
    }

    public static Class loadClassFromRar(String rarName, String beanClassName) throws ConnectorRuntimeException {
        String rarLocation = RARUtils.getRarLocation(rarName);
        return RARUtils.loadClass(rarLocation, beanClassName);
    }

    private static String getRarLocation(String rarName) throws ConnectorRuntimeException {
        return ConnectorsUtil.getLocation((String)rarName);
    }

    private static Class loadClass(String pathToDeployableUnit, String beanClassName) throws ConnectorRuntimeException {
        Class<?> cls = null;
        ClassLoader cl = RARUtils.getClassLoader(pathToDeployableUnit);
        try {
            if (beanClassName != null && beanClassName.trim().length() != 0) {
                cls = cl.loadClass(beanClassName);
            }
            return cls;
        }
        catch (ClassNotFoundException e) {
            _logger.info(e.getMessage());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Unable to find class while trying to read connectordescriptor to get resource-adapter properties", e);
            }
            ConnectorRuntimeException cre = new ConnectorRuntimeException("unable to find class : " + beanClassName);
            cre.setStackTrace(e.getStackTrace());
            throw cre;
        }
    }

    private static ClassLoader getClassLoader(String file) throws ConnectorRuntimeException {
        SecureClassLoader cl = null;
        File f = new File(file);
        RARUtils.validateRARLocation(f);
        try {
            ClassLoader commonClassLoader = ConnectorRuntime.getRuntime().getClassLoaderHierarchy().getCommonClassLoader();
            if (f.isDirectory()) {
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(f.toURI().toURL());
                RARUtils.appendURLs(urls, f);
                cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), commonClassLoader);
            } else {
                cl = new ConnectorRARClassLoader(file, commonClassLoader);
            }
            return cl;
        }
        catch (IOException ioe) {
            _logger.info(ioe.getMessage());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IO Error while trying to read connectordescriptor to get resource-adapter properties", ioe);
            }
            ConnectorRuntimeException cre = new ConnectorRuntimeException("unable to read connector descriptor from : " + file);
            cre.setStackTrace(ioe.getStackTrace());
            throw cre;
        }
    }

    private static void appendURLs(List<URL> urls, File f) throws MalformedURLException {
        for (File file : f.listFiles()) {
            if (file.getName().toUpperCase().endsWith(".JAR")) {
                urls.add(file.toURI().toURL());
                continue;
            }
            if (!file.isDirectory()) continue;
            RARUtils.appendURLs(urls, file);
        }
    }

    private static void validateRARLocation(File f) throws ConnectorRuntimeException {
        if (!f.exists()) {
            String i18nMsg = localStrings.getString("rar_archive_not_found", (Object)f);
            throw new ConnectorRuntimeException(i18nMsg);
        }
    }
}

